/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.graph.gremlin;

import com.orientechnologies.orient.client.db.ODatabaseHelper;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.graph.OGraphDatabase;
import com.tinkerpop.blueprints.pgm.Graph;
import com.tinkerpop.blueprints.pgm.impls.orientdb.OrientGraph;
import com.tinkerpop.blueprints.pgm.util.io.graphml.GraphMLReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.testng.annotations.Test;

public class TestLoadGraph {
    private static final String INPUT_FILE = "target/test-classes/graph-example-2.xml";
    private static final String DBURL = "local:target/databases/tinkerpop";
    private String inputFile = "target/test-classes/graph-example-2.xml";
    private String dbURL = "local:target/databases/tinkerpop";

    public static void main(String[] args) throws Exception {
        new TestLoadGraph(args).testImport();
    }

    public TestLoadGraph() {
        this.inputFile = INPUT_FILE;
        this.dbURL = DBURL;
    }

    public TestLoadGraph(String[] args) {
        this.inputFile = args.length > 0 ? args[0] : INPUT_FILE;
        this.dbURL = args.length > 1 ? args[1] : DBURL;
    }

    @Test
    public void testImport() throws IOException, FileNotFoundException {
        OGlobalConfiguration.STORAGE_KEEP_OPEN.setValue((Object)false);
        OGraphDatabase db = new OGraphDatabase(DBURL);
        ODatabaseHelper.deleteDatabase((ODatabase)db);
        OrientGraph g = new OrientGraph(this.dbURL);
        System.out.println("Importing graph from file '" + this.inputFile + "' into database: " + g + "...");
        long startTime = System.currentTimeMillis();
        g.setMaxBufferSize(0);
        GraphMLReader.inputGraph((Graph)g, (InputStream)new FileInputStream(this.inputFile), (int)100000, null, null, null);
        System.out.println("Imported in " + (System.currentTimeMillis() - startTime) + "ms. Vertexes: " + g.getRawGraph().countVertexes() + ", Edges: " + g.getRawGraph().countEdges());
        g.shutdown();
    }
}

