/*
 * Decompiled with CFR 0.152.
 */
package jtbc.image;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;

public class imageResize {
    private int iWidth;
    private int iHeight;
    private int iScaleWidth;
    private int iDotsA;
    private int iDotsB;
    private double[] iContribA;
    private double[] iContribB;
    private double[] iContribC;

    public Boolean saveImageAsJPEG(String string, String string2, int n, int n2) {
        Boolean bl = false;
        String string3 = string;
        String string4 = string2;
        int n3 = n;
        int n4 = n2;
        bl = this.saveImageAsJPEG(string3, string4, n3, n4, 1);
        return bl;
    }

    public Boolean saveImageAsJPEG(String string, String string2, int n, int n2, int n3) {
        Boolean bl = false;
        try {
            String string3 = string;
            String string4 = string2;
            int n4 = n;
            int n5 = n2;
            int n6 = n3;
            File file = new File(string3);
            File file2 = new File(string4);
            BufferedImage bufferedImage = ImageIO.read(file);
            int n7 = n4;
            int n8 = n5;
            if (n6 == 1) {
                int n9 = bufferedImage.getWidth(null);
                int n10 = bufferedImage.getHeight(null);
                if (n9 > 0 && n10 > 0) {
                    if (n9 / n10 >= n4 / n5) {
                        if (n9 > n4) {
                            n7 = n4;
                            n8 = n10 * n4 / n9;
                        } else {
                            n7 = n9;
                            n8 = n10;
                        }
                    } else if (n10 > n5) {
                        n7 = n9 * n5 / n10;
                        n8 = n5;
                    } else {
                        n7 = n9;
                        n8 = n10;
                    }
                }
            }
            bufferedImage = this.imageZoomOut(bufferedImage, n7, n8);
            ImageIO.write((RenderedImage)bufferedImage, "JPEG", file2);
            bl = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    private BufferedImage imageZoomOut(BufferedImage bufferedImage, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        BufferedImage bufferedImage2 = bufferedImage;
        this.iWidth = bufferedImage2.getWidth();
        this.iHeight = bufferedImage2.getHeight();
        this.iScaleWidth = n3;
        this.callContrib();
        BufferedImage bufferedImage3 = this.horizontalFiltering(bufferedImage2, n3);
        BufferedImage bufferedImage4 = this.verticalFiltering(bufferedImage3, n4);
        return bufferedImage4;
    }

    private double lanczos(int n, int n2, int n3, double d) {
        int n4 = n;
        int n5 = n2;
        int n6 = n3;
        double d2 = d;
        double d3 = 3.14159265358978;
        double d4 = (double)n4 * (double)n6 / (double)n5;
        d4 = Math.sin(d4 * d3) / (d4 * d3) * Math.sin(d4 * d3 / d2) / (d4 * d3 / d2);
        return d4;
    }

    private void callContrib() {
        int n;
        double d = 3.0;
        this.iDotsB = (int)((double)this.iWidth * d / (double)this.iScaleWidth);
        this.iDotsA = this.iDotsB * 2 + 1;
        try {
            this.iContribA = new double[this.iDotsA];
            this.iContribB = new double[this.iDotsA];
            this.iContribC = new double[this.iDotsA];
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n2 = this.iDotsB;
        this.iContribA[n2] = 1.0;
        double d2 = 0.0;
        for (n = 1; n <= n2; ++n) {
            this.iContribA[n2 + n] = this.lanczos(n, this.iWidth, this.iScaleWidth, d);
            d2 += this.iContribA[n2 + n];
        }
        for (n = n2 - 1; n >= 0; --n) {
            this.iContribA[n] = this.iContribA[n2 * 2 - n];
        }
        d2 = d2 * 2.0 + 1.0;
        for (n = 0; n <= n2; ++n) {
            this.iContribB[n] = this.iContribA[n] / d2;
        }
        for (n = n2 + 1; n < this.iDotsA; ++n) {
            this.iContribB[n] = this.iContribB[n2 * 2 - n];
        }
    }

    private void calContribB(int n, int n2) {
        int n3;
        double d = 0.0;
        int n4 = n;
        int n5 = n2;
        for (n3 = n4; n3 <= n5; ++n3) {
            d += this.iContribA[n3];
        }
        for (n3 = n4; n3 <= n5; ++n3) {
            this.iContribC[n3] = this.iContribA[n3] / d;
        }
    }

    private int getRedValue(int n) {
        int n2 = n;
        int n3 = n2 & 0xFF0000;
        return n3 >>= 16;
    }

    private int getGreenValue(int n) {
        int n2 = n;
        int n3 = n2 & 0xFF00;
        return n3 >>= 8;
    }

    private int getBlueValue(int n) {
        int n2 = n;
        int n3 = n2 & 0xFF;
        return n3;
    }

    private int comRGB(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = n;
        int n6 = n2;
        int n7 = n3;
        n4 = (n5 << 16) + (n6 << 8) + n7;
        return n4;
    }

    private int horizontalFilter(BufferedImage bufferedImage, int n, int n2, int n3, int n4, int n5, double[] dArray) {
        int n6 = n5;
        int n7 = 0;
        int n8 = n;
        int n9 = n2;
        int n10 = n3;
        int n11 = n4;
        double[] dArray2 = dArray;
        BufferedImage bufferedImage2 = bufferedImage;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n12 = n8;
        int n13 = n10;
        while (n12 <= n9) {
            n7 = bufferedImage2.getRGB(n12, n6);
            d += (double)this.getRedValue(n7) * dArray2[n13];
            d2 += (double)this.getGreenValue(n7) * dArray2[n13];
            d3 += (double)this.getBlueValue(n7) * dArray2[n13];
            ++n12;
            ++n13;
        }
        n7 = this.comRGB(this.clip((int)d), this.clip((int)d2), this.clip((int)d3));
        return n7;
    }

    private BufferedImage horizontalFiltering(BufferedImage bufferedImage, int n) {
        int n2 = n;
        BufferedImage bufferedImage2 = bufferedImage;
        int n3 = bufferedImage2.getWidth();
        int n4 = bufferedImage2.getHeight();
        int n5 = 0;
        BufferedImage bufferedImage3 = new BufferedImage(n2, n4, 1);
        for (int i = 0; i < n2; ++i) {
            int n6;
            int n7;
            int n8 = (int)((double)i * (double)n3 / (double)n2 + 0.5);
            int n9 = 0;
            int n10 = n8 - this.iDotsB;
            if (n10 < 0) {
                n10 = 0;
                n7 = this.iDotsB - n8;
            } else {
                n7 = 0;
            }
            int n11 = n8 + this.iDotsB;
            if (n11 > n3 - 1) {
                n11 = n3 - 1;
                n6 = this.iDotsB + (n3 - 1 - n8);
            } else {
                n6 = this.iDotsB * 2;
            }
            if (n7 > 0 || n6 < this.iDotsA - 1) {
                this.calContribB(n7, n6);
                for (n9 = 0; n9 < n4; ++n9) {
                    n5 = this.horizontalFilter(bufferedImage2, n10, n11, n7, n6, n9, this.iContribC);
                    bufferedImage3.setRGB(i, n9, n5);
                }
                continue;
            }
            for (n9 = 0; n9 < n4; ++n9) {
                n5 = this.horizontalFilter(bufferedImage2, n10, n11, n7, n6, n9, this.iContribB);
                bufferedImage3.setRGB(i, n9, n5);
            }
        }
        return bufferedImage3;
    }

    private int verticalFilter(BufferedImage bufferedImage, int n, int n2, int n3, int n4, int n5, double[] dArray) {
        int n6 = n5;
        int n7 = 0;
        int n8 = n;
        int n9 = n2;
        int n10 = n3;
        int n11 = n4;
        double[] dArray2 = dArray;
        BufferedImage bufferedImage2 = bufferedImage;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n12 = n8;
        int n13 = n10;
        while (n12 <= n9) {
            n7 = bufferedImage2.getRGB(n6, n12);
            d += (double)this.getRedValue(n7) * dArray2[n13];
            d2 += (double)this.getGreenValue(n7) * dArray2[n13];
            d3 += (double)this.getBlueValue(n7) * dArray2[n13];
            ++n12;
            ++n13;
        }
        n7 = this.comRGB(this.clip((int)d), this.clip((int)d2), this.clip((int)d3));
        return n7;
    }

    private BufferedImage verticalFiltering(BufferedImage bufferedImage, int n) {
        int n2 = n;
        BufferedImage bufferedImage2 = bufferedImage;
        int n3 = bufferedImage2.getWidth();
        int n4 = bufferedImage2.getHeight();
        int n5 = 0;
        BufferedImage bufferedImage3 = new BufferedImage(n3, n2, 1);
        for (int i = 0; i < n2; ++i) {
            int n6;
            int n7;
            int n8;
            int n9 = (int)((double)i * (double)n4 / (double)n2 + 0.5);
            int n10 = n9 - this.iDotsB;
            if (n10 < 0) {
                n10 = 0;
                n8 = this.iDotsB - n9;
            } else {
                n8 = 0;
            }
            int n11 = n9 + this.iDotsB;
            if (n11 > n4 - 1) {
                n11 = n4 - 1;
                n7 = this.iDotsB + (n4 - 1 - n9);
            } else {
                n7 = this.iDotsB * 2;
            }
            if (n8 > 0 || n7 < this.iDotsA - 1) {
                this.calContribB(n8, n7);
                for (n6 = 0; n6 < n3; ++n6) {
                    n5 = this.verticalFilter(bufferedImage2, n10, n11, n8, n7, n6, this.iContribC);
                    bufferedImage3.setRGB(n6, i, n5);
                }
                continue;
            }
            for (n6 = 0; n6 < n3; ++n6) {
                n5 = this.verticalFilter(bufferedImage2, n10, n11, n8, n7, n6, this.iContribB);
                bufferedImage3.setRGB(n6, i, n5);
            }
        }
        return bufferedImage3;
    }

    private int clip(int n) {
        int n2 = n;
        int n3 = 220;
        n3 = n2 < 0 ? 0 : (n2 > 255 ? 255 : n2);
        return n3;
    }
}

