/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.jivejdon.auth.jaas;

import com.jdon.jivejdon.auth.jaas.PropertiesUtil;
import com.jdon.jivejdon.auth.jaas.RolesProvider;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class DefaultRolesProvider
implements RolesProvider {
    private static String AUTH_SQL = "select r.name from role as r,user as u,users_roles as ur where u.name=? and password=? and  ur.userId=u.userId and ur.roleId=r.roleId";

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<String> provideRoles(String username, String password) {
        ArrayList<String> roles = new ArrayList<String>();
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String datasource = PropertiesUtil.getProperty("JAAS_DATASOURCE");
            con = this.getConnection(datasource);
            ps = con.prepareStatement(AUTH_SQL, 1004, 1007);
            ps.setString(1, username);
            ps.setString(2, password);
            rs = ps.executeQuery();
            while (true) {
                if (!rs.next()) {
                    this.release(rs, ps, con);
                    this.release(rs, ps, con);
                    return roles;
                }
                String name = rs.getString("name");
                roles.add(name);
            }
        }
        catch (NamingException ne) {
            try {
                throw new RuntimeException(ne);
                catch (SQLException sqlEx) {
                    throw new RuntimeException(sqlEx);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            catch (Throwable throwable) {
                this.release(rs, ps, con);
                throw throwable;
            }
        }
    }

    private Connection getConnection(String datasource) throws NamingException, SQLException {
        InitialContext ic = new InitialContext();
        DataSource dataSource = (DataSource)ic.lookup(datasource);
        Connection con = dataSource.getConnection();
        return con;
    }

    private void release(ResultSet rs, PreparedStatement ps, Connection con) {
        try {
            if (rs != null) {
                rs.close();
            }
            if (ps != null) {
                ps.close();
            }
            if (con != null) {
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

