/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.jivejdon.auth.jaas;

import com.jdon.jivejdon.auth.jaas.DefaultRolesProvider;
import com.jdon.jivejdon.auth.jaas.DigestUtil;
import com.jdon.jivejdon.auth.jaas.Role;
import com.jdon.jivejdon.auth.jaas.RolesProvider;
import com.jdon.jivejdon.auth.jaas.User;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class JiveJdonLoginMoudle
implements LoginModule {
    private Subject _subject;
    private CallbackHandler _callbackHandler;
    private boolean succeeded = false;
    private String username;
    private List<String> roles = new ArrayList<String>();
    private RolesProvider rolesProvider = new DefaultRolesProvider();

    @Override
    public boolean abort() {
        return true;
    }

    @Override
    public boolean commit() {
        if (this.succeeded) {
            this._subject.getPrincipals().add(new User(this.username));
            for (String role : this.roles) {
                this._subject.getPrincipals().add(new Role(role));
            }
            return true;
        }
        return false;
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this._subject = subject;
        this._callbackHandler = callbackHandler;
    }

    @Override
    public boolean login() throws LoginException {
        try {
            this.authenticate();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new LoginException();
        }
        return this.succeeded;
    }

    @Override
    public boolean logout() {
        this._subject.getPrincipals().clear();
        return true;
    }

    private void authenticate() throws IOException, UnsupportedCallbackException {
        NameCallback nameCallback = new NameCallback("name: ");
        PasswordCallback passwordCallback = new PasswordCallback("password: ", false);
        this._callbackHandler.handle(new Callback[]{nameCallback, passwordCallback});
        this.username = nameCallback.getName();
        String password = null;
        char[] passwordChar = passwordCallback.getPassword();
        if (passwordChar != null) {
            password = new String(passwordChar);
            this.roles = this.rolesProvider.provideRoles(this.username, DigestUtil.hash(password));
        }
        if (this.roles.size() > 0) {
            this.succeeded = true;
        }
    }
}

