/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.time;

import com.ocpsoft.pretty.time.BasicTimeFormat;
import com.ocpsoft.pretty.time.TimeFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public abstract class AbstractTimeUnit {
    protected Locale locale;
    protected TimeFormat format;
    protected String name;
    protected String pluralName;
    protected long maxQuantity = 0L;
    protected long millisPerUnit = 1L;

    public AbstractTimeUnit(Locale locale) {
        this.locale = locale;
        ResourceBundle bundle = ResourceBundle.getBundle("com.ocpsoft.pretty.time.i18n.Resources", locale);
        String pattern = bundle.getString(String.valueOf(this.getResourceKeyPrefix()) + "Pattern");
        String futurePrefix = bundle.getString(String.valueOf(this.getResourceKeyPrefix()) + "FuturePrefix");
        String futureSuffix = bundle.getString(String.valueOf(this.getResourceKeyPrefix()) + "FutureSuffix");
        String pastPrefix = bundle.getString(String.valueOf(this.getResourceKeyPrefix()) + "PastPrefix");
        String pastSuffix = bundle.getString(String.valueOf(this.getResourceKeyPrefix()) + "PastSuffix");
        this.format = new BasicTimeFormat().setPattern(pattern).setFuturePrefix(futurePrefix).setFutureSuffix(futureSuffix).setPastPrefix(pastPrefix).setPastSuffix(pastSuffix);
        this.name = bundle.getString(String.valueOf(this.getResourceKeyPrefix()) + "Name");
        this.pluralName = bundle.getString(String.valueOf(this.getResourceKeyPrefix()) + "PluralName");
    }

    protected abstract String getResourceKeyPrefix();
}

