/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.disruptor;

import com.lmax.disruptor.EventTranslator;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.TimeoutException;
import java.util.concurrent.TimeUnit;

public class EventPublisher<E> {
    private final RingBuffer<E> ringBuffer;

    public EventPublisher(RingBuffer<E> ringBuffer) {
        this.ringBuffer = ringBuffer;
    }

    public void publishEvent(EventTranslator<E> translator) {
        long sequence = this.ringBuffer.next();
        this.translateAndPublish(translator, sequence);
    }

    public void publishEvent(EventTranslator<E> translator, long timeout, TimeUnit units) throws TimeoutException {
        long sequence = this.ringBuffer.next(timeout, units);
        this.translateAndPublish(translator, sequence);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void translateAndPublish(EventTranslator<E> translator, long sequence) {
        try {
            translator.translateTo(this.ringBuffer.get(sequence), sequence);
        }
        finally {
            this.ringBuffer.publish(sequence);
        }
    }
}

