/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.disruptor;

import com.lmax.disruptor.ClaimStrategy;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.util.MutableLong;
import com.lmax.disruptor.util.PaddedAtomicLong;
import com.lmax.disruptor.util.Util;
import java.util.concurrent.locks.LockSupport;

public final class MultiThreadedLowContentionClaimStrategy
implements ClaimStrategy {
    private final int bufferSize;
    private final PaddedAtomicLong claimSequence = new PaddedAtomicLong(-1L);
    private final ThreadLocal<MutableLong> minGatingSequenceThreadLocal = new ThreadLocal<MutableLong>(){

        @Override
        protected MutableLong initialValue() {
            return new MutableLong(-1L);
        }
    };

    public MultiThreadedLowContentionClaimStrategy(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    @Override
    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public long getSequence() {
        return this.claimSequence.get();
    }

    @Override
    public boolean hasAvailableCapacity(int availableCapacity, Sequence[] dependentSequences) {
        MutableLong minGatingSequence;
        long wrapPoint = this.claimSequence.get() + (long)availableCapacity - (long)this.bufferSize;
        if (wrapPoint > (minGatingSequence = this.minGatingSequenceThreadLocal.get()).get()) {
            long minSequence = Util.getMinimumSequence(dependentSequences);
            minGatingSequence.set(minSequence);
            if (wrapPoint > minSequence) {
                return false;
            }
        }
        return true;
    }

    @Override
    public long incrementAndGet(Sequence[] dependentSequences) {
        MutableLong minGatingSequence = this.minGatingSequenceThreadLocal.get();
        this.waitForCapacity(dependentSequences, minGatingSequence);
        long nextSequence = this.claimSequence.incrementAndGet();
        this.waitForFreeSlotAt(nextSequence, dependentSequences, minGatingSequence);
        return nextSequence;
    }

    @Override
    public long incrementAndGet(int delta, Sequence[] dependentSequences) {
        long nextSequence = this.claimSequence.addAndGet(delta);
        this.waitForFreeSlotAt(nextSequence, dependentSequences, this.minGatingSequenceThreadLocal.get());
        return nextSequence;
    }

    @Override
    public void setSequence(long sequence, Sequence[] dependentSequences) {
        this.claimSequence.lazySet(sequence);
        this.waitForFreeSlotAt(sequence, dependentSequences, this.minGatingSequenceThreadLocal.get());
    }

    @Override
    public void serialisePublishing(long sequence, Sequence cursor, int batchSize) {
        long expectedSequence = sequence - (long)batchSize;
        while (expectedSequence != cursor.get()) {
        }
        cursor.set(sequence);
    }

    private void waitForCapacity(Sequence[] dependentSequences, MutableLong minGatingSequence) {
        long wrapPoint = this.claimSequence.get() + 1L - (long)this.bufferSize;
        if (wrapPoint > minGatingSequence.get()) {
            long minSequence;
            while (wrapPoint > (minSequence = Util.getMinimumSequence(dependentSequences))) {
                LockSupport.parkNanos(1L);
            }
            minGatingSequence.set(minSequence);
        }
    }

    private void waitForFreeSlotAt(long sequence, Sequence[] dependentSequences, MutableLong minGatingSequence) {
        long wrapPoint = sequence - (long)this.bufferSize;
        if (wrapPoint > minGatingSequence.get()) {
            long minSequence;
            while (wrapPoint > (minSequence = Util.getMinimumSequence(dependentSequences))) {
                LockSupport.parkNanos(1L);
            }
            minGatingSequence.set(minSequence);
        }
    }
}

