/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.disruptor;

import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.ClaimStrategy;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.MultiThreadedClaimStrategy;
import com.lmax.disruptor.Sequencer;
import com.lmax.disruptor.WaitStrategy;

public final class RingBuffer<T>
extends Sequencer {
    private final int indexMask;
    private final Object[] entries;

    public RingBuffer(EventFactory<T> eventFactory, ClaimStrategy claimStrategy, WaitStrategy waitStrategy) {
        super(claimStrategy, waitStrategy);
        if (Integer.bitCount(claimStrategy.getBufferSize()) != 1) {
            throw new IllegalArgumentException("bufferSize must be a power of 2");
        }
        this.indexMask = claimStrategy.getBufferSize() - 1;
        this.entries = new Object[claimStrategy.getBufferSize()];
        this.fill(eventFactory);
    }

    public RingBuffer(EventFactory<T> eventFactory, int bufferSize) {
        this(eventFactory, new MultiThreadedClaimStrategy(bufferSize), new BlockingWaitStrategy());
    }

    public T get(long sequence) {
        return (T)this.entries[(int)sequence & this.indexMask];
    }

    private void fill(EventFactory<T> eventFactory) {
        for (int i = 0; i < this.entries.length; ++i) {
            this.entries[i] = eventFactory.newInstance();
        }
    }
}

