/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.disruptor;

import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.util.Util;
import java.util.concurrent.atomic.AtomicReference;

public final class SequenceGroup
extends Sequence {
    private final AtomicReference<Sequence[]> sequencesRef = new AtomicReference<Sequence[]>(new Sequence[0]);

    @Override
    public long get() {
        return Util.getMinimumSequence(this.sequencesRef.get());
    }

    @Override
    public void set(long value) {
        Sequence[] sequences = this.sequencesRef.get();
        int size = sequences.length;
        for (int i = 0; i < size; ++i) {
            sequences[i].set(value);
        }
    }

    public void add(Sequence sequence) {
        Sequence[] newSequences;
        Sequence[] oldSequences;
        do {
            oldSequences = this.sequencesRef.get();
            int oldSize = oldSequences.length;
            newSequences = new Sequence[oldSize + 1];
            System.arraycopy(oldSequences, 0, newSequences, 0, oldSize);
            newSequences[oldSize] = sequence;
        } while (!this.sequencesRef.compareAndSet(oldSequences, newSequences));
    }

    public boolean remove(Sequence sequence) {
        Sequence[] newSequences;
        Sequence[] oldSequences;
        boolean found = false;
        do {
            oldSequences = this.sequencesRef.get();
            int oldSize = oldSequences.length;
            newSequences = new Sequence[oldSize - 1];
            int pos = 0;
            for (int i = 0; i < oldSize; ++i) {
                Sequence testSequence = oldSequences[i];
                if (sequence == testSequence && !found) {
                    found = true;
                    continue;
                }
                newSequences[pos++] = testSequence;
            }
        } while (found && !this.sequencesRef.compareAndSet(oldSequences, newSequences));
        return found;
    }

    public int size() {
        return this.sequencesRef.get().length;
    }
}

