/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.disruptor;

import com.lmax.disruptor.ClaimStrategy;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.util.PaddedLong;
import com.lmax.disruptor.util.Util;
import java.util.concurrent.locks.LockSupport;

public final class SingleThreadedClaimStrategy
implements ClaimStrategy {
    private final int bufferSize;
    private final PaddedLong minGatingSequence = new PaddedLong(-1L);
    private final PaddedLong claimSequence = new PaddedLong(-1L);

    public SingleThreadedClaimStrategy(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    @Override
    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public long getSequence() {
        return this.claimSequence.get();
    }

    @Override
    public boolean hasAvailableCapacity(int availableCapacity, Sequence[] dependentSequences) {
        long wrapPoint = this.claimSequence.get() + (long)availableCapacity - (long)this.bufferSize;
        if (wrapPoint > this.minGatingSequence.get()) {
            long minSequence = Util.getMinimumSequence(dependentSequences);
            this.minGatingSequence.set(minSequence);
            if (wrapPoint > minSequence) {
                return false;
            }
        }
        return true;
    }

    @Override
    public long incrementAndGet(Sequence[] dependentSequences) {
        long nextSequence = this.claimSequence.get() + 1L;
        this.claimSequence.set(nextSequence);
        this.waitForFreeSlotAt(nextSequence, dependentSequences);
        return nextSequence;
    }

    @Override
    public long incrementAndGet(int delta, Sequence[] dependentSequences) {
        long nextSequence = this.claimSequence.get() + (long)delta;
        this.claimSequence.set(nextSequence);
        this.waitForFreeSlotAt(nextSequence, dependentSequences);
        return nextSequence;
    }

    @Override
    public void setSequence(long sequence, Sequence[] dependentSequences) {
        this.claimSequence.set(sequence);
        this.waitForFreeSlotAt(sequence, dependentSequences);
    }

    @Override
    public void serialisePublishing(long sequence, Sequence cursor, int batchSize) {
        cursor.set(sequence);
    }

    private void waitForFreeSlotAt(long sequence, Sequence[] dependentSequences) {
        long wrapPoint = sequence - (long)this.bufferSize;
        if (wrapPoint > this.minGatingSequence.get()) {
            long minSequence;
            while (wrapPoint > (minSequence = Util.getMinimumSequence(dependentSequences))) {
                LockSupport.parkNanos(1L);
            }
            this.minGatingSequence.set(minSequence);
        }
    }
}

