/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.Lock;
import org.compass.core.CompassSession;
import org.compass.core.CompassTransaction;
import org.compass.core.lucene.engine.LuceneSearchEngine;
import org.compass.core.lucene.engine.manager.LuceneSearchEngineIndexManager;
import org.compass.core.spi.InternalCompassSession;

public class LuceneSubIndexInfo {
    private ArrayList segmentInfos;
    private long version;
    private String subIndex;

    protected LuceneSubIndexInfo(String subIndex, long version, ArrayList segmentInfos) {
        this.subIndex = subIndex;
        this.version = version;
        this.segmentInfos = segmentInfos;
    }

    public long version() {
        return this.version;
    }

    public int size() {
        return this.segmentInfos.size();
    }

    public LuceneSegmentInfo info(int segmentIndex) {
        return (LuceneSegmentInfo)this.segmentInfos.get(segmentIndex);
    }

    public String getSubIndex() {
        return this.subIndex;
    }

    public static LuceneSubIndexInfo getIndexInfoByAlias(String alias, CompassSession session) throws IOException {
        LuceneSearchEngine searchEngine = (LuceneSearchEngine)((InternalCompassSession)session).getSearchEngine();
        LuceneSearchEngineIndexManager indexManager = (LuceneSearchEngineIndexManager)searchEngine.getSearchEngineFactory().getIndexManager();
        CompassTransaction tx = null;
        try {
            tx = session.beginTransaction();
            LuceneSubIndexInfo info = LuceneSubIndexInfo.getIndexInfo(indexManager.getStore().getSubIndexForAlias(alias), indexManager);
            tx.commit();
            return info;
        }
        catch (RuntimeException e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e1) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LuceneSubIndexInfo getIndexInfo(String subIndex, LuceneSearchEngineIndexManager indexManager) throws IOException {
        final Directory directory = indexManager.getStore().getDirectoryBySubIndex(subIndex, false);
        try {
            LuceneSubIndexInfo luceneSegmentInfos;
            final SegmentInfos segmentInfos = new SegmentInfos();
            Directory directory2 = directory;
            synchronized (directory2) {
                new Lock.With(directory.makeLock("commit.lock"), 10000L){

                    public Object doBody() throws IOException {
                        segmentInfos.read(directory);
                        return null;
                    }
                }.run();
            }
            ArrayList<LuceneSegmentInfo> segmentInfosList = new ArrayList<LuceneSegmentInfo>();
            for (int i = 0; i < segmentInfos.size(); ++i) {
                SegmentInfo segmentInfo = segmentInfos.info(i);
                LuceneSegmentInfo luceneSegmentInfo = new LuceneSegmentInfo(segmentInfo.name, segmentInfo.docCount);
                segmentInfosList.add(luceneSegmentInfo);
            }
            LuceneSubIndexInfo luceneSubIndexInfo = luceneSegmentInfos = new LuceneSubIndexInfo(subIndex, segmentInfos.getVersion(), segmentInfosList);
            return luceneSubIndexInfo;
        }
        catch (FileNotFoundException e) {
            LuceneSubIndexInfo luceneSubIndexInfo = null;
            return luceneSubIndexInfo;
        }
        finally {
            try {
                directory.close();
            }
            catch (IOException e) {}
        }
    }

    public static class LuceneSegmentInfo {
        private String name;
        private int docCount;

        public LuceneSegmentInfo(String name, int docCount) {
            this.name = name;
            this.docCount = docCount;
        }

        public String name() {
            return this.name;
        }

        public int docCount() {
            return this.docCount;
        }
    }
}

