/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store.jdbc.datasource;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.lucene.store.jdbc.JdbcStoreException;
import org.apache.lucene.store.jdbc.datasource.ConnectionProxy;

public abstract class DataSourceUtils {
    public static boolean controlConnection(Connection connection) {
        return connection instanceof ConnectionProxy && ((ConnectionProxy)connection).controlConnection();
    }

    public static Connection getConnection(DataSource dataSource) throws JdbcStoreException {
        try {
            return dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new JdbcStoreException("Failed to open jdbc connection", e);
        }
    }

    public static void releaseConnection(Connection con) {
        if (con == null) {
            return;
        }
        if (!(con instanceof ConnectionProxy) || DataSourceUtils.controlConnection(con)) {
            try {
                con.close();
            }
            catch (SQLException ex) {
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    public static void commitConnectionIfPossible(Connection con) throws JdbcStoreException {
        try {
            if (con != null && DataSourceUtils.controlConnection(con)) {
                con.commit();
            }
        }
        catch (SQLException e) {
            throw new JdbcStoreException("Failed to commit jdbc connection", e);
        }
    }

    public static void safeCommitConnectionIfPossible(Connection con) {
        try {
            if (con != null && DataSourceUtils.controlConnection(con)) {
                con.commit();
            }
        }
        catch (SQLException e) {
            DataSourceUtils.safeRollbackConnectionIfPossible(con);
        }
    }

    public static void rollbackConnectionIfPossible(Connection con) throws JdbcStoreException {
        try {
            if (con != null && DataSourceUtils.controlConnection(con)) {
                con.rollback();
            }
        }
        catch (SQLException e) {
            throw new JdbcStoreException("Failed to rollback jdbc connection", e);
        }
    }

    public static void safeRollbackConnectionIfPossible(Connection con) {
        try {
            if (con != null && DataSourceUtils.controlConnection(con)) {
                con.rollback();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void closeStatement(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException ex) {
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    public static void closeResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException ex) {
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    public static int getColumnIndexFromColumnName(ResultSetMetaData metaData, String columnName) throws SQLException {
        for (int i = 1; i <= metaData.getColumnCount(); ++i) {
            String tmpName = metaData.getColumnLabel(i);
            if (!tmpName.equalsIgnoreCase(columnName)) continue;
            return i;
        }
        return -1;
    }

    public static Connection getTargetConnection(Connection conn) {
        if (conn instanceof ConnectionProxy) {
            return ((ConnectionProxy)conn).getTargetConnection();
        }
        return conn;
    }
}

