/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store.jdbc.index;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.sql.PreparedStatement;
import org.apache.lucene.store.jdbc.JdbcDirectory;
import org.apache.lucene.store.jdbc.JdbcFileEntrySettings;
import org.apache.lucene.store.jdbc.index.JdbcBufferedIndexOutput;
import org.apache.lucene.store.jdbc.support.InputStreamBlob;
import org.apache.lucene.store.jdbc.support.JdbcTemplate;

public class FileJdbcIndexOutput
extends JdbcBufferedIndexOutput {
    private String name;
    private JdbcDirectory jdbcDirectory;
    private RandomAccessFile file = null;

    public void configure(String name, JdbcDirectory jdbcDirectory, JdbcFileEntrySettings settings) throws IOException {
        super.configure(name, jdbcDirectory, settings);
        File tempFile = File.createTempFile(jdbcDirectory.getTable().getName() + "_" + name + "_" + System.currentTimeMillis(), ".ljt");
        tempFile.deleteOnExit();
        this.file = new RandomAccessFile(tempFile, "rw");
        this.jdbcDirectory = jdbcDirectory;
        this.name = name;
    }

    public void flushBuffer(byte[] b, int size) throws IOException {
        this.file.write(b, 0, size);
    }

    public void seek(long pos) throws IOException {
        super.seek(pos);
        this.file.seek(pos);
    }

    public long length() throws IOException {
        return this.file.length();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.file.close();
    }

    public void close() throws IOException {
        super.close();
        final long length = this.length();
        this.file.seek(0L);
        this.jdbcDirectory.getJdbcTemplate().executeUpdate(this.jdbcDirectory.getTable().sqlInsert(), new JdbcTemplate.PrepateStatementAwareCallback(){

            public void fillPrepareStatement(PreparedStatement ps) throws Exception {
                ps.setFetchSize(1);
                ps.setString(1, FileJdbcIndexOutput.this.name);
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(FileJdbcIndexOutput.this.file.getFD()));
                if (FileJdbcIndexOutput.this.jdbcDirectory.getDialect().useInputStreamToInsertBlob()) {
                    ps.setBinaryStream(2, (InputStream)is, (int)FileJdbcIndexOutput.this.length());
                } else {
                    ps.setBlob(2, new InputStreamBlob(is, length));
                }
                ps.setLong(3, length);
                ps.setBoolean(4, false);
            }
        });
        this.file.close();
    }
}

