/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store.jdbc.index;

import java.io.IOException;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.jdbc.JdbcDirectory;
import org.apache.lucene.store.jdbc.JdbcFileEntrySettings;
import org.apache.lucene.store.jdbc.index.JdbcIndexConfigurable;

public abstract class JdbcBufferedIndexOutput
extends IndexOutput
implements JdbcIndexConfigurable {
    public static final String BUFFER_SIZE_SETTING = "indexOutput.bufferSize";
    public static final int DEFAULT_BUFFER_SIZE = 1024;
    private byte[] buffer;
    private long bufferStart = 0L;
    private int bufferPosition = 0;
    protected int bufferSize;

    public void configure(String name, JdbcDirectory jdbcDirectory, JdbcFileEntrySettings settings) throws IOException {
        this.bufferSize = settings.getSettingAsInt(BUFFER_SIZE_SETTING, 1024);
        this.buffer = new byte[this.bufferSize];
    }

    public void writeByte(byte b) throws IOException {
        if (this.bufferPosition >= this.bufferSize) {
            this.flush();
        }
        this.buffer[this.bufferPosition++] = b;
    }

    public void writeBytes(byte[] b, int length) throws IOException {
        int bytesLeft = this.bufferSize - this.bufferPosition;
        if (bytesLeft >= length) {
            System.arraycopy(b, 0, this.buffer, this.bufferPosition, length);
            this.bufferPosition += length;
            if (this.bufferSize - this.bufferPosition == 0) {
                this.flush();
            }
        } else if (length > this.bufferSize) {
            if (this.bufferPosition > 0) {
                this.flush();
            }
            this.flushBuffer(b, length);
            this.bufferStart += (long)length;
        } else {
            int pos = 0;
            while (pos < length) {
                int pieceLength = length - pos < bytesLeft ? length - pos : bytesLeft;
                System.arraycopy(b, pos, this.buffer, this.bufferPosition, pieceLength);
                pos += pieceLength;
                this.bufferPosition += pieceLength;
                bytesLeft = this.bufferSize - this.bufferPosition;
                if (bytesLeft != 0) continue;
                this.flush();
                bytesLeft = this.bufferSize;
            }
        }
    }

    public void flush() throws IOException {
        this.flushBuffer(this.buffer, this.bufferPosition);
        this.bufferStart += (long)this.bufferPosition;
        this.bufferPosition = 0;
    }

    protected abstract void flushBuffer(byte[] var1, int var2) throws IOException;

    public void close() throws IOException {
        this.flush();
    }

    public long getFilePointer() {
        return this.bufferStart + (long)this.bufferPosition;
    }

    public void seek(long pos) throws IOException {
        this.flush();
        this.bufferStart = pos;
    }

    public abstract long length() throws IOException;
}

