/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store.jdbc.support;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.lucene.store.jdbc.JdbcDirectorySettings;
import org.apache.lucene.store.jdbc.JdbcStoreException;
import org.apache.lucene.store.jdbc.datasource.DataSourceUtils;

public class JdbcTemplate {
    private DataSource dataSource;
    private JdbcDirectorySettings settings;

    public JdbcTemplate(DataSource dataSource, JdbcDirectorySettings settings) {
        this.dataSource = dataSource;
        this.settings = settings;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object executeSelect(String sql, ExecuteSelectCallback callback) throws JdbcStoreException {
        Object object;
        Connection con = DataSourceUtils.getConnection(this.dataSource);
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = con.prepareStatement(sql);
            ps.setQueryTimeout(this.settings.getQueryTimeout());
            callback.fillPrepareStatement(ps);
            rs = ps.executeQuery();
            object = callback.execute(rs);
        }
        catch (JdbcStoreException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new JdbcStoreException("Failed to execute sql [" + sql + "]", e2);
                }
            }
            catch (Throwable throwable) {
                DataSourceUtils.closeResultSet(rs);
                DataSourceUtils.closeStatement(ps);
                DataSourceUtils.releaseConnection(con);
                throw throwable;
            }
        }
        DataSourceUtils.closeResultSet(rs);
        DataSourceUtils.closeStatement(ps);
        DataSourceUtils.releaseConnection(con);
        return object;
    }

    public Object executeCallable(String sql, CallableStatementCallback callback) throws JdbcStoreException {
        Connection con = DataSourceUtils.getConnection(this.dataSource);
        CallableStatement cs = null;
        try {
            cs = con.prepareCall(sql);
            cs.setQueryTimeout(this.settings.getQueryTimeout());
            callback.fillCallableStatement(cs);
            cs.execute();
            Object object = callback.readCallableData(cs);
            return object;
        }
        catch (JdbcStoreException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JdbcStoreException("Failed to execute sql [" + sql + "]", e);
        }
        finally {
            DataSourceUtils.closeStatement(cs);
            DataSourceUtils.releaseConnection(con);
        }
    }

    public void executeUpdate(String sql, PrepateStatementAwareCallback callback) throws JdbcStoreException {
        Connection con = DataSourceUtils.getConnection(this.dataSource);
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
            ps.setQueryTimeout(this.settings.getQueryTimeout());
            callback.fillPrepareStatement(ps);
            ps.executeUpdate();
        }
        catch (JdbcStoreException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JdbcStoreException("Failed to execute sql [" + sql + "]", e);
        }
        finally {
            DataSourceUtils.closeStatement(ps);
            DataSourceUtils.releaseConnection(con);
        }
    }

    public void executeUpdate(String sql) throws JdbcStoreException {
        Connection con = DataSourceUtils.getConnection(this.dataSource);
        Statement statement = null;
        try {
            statement = con.createStatement();
            statement.setQueryTimeout(this.settings.getQueryTimeout());
            statement.executeUpdate(sql);
        }
        catch (SQLException e) {
            throw new JdbcStoreException("Failed to execute [" + sql + "]", e);
        }
        finally {
            DataSourceUtils.closeStatement(statement);
            DataSourceUtils.releaseConnection(con);
        }
    }

    public int[] executeBatch(String[] sqls) throws JdbcStoreException {
        Connection con = DataSourceUtils.getConnection(this.dataSource);
        Statement statement = null;
        try {
            statement = con.createStatement();
            statement.setQueryTimeout(this.settings.getQueryTimeout());
            for (int i = 0; i < sqls.length; ++i) {
                statement.addBatch(sqls[i]);
            }
            int[] i = statement.executeBatch();
            return i;
        }
        catch (SQLException e) {
            throw new JdbcStoreException("Failed to execute [" + sqls + "]", e);
        }
        finally {
            DataSourceUtils.closeStatement(statement);
            DataSourceUtils.releaseConnection(con);
        }
    }

    public int[] executeBatch(String sql, PrepateStatementAwareCallback callback) throws JdbcStoreException {
        Connection con = DataSourceUtils.getConnection(this.dataSource);
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
            ps.setQueryTimeout(this.settings.getQueryTimeout());
            callback.fillPrepareStatement(ps);
            int[] nArray = ps.executeBatch();
            return nArray;
        }
        catch (JdbcStoreException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JdbcStoreException("Failed to execute sql [" + sql + "]", e);
        }
        finally {
            DataSourceUtils.closeStatement(ps);
            DataSourceUtils.releaseConnection(con);
        }
    }

    public static interface CallableStatementCallback {
        public void fillCallableStatement(CallableStatement var1) throws Exception;

        public Object readCallableData(CallableStatement var1) throws Exception;
    }

    public static interface ExecuteSelectCallback
    extends PrepateStatementAwareCallback {
        public Object execute(ResultSet var1) throws Exception;
    }

    public static interface PrepateStatementAwareCallback {
        public void fillPrepareStatement(PreparedStatement var1) throws Exception;
    }
}

