/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core;

import org.compass.core.CompassException;
import org.compass.core.Resource;
import org.compass.core.util.Parameter;

public interface CompassHighlighter {
    public CompassHighlighter setHighlighter(String var1) throws CompassException;

    public CompassHighlighter setAnalyzer(String var1) throws CompassException;

    public CompassHighlighter setAnalyzer(Resource var1) throws CompassException;

    public CompassHighlighter setSeparator(String var1) throws CompassException;

    public CompassHighlighter setMaxBytesToAnalyze(int var1) throws CompassException;

    public CompassHighlighter setMaxNumFragments(int var1) throws CompassException;

    public CompassHighlighter setTextTokenizer(TextTokenizer var1) throws CompassException;

    public String fragment(String var1) throws CompassException;

    public String fragment(String var1, String var2) throws CompassException;

    public String[] fragments(String var1) throws CompassException;

    public String[] fragments(String var1, String var2) throws CompassException;

    public String fragmentsWithSeparator(String var1) throws CompassException;

    public String fragmentsWithSeparator(String var1, String var2) throws CompassException;

    public static final class TextTokenizer
    extends Parameter {
        private static final long serialVersionUID = -2884363380650216389L;
        public static final TextTokenizer ANALYZER = new TextTokenizer("ANALYZER");
        public static final TextTokenizer TERM_VECTOR = new TextTokenizer("TERM_VECTOR");
        public static final TextTokenizer AUTO = new TextTokenizer("AUTO");

        private TextTokenizer(String name) {
            super(name);
        }

        public static String toString(TextTokenizer textTokenizer) {
            if (textTokenizer == ANALYZER) {
                return "analyzer";
            }
            if (textTokenizer == TERM_VECTOR) {
                return "term_vector";
            }
            if (textTokenizer == AUTO) {
                return "auto";
            }
            throw new IllegalArgumentException("Can't find text tokenizer for [" + textTokenizer + "]");
        }

        public static TextTokenizer fromString(String textTokenizer) {
            if ("analyzer".equalsIgnoreCase(textTokenizer)) {
                return ANALYZER;
            }
            if ("term_vector".equalsIgnoreCase(textTokenizer)) {
                return TERM_VECTOR;
            }
            if ("auto".equalsIgnoreCase(textTokenizer)) {
                return AUTO;
            }
            throw new IllegalArgumentException("Can't find text tokenizer for [" + textTokenizer + "]");
        }
    }
}

