/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.config.builder;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.compass.core.config.CompassConfiguration;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.ConfigurationException;
import org.compass.core.config.builder.AbstractXmlConfigurationBuilder;
import org.compass.core.util.ClassUtils;
import org.compass.core.util.DomUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class SchemaConfigurationBuilder
extends AbstractXmlConfigurationBuilder {
    static /* synthetic */ Class class$org$w3c$dom$Element;
    static /* synthetic */ Class class$org$compass$core$config$CompassConfiguration;
    static /* synthetic */ Class class$org$compass$core$config$builder$SchemaConfigurationBuilder;

    protected void doProcess(Document doc, CompassConfiguration config) throws ConfigurationException {
        Element root = doc.getDocumentElement();
        NodeList nl = root.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element) || !"compass".equals(node.getLocalName())) continue;
            this.processCompass((Element)node, config);
        }
    }

    public void processCompass(Element compassElement, CompassConfiguration config) {
        config.getSettings().setSetting("compass.name", DomUtils.getElementAttribute(compassElement, "name"));
        NodeList nl = compassElement.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Method method;
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element ele = (Element)node;
            String nodeName = ele.getLocalName();
            String methodName = "bind" + Character.toUpperCase(nodeName.charAt(0)) + nodeName.substring(1, nodeName.length());
            try {
                method = (class$org$compass$core$config$builder$SchemaConfigurationBuilder == null ? SchemaConfigurationBuilder.class$("org.compass.core.config.builder.SchemaConfigurationBuilder") : class$org$compass$core$config$builder$SchemaConfigurationBuilder).getMethod(methodName, class$org$w3c$dom$Element == null ? SchemaConfigurationBuilder.class$("org.w3c.dom.Element") : class$org$w3c$dom$Element, class$org$compass$core$config$CompassConfiguration == null ? SchemaConfigurationBuilder.class$("org.compass.core.config.CompassConfiguration") : class$org$compass$core$config$CompassConfiguration);
            }
            catch (NoSuchMethodException e) {
                throw new ConfigurationException("Compass failed to process node [" + nodeName + "], this is " + "either a mailformed xml configuration (not validated against the xsd), or an internal" + " bug in compass");
            }
            try {
                method.invoke((Object)this, ele, config);
                continue;
            }
            catch (InvocationTargetException e) {
                throw new ConfigurationException("Failed to invoke binding metod for node [" + nodeName + "]", e);
            }
            catch (IllegalAccessException e) {
                throw new ConfigurationException("Failed to access binding metod for node [" + nodeName + "]", e);
            }
        }
    }

    public void bindConverters(Element ele, CompassConfiguration config) {
        CompassSettings settings = config.getSettings();
        List convertersEle = DomUtils.getChildElementsByTagName(ele, "converter");
        Iterator it = convertersEle.iterator();
        while (it.hasNext()) {
            Element converterEle = (Element)it.next();
            SettingsHolder settingsHolder = this.processSettings(converterEle);
            settingsHolder.names.add("type");
            settingsHolder.values.add(DomUtils.getElementAttribute(converterEle, "type"));
            settings.setGroupSettings("compass.converter", DomUtils.getElementAttribute(converterEle, "name"), settingsHolder.names(), settingsHolder.values());
        }
    }

    public void bindPropertyAccessors(Element ele, CompassConfiguration config) {
        CompassSettings settings = config.getSettings();
        List propertyAccessorsEle = DomUtils.getChildElementsByTagName(ele, "propertyAccessor", true);
        Iterator it = propertyAccessorsEle.iterator();
        while (it.hasNext()) {
            Element propertyAccessorEle = (Element)it.next();
            SettingsHolder settingsHolder = this.processSettings(propertyAccessorEle);
            settingsHolder.names.add("type");
            settingsHolder.values.add(DomUtils.getElementAttribute(propertyAccessorEle, "type"));
            settings.setGroupSettings("compass.propertyAccessor", DomUtils.getElementAttribute(propertyAccessorEle, "name"), settingsHolder.names(), settingsHolder.values());
        }
    }

    public void bindPropertyNamingStrategy(Element ele, CompassConfiguration config) {
        CompassSettings settings = config.getSettings();
        String type = DomUtils.getElementAttribute(ele, "type");
        if (type == null) {
            type = DomUtils.getElementAttribute(ele, "typeClass");
        }
        settings.setSetting("compass.property.naming", type);
    }

    public void bindSearchEngine(Element ele, CompassConfiguration config) {
        SettingsHolder settingsHolder;
        CompassSettings settings = config.getSettings();
        settings.setSetting("compass.engine.useCompoundFile", DomUtils.getElementAttribute(ele, "useCompoundFile"));
        settings.setSetting("compass.engine.maxFieldLength", DomUtils.getElementAttribute(ele, "maxFieldLength"));
        settings.setSetting("compass.engine.cacheIntervalInvalidation", DomUtils.getElementAttribute(ele, "cacheInvalidationInterval"));
        settings.setSetting("compass.engine.indexManagerScheduleInterval", DomUtils.getElementAttribute(ele, "indexManagerScheduleInterval"));
        settings.setSetting("compass.engine.waitForCacheInvalidationOnIndexOperation", DomUtils.getElementAttribute(ele, "waitForCacheInvalidationOnIndexOperation"));
        settings.setSetting("compass.engine.defaultsearch", DomUtils.getElementAttribute(ele, "defaultSearch"));
        List child = DomUtils.getChildElementsByTagName(ele, "aliasProperty", true);
        if (child.size() == 1) {
            Element aliasPropertyEle = (Element)child.get(0);
            settings.setSetting("compass.property.alias", DomUtils.getElementAttribute(aliasPropertyEle, "name"));
        }
        if ((child = DomUtils.getChildElementsByTagName(ele, "allProperty", true)).size() == 1) {
            Element allPropertyEle = (Element)child.get(0);
            settings.setSetting("compass.property.all", DomUtils.getElementAttribute(allPropertyEle, "name"));
            settings.setSetting("compass.property.all.termVector", DomUtils.getElementAttribute(allPropertyEle, "termVector"));
            settings.setSetting("compass.engine.all.analyzer", DomUtils.getElementAttribute(allPropertyEle, "analyzer"));
        }
        if ((child = DomUtils.getChildElementsByTagName(ele, "optimizer", true)).size() == 1) {
            Element optimizerEle = (Element)child.get(0);
            settings.setSetting("compass.engine.optimizer.type", DomUtils.getElementAttribute(optimizerEle, "type"));
            settings.setSetting("compass.engine.optimizer.schedule", DomUtils.getElementAttribute(optimizerEle, "schedule"));
            settings.setSetting("compass.engine.optimizer.adaptive.mergeFactor", DomUtils.getElementAttribute(optimizerEle, "mergeFactor"));
            settings.setSetting("compass.engine.optimizer.aggressive.mergeFactor", DomUtils.getElementAttribute(optimizerEle, "mergeFactor"));
        }
        child = DomUtils.getChildElementsByTagName(ele, "highlighter", true);
        Iterator it = child.iterator();
        while (it.hasNext()) {
            Element formatterEle;
            List formatterList;
            List encoderList;
            Element highlighterEle = (Element)it.next();
            String highlighterName = DomUtils.getElementAttribute(highlighterEle, "name");
            settingsHolder = this.processSettings(highlighterEle);
            settingsHolder.names.add("textTokenizer");
            settingsHolder.values.add(DomUtils.getElementAttribute(highlighterEle, "textTokenizer"));
            settingsHolder.names.add("rewriteQuery");
            settingsHolder.values.add(DomUtils.getElementAttribute(highlighterEle, "rewriteQuery"));
            settingsHolder.names.add("computeIdf");
            settingsHolder.values.add(DomUtils.getElementAttribute(highlighterEle, "computeIdf"));
            settingsHolder.names.add("maxNumFragments");
            settingsHolder.values.add(DomUtils.getElementAttribute(highlighterEle, "maxNumFragments"));
            settingsHolder.names.add("separator");
            settingsHolder.values.add(DomUtils.getElementAttribute(highlighterEle, "separator"));
            settingsHolder.names.add("maxBytesToAnalyze");
            settingsHolder.values.add(DomUtils.getElementAttribute(highlighterEle, "maxBytesToAnalyze"));
            List fragmenterList = DomUtils.getChildElementsByTagName(highlighterEle, "fragmenter", true);
            if (fragmenterList.size() == 1) {
                Element fragmenterEle = (Element)fragmenterList.get(0);
                String type = DomUtils.getElementAttribute(fragmenterEle, "type");
                if ("custom".equals(type)) {
                    type = DomUtils.getElementAttribute(fragmenterEle, "class");
                }
                settingsHolder.names.add("fragmenter.type");
                settingsHolder.values.add(type);
                settingsHolder.names.add("fragmenter.simple.size");
                settingsHolder.values.add(DomUtils.getElementAttribute(fragmenterEle, "size"));
            }
            if ((encoderList = DomUtils.getChildElementsByTagName(highlighterEle, "encoder", true)).size() == 1) {
                Element encoderEle = (Element)encoderList.get(0);
                String type = DomUtils.getElementAttribute(encoderEle, "type");
                if ("custom".equals(type)) {
                    type = DomUtils.getElementAttribute(encoderEle, "class");
                }
                settingsHolder.names.add("encoder.type");
                settingsHolder.values.add(type);
            }
            if ((formatterList = DomUtils.getChildElementsByTagName(highlighterEle, "simpleFormatter", true)).size() == 1) {
                formatterEle = (Element)formatterList.get(0);
                settingsHolder.names.add("formatter.type");
                settingsHolder.values.add("simple");
                settingsHolder.names.add("formatter.simple.pre");
                settingsHolder.values.add(DomUtils.getElementAttribute(formatterEle, "pre"));
                settingsHolder.names.add("formatter.simple.post");
                settingsHolder.values.add(DomUtils.getElementAttribute(formatterEle, "post"));
            }
            if ((formatterList = DomUtils.getChildElementsByTagName(highlighterEle, "htmlSpanGradientFormatter", true)).size() == 1) {
                formatterEle = (Element)formatterList.get(0);
                settingsHolder.names.add("formatter.type");
                settingsHolder.values.add("htmlSpanGradient");
                settingsHolder.names.add("formatter.htmlSpanGradient.maxScore");
                settingsHolder.values.add(DomUtils.getElementAttribute(formatterEle, "maxScore"));
                settingsHolder.names.add("formatter.htmlSpanGradient.minForegroundColor");
                settingsHolder.values.add(DomUtils.getElementAttribute(formatterEle, "minForegroundColor"));
                settingsHolder.names.add("formatter.htmlSpanGradient.maxForegroundColor");
                settingsHolder.values.add(DomUtils.getElementAttribute(formatterEle, "maxForegroundColor"));
                settingsHolder.names.add("formatter.htmlSpanGradient.minBackgroundColor");
                settingsHolder.values.add(DomUtils.getElementAttribute(formatterEle, "minBackgroundColor"));
                settingsHolder.names.add("formatter.htmlSpanGradient.maxBackgroundColor");
                settingsHolder.values.add(DomUtils.getElementAttribute(formatterEle, "maxBackgroundColor"));
            }
            if ((formatterList = DomUtils.getChildElementsByTagName(highlighterEle, "customFormatter", true)).size() == 1) {
                formatterEle = (Element)formatterList.get(0);
                settingsHolder.names.add("formatter.type");
                settingsHolder.values.add(DomUtils.getElementAttribute(formatterEle, "class"));
            }
            settings.setGroupSettings("compass.engine.highlighter", highlighterName, settingsHolder.names(), settingsHolder.values());
        }
        child = DomUtils.getChildElementsByTagName(ele, "analyzer", true);
        it = child.iterator();
        while (it.hasNext()) {
            Element analyzerEle = (Element)it.next();
            String analyzerName = DomUtils.getElementAttribute(analyzerEle, "name");
            settingsHolder = this.processSettings(analyzerEle);
            String analyzerType = DomUtils.getElementAttribute(analyzerEle, "type");
            if (analyzerType != null) {
                if (analyzerType.equals("CustomAnalyzer") && (analyzerType = DomUtils.getElementAttribute(analyzerEle, "analyzerClass")) == null) {
                    throw new ConfigurationException("Analyzer [" + analyzerName + "] has " + "type of [CustomAnalyzer] but does not set analyzerClass");
                }
                settingsHolder.names.add("type");
                settingsHolder.values.add(analyzerType);
                if (analyzerType.equals("Snowball")) {
                    settingsHolder.names.add("name");
                    settingsHolder.values.add(DomUtils.getElementAttribute(analyzerEle, "snowballType"));
                }
            }
            settingsHolder.names.add("filters");
            settingsHolder.values.add(DomUtils.getElementAttribute(analyzerEle, "filters"));
            List stopWordsList = DomUtils.getChildElementsByTagName(analyzerEle, "stopWords", true);
            if (stopWordsList.size() == 1) {
                Element stopWordsEle = (Element)stopWordsList.get(0);
                StringBuffer sb = new StringBuffer();
                boolean replace = DomUtils.getElementAttributeAsBoolean(stopWordsEle, "replace", true);
                if (!replace) {
                    sb.append("+");
                }
                List stopWords = DomUtils.getChildElementsByTagName(stopWordsEle, "stopWord", true);
                Iterator swIt = stopWords.iterator();
                while (swIt.hasNext()) {
                    Element stopWordEle = (Element)swIt.next();
                    sb.append(DomUtils.getElementAttribute(stopWordEle, "value")).append(",");
                }
                settingsHolder.names.add("stopwords");
                settingsHolder.values.add(sb.toString());
            }
            settings.setGroupSettings("compass.engine.analyzer", analyzerName, settingsHolder.names(), settingsHolder.values());
        }
        child = DomUtils.getChildElementsByTagName(ele, "analyzerFilter", true);
        it = child.iterator();
        while (it.hasNext()) {
            Element analyzerFilterEle = (Element)it.next();
            SettingsHolder settingsHolder2 = this.processSettings(analyzerFilterEle);
            settingsHolder2.names.add("type");
            settingsHolder2.values.add(DomUtils.getElementAttribute(analyzerFilterEle, "type"));
            settings.setGroupSettings("compass.engine.analyzerfilter", DomUtils.getElementAttribute(analyzerFilterEle, "name"), settingsHolder2.names(), settingsHolder2.values());
        }
    }

    public void bindCache(Element ele, CompassConfiguration config) {
        CompassSettings settings = config.getSettings();
        List child = DomUtils.getChildElementsByTagName(ele, "firstLevel", true);
        if (child.size() == 1) {
            Element firstLevelCacheEle = (Element)child.get(0);
            settings.setSetting("compass.cache.first", DomUtils.getElementAttribute(firstLevelCacheEle, "type"));
        }
    }

    public void bindTransaction(Element ele, CompassConfiguration config) {
        CompassSettings settings = config.getSettings();
        settings.setSetting("compass.transaction.isolation", DomUtils.getElementAttribute(ele, "isolation"));
        settings.setSetting("compass.transaction.factory", DomUtils.getElementAttribute(ele, "factory"));
        settings.setSetting("compass.transaction.commitBeforeCompletion", DomUtils.getElementAttribute(ele, "commitBeforeCompletion"));
        settings.setSetting("compass.transaction.lockDir", DomUtils.getElementAttribute(ele, "lockDir"));
        settings.setSetting("compass.transaction.clearCacheOnCommit", DomUtils.getElementAttribute(ele, "clearCacheOnCommit"));
        settings.setSetting("compass.transaction.commitTimeout", DomUtils.getElementAttribute(ele, "commitTimeout"));
        settings.setSetting("compass.transaction.lockTimeout", DomUtils.getElementAttribute(ele, "lockTimeout"));
        settings.setSetting("compass.transaction.lockPollInterval", DomUtils.getElementAttribute(ele, "lockPollInterval"));
        List child = DomUtils.getChildElementsByTagName(ele, "batchInsertSettings", true);
        if (child.size() == 1) {
            Element batchInsertEle = (Element)child.get(0);
            settings.setSetting("compass.engine.maxMergeDocs", DomUtils.getElementAttribute(batchInsertEle, "maxMergeDocs"));
            settings.setSetting("compass.engine.mergeFactor", DomUtils.getElementAttribute(batchInsertEle, "mergeFactor"));
            settings.setSetting("compass.engine.maxBufferedDocs", DomUtils.getElementAttribute(batchInsertEle, "maxBufferedDocs"));
        }
        if ((child = DomUtils.getChildElementsByTagName(ele, "jtaSettings", true)).size() == 1) {
            Element jtaSettingsEle = (Element)child.get(0);
            settings.setSetting("compass.transaction.userTransactionName", DomUtils.getElementAttribute(jtaSettingsEle, "userTransactionName"));
            settings.setSetting("compass.transaction.cacheUserTransaction", DomUtils.getElementAttribute(jtaSettingsEle, "cacheUserTransaction"));
            settings.setSetting("compass.transaction.managerLookup", DomUtils.getElementAttribute(jtaSettingsEle, "managerLookup"));
            settings.setSetting("compass.transaction.managerLookup", DomUtils.getElementAttribute(jtaSettingsEle, "managerLookupClass"));
        }
    }

    public void bindConnection(Element ele, CompassConfiguration config) {
        Element driverManagerEle;
        CompassSettings settings = config.getSettings();
        List child = DomUtils.getChildElementsByTagName(ele, "file", true);
        if (child.size() == 1) {
            Element connEle = (Element)child.get(0);
            String path = DomUtils.getElementAttribute(connEle, "path");
            if (!path.startsWith("file://")) {
                path = "file://" + path;
            }
            settings.setSetting("compass.engine.connection", path);
            return;
        }
        child = DomUtils.getChildElementsByTagName(ele, "mmap", true);
        if (child.size() == 1) {
            Element connEle = (Element)child.get(0);
            String path = DomUtils.getElementAttribute(connEle, "mmap");
            if (!path.startsWith("mmap://")) {
                path = "mmap://" + path;
            }
            settings.setSetting("compass.engine.connection", path);
            return;
        }
        child = DomUtils.getChildElementsByTagName(ele, "ram", true);
        if (child.size() == 1) {
            Element connEle = (Element)child.get(0);
            String path = DomUtils.getElementAttribute(connEle, "ram");
            if (!path.startsWith("ram://")) {
                path = "ram://" + path;
            }
            settings.setSetting("compass.engine.connection", path);
            return;
        }
        child = DomUtils.getChildElementsByTagName(ele, "jdbc", true);
        Element connEle = (Element)child.get(0);
        settings.setSetting("compass.engine.store.jdbc.managed", DomUtils.getElementAttribute(connEle, "managed", "false"));
        settings.setSetting("compass.engine.store.jdbc.disableSchemaOperations", DomUtils.getElementAttribute(connEle, "disableSchemaOperations", "false"));
        settings.setSetting("compass.engine.store.jdbc.dialect", DomUtils.getElementAttribute(connEle, "dialect"));
        settings.setSetting("compass.engine.store.jdbc.dialect", DomUtils.getElementAttribute(connEle, "dialectClass"));
        settings.setSetting("compass.engine.store.jdbc.useCommitLocks", DomUtils.getElementAttribute(connEle, "useCommitLocks", "false"));
        settings.setSetting("compass.engine.store.jdbc.deleteMarkDeletedDelta", DomUtils.getElementAttribute(connEle, "deleteMarkDeletedDelta"));
        settings.setSetting("compass.engine.store.jdbc.lockType", DomUtils.getElementAttribute(connEle, "lock"));
        settings.setSetting("compass.engine.store.jdbc.lockType", DomUtils.getElementAttribute(connEle, "lockClass"));
        child = DomUtils.getChildElementsByTagName(connEle, "fileEntries", true);
        if (child.size() == 1) {
            Element fileEntriesEle = (Element)child.get(0);
            child = DomUtils.getChildElementsByTagName(fileEntriesEle, "fileEntry", true);
            Iterator it = child.iterator();
            while (it.hasNext()) {
                Element fileEntryEle = (Element)it.next();
                SettingsHolder settingsHolder = this.processSettings(fileEntryEle);
                child = DomUtils.getChildElementsByTagName(fileEntryEle, "indexInput", true);
                if (child.size() == 1) {
                    Element indexInputEle = (Element)child.get(0);
                    settingsHolder.names.add("indexInput.type");
                    settingsHolder.values.add(DomUtils.getElementAttribute(indexInputEle, "type"));
                    settingsHolder.names.add("indexInput.type");
                    settingsHolder.values.add(DomUtils.getElementAttribute(indexInputEle, "typeClass"));
                    settingsHolder.names.add("indexInput.bufferSize");
                    settingsHolder.values.add(DomUtils.getElementAttribute(indexInputEle, "bufferSize"));
                }
                if ((child = DomUtils.getChildElementsByTagName(fileEntryEle, "indexOutput", true)).size() == 1) {
                    Element indexOutputEle = (Element)child.get(0);
                    settingsHolder.names.add("indexOutput.type");
                    settingsHolder.values.add(DomUtils.getElementAttribute(indexOutputEle, "type"));
                    settingsHolder.names.add("indexOutput.type");
                    settingsHolder.values.add(DomUtils.getElementAttribute(indexOutputEle, "typeClass"));
                    settingsHolder.names.add("indexOutput.bufferSize");
                    settingsHolder.values.add(DomUtils.getElementAttribute(indexOutputEle, "bufferSize"));
                    settingsHolder.names.add("indexOutput.threshold");
                    settingsHolder.values.add(DomUtils.getElementAttribute(indexOutputEle, "threshold"));
                }
                settings.setGroupSettings("compass.engine.store.jdbc.fe", DomUtils.getElementAttribute(fileEntryEle, "name"), settingsHolder.names(), settingsHolder.values());
            }
        }
        if ((child = DomUtils.getChildElementsByTagName(connEle, "ddl", true)).size() == 1) {
            Element ddlEle = (Element)child.get(0);
            if ((child = DomUtils.getChildElementsByTagName(ddlEle, "nameColumn", true)).size() == 1) {
                Element nameColumnEle = (Element)child.get(0);
                settings.setSetting("compass.engine.store.jdbc.ddl.name.name", DomUtils.getElementAttribute(nameColumnEle, "name"));
                settings.setSetting("compass.engine.store.jdbc.ddl.name.length", DomUtils.getElementAttribute(nameColumnEle, "length"));
            }
            if ((child = DomUtils.getChildElementsByTagName(ddlEle, "valueColumn", true)).size() == 1) {
                Element valueColumnEle = (Element)child.get(0);
                settings.setSetting("compass.engine.store.jdbc.ddl.value.name", DomUtils.getElementAttribute(valueColumnEle, "name"));
                settings.setSetting("compass.engine.store.jdbc.ddl.value.length", DomUtils.getElementAttribute(valueColumnEle, "length"));
            }
            if ((child = DomUtils.getChildElementsByTagName(ddlEle, "sizeColumn", true)).size() == 1) {
                Element sizeColumnEle = (Element)child.get(0);
                settings.setSetting("compass.engine.store.jdbc.ddl.size.name", DomUtils.getElementAttribute(sizeColumnEle, "name"));
            }
            if ((child = DomUtils.getChildElementsByTagName(ddlEle, "lastModifiedColumn", true)).size() == 1) {
                Element lastModifiedEle = (Element)child.get(0);
                settings.setSetting("compass.engine.store.jdbc.ddl.lastModified.name", DomUtils.getElementAttribute(lastModifiedEle, "name"));
            }
            if ((child = DomUtils.getChildElementsByTagName(ddlEle, "deletedColumn", true)).size() == 1) {
                Element deletedEle = (Element)child.get(0);
                settings.setSetting("compass.engine.store.jdbc.ddl.deleted.name", DomUtils.getElementAttribute(deletedEle, "name"));
            }
        }
        child = DomUtils.getChildElementsByTagName(connEle, "dataSourceProvider", true);
        Element dataSourceProviderEle = (Element)child.get(0);
        if ((child = DomUtils.getChildElementsByTagName(dataSourceProviderEle, "driverManager", true)).size() == 1) {
            driverManagerEle = (Element)child.get(0);
            settings.setSetting("compass.engine.store.jdbc.connection.provider.class", "org.compass.core.lucene.engine.store.jdbc.DriverManagerDataSourceProvider");
            settings.setSetting("compass.engine.connection", "jdbc://" + DomUtils.getElementAttribute(driverManagerEle, "url"));
            settings.setSetting("compass.engine.store.jdbc.connection.username", DomUtils.getElementAttribute(driverManagerEle, "username"));
            settings.setSetting("compass.engine.store.jdbc.connection.password", DomUtils.getElementAttribute(driverManagerEle, "password"));
            settings.setSetting("compass.engine.store.jdbc.connection.driverClass", DomUtils.getElementAttribute(driverManagerEle, "driverClass"));
            settings.setSetting("compass.engine.store.jdbc.connection.autoCommit", DomUtils.getElementAttribute(driverManagerEle, "autoCommit", "false"));
        }
        if ((child = DomUtils.getChildElementsByTagName(dataSourceProviderEle, "c3p0", true)).size() == 1) {
            driverManagerEle = (Element)child.get(0);
            settings.setSetting("compass.engine.store.jdbc.connection.provider.class", "org.compass.core.lucene.engine.store.jdbc.C3P0DataSourceProvider");
            settings.setSetting("compass.engine.connection", "jdbc://" + DomUtils.getElementAttribute(driverManagerEle, "url"));
            settings.setSetting("compass.engine.store.jdbc.connection.username", DomUtils.getElementAttribute(driverManagerEle, "username"));
            settings.setSetting("compass.engine.store.jdbc.connection.password", DomUtils.getElementAttribute(driverManagerEle, "password"));
            settings.setSetting("compass.engine.store.jdbc.connection.driverClass", DomUtils.getElementAttribute(driverManagerEle, "driverClass"));
            settings.setSetting("compass.engine.store.jdbc.connection.autoCommit", DomUtils.getElementAttribute(driverManagerEle, "autoCommit", "false"));
        }
        if ((child = DomUtils.getChildElementsByTagName(dataSourceProviderEle, "jndi", true)).size() == 1) {
            Element jndiEle = (Element)child.get(0);
            settings.setSetting("compass.engine.store.jdbc.connection.provider.class", "org.compass.core.lucene.engine.store.jdbc.JndiDataSourceProvider");
            settings.setSetting("compass.engine.connection", "jdbc://" + DomUtils.getElementAttribute(jndiEle, "lookup"));
            settings.setSetting("compass.engine.store.jdbc.connection.username", DomUtils.getElementAttribute(jndiEle, "username"));
            settings.setSetting("compass.engine.store.jdbc.connection.password", DomUtils.getElementAttribute(jndiEle, "password"));
            settings.setSetting("compass.engine.store.jdbc.connection.autoCommit", DomUtils.getElementAttribute(jndiEle, "autoCommit", "false"));
        }
        if ((child = DomUtils.getChildElementsByTagName(dataSourceProviderEle, "dbcp", true)).size() == 1) {
            Element dbcpEle = (Element)child.get(0);
            settings.setSetting("compass.engine.store.jdbc.connection.provider.class", "org.compass.core.lucene.engine.store.jdbc.DbcpDataSourceProvider");
            settings.setSetting("compass.engine.connection", "jdbc://" + DomUtils.getElementAttribute(dbcpEle, "url"));
            settings.setSetting("compass.engine.store.jdbc.connection.username", DomUtils.getElementAttribute(dbcpEle, "username"));
            settings.setSetting("compass.engine.store.jdbc.connection.password", DomUtils.getElementAttribute(dbcpEle, "password"));
            settings.setSetting("compass.engine.store.jdbc.connection.driverClass", DomUtils.getElementAttribute(dbcpEle, "driverClass"));
            settings.setSetting("compass.engine.store.jdbc.connection.autoCommit", DomUtils.getElementAttribute(dbcpEle, "autoCommit", "false"));
            settings.setSetting("compass.engine.store.jdbc.connection.provider.dbcp.defaultTransactionIsolation", DomUtils.getElementAttribute(dbcpEle, "defaultTransactionIsolation"));
            settings.setSetting("compass.engine.store.jdbc.connection.provider.dbcp.initialSize", DomUtils.getElementAttribute(dbcpEle, "initialSize"));
            settings.setSetting("compass.engine.store.jdbc.connection.provider.dbcp.maxActive", DomUtils.getElementAttribute(dbcpEle, "maxActive"));
            settings.setSetting("compass.engine.store.jdbc.connection.provider.dbcp.maxIdle", DomUtils.getElementAttribute(dbcpEle, "maxIdle"));
            settings.setSetting("compass.engine.store.jdbc.connection.provider.dbcp.minIdle", DomUtils.getElementAttribute(dbcpEle, "minIdle"));
            settings.setSetting("compass.engine.store.jdbc.connection.provider.dbcp.maxWait", DomUtils.getElementAttribute(dbcpEle, "maxWait"));
            settings.setSetting("compass.engine.store.jdbc.connection.provider.dbcp.maxOpenPreparedStatements", DomUtils.getElementAttribute(dbcpEle, "maxOpenPreparedStatements"));
            settings.setSetting("compass.engine.store.jdbc.connection.provider.dbcp.poolPreparedStatements", DomUtils.getElementAttribute(dbcpEle, "poolPreparedStatements"));
        }
        if ((child = DomUtils.getChildElementsByTagName(dataSourceProviderEle, "external", true)).size() == 1) {
            Element externalEle = (Element)child.get(0);
            settings.setSetting("compass.engine.store.jdbc.connection.provider.class", "org.compass.core.lucene.engine.store.jdbc.ExternalDataSourceProvider");
            settings.setSetting("compass.engine.connection", "jdbc://");
            settings.setSetting("compass.engine.store.jdbc.connection.username", DomUtils.getElementAttribute(externalEle, "username"));
            settings.setSetting("compass.engine.store.jdbc.connection.password", DomUtils.getElementAttribute(externalEle, "password"));
            settings.setSetting("compass.engine.store.jdbc.connection.autoCommit", DomUtils.getElementAttribute(externalEle, "autoCommit", "false"));
        }
    }

    public void bindJndi(Element ele, CompassConfiguration config) {
        CompassSettings settings = config.getSettings();
        settings.setSetting("compass.jndi.enable", DomUtils.getElementAttribute(ele, "register", "false"));
        settings.setSetting("compass.jndi.class", DomUtils.getElementAttribute(ele, "class"));
        settings.setSetting("compass.jndi.url", DomUtils.getElementAttribute(ele, "url"));
        List environments = DomUtils.getChildElementsByTagName(ele, "environment", true);
        if (environments.size() == 1) {
            Element environment = (Element)environments.get(0);
            List properties = DomUtils.getChildElementsByTagName(environment, "property", true);
            Iterator it = properties.iterator();
            while (it.hasNext()) {
                Element property = (Element)it.next();
                String propertyName = "compass.jndi." + DomUtils.getElementAttribute(property, "name");
                String propertyValue = DomUtils.getElementAttribute(property, "value");
                settings.setSetting(propertyName, propertyValue);
            }
        }
    }

    public void bindSettings(Element ele, CompassConfiguration config) {
        CompassSettings settings = config.getSettings();
        List domSettings = DomUtils.getChildElementsByTagName(ele, "setting", true);
        Iterator it = domSettings.iterator();
        while (it.hasNext()) {
            Element eleSetting = (Element)it.next();
            settings.setSetting(DomUtils.getElementAttribute(eleSetting, "name"), DomUtils.getElementAttribute(eleSetting, "value"));
        }
    }

    public void bindMappings(Element ele, CompassConfiguration config) throws Exception {
        NodeList nl = ele.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element mappingEle = (Element)node;
            String nodeName = mappingEle.getLocalName();
            if ("resource".equals(nodeName)) {
                config.addResource(DomUtils.getElementAttribute(mappingEle, "location"));
                continue;
            }
            if ("class".equals(nodeName)) {
                config.addClass(ClassUtils.forName(DomUtils.getElementAttribute(mappingEle, "name")));
                continue;
            }
            if ("jar".equals(nodeName)) {
                config.addJar(new File(DomUtils.getElementAttribute(mappingEle, "path")));
                continue;
            }
            if ("file".equals(nodeName)) {
                config.addFile(new File(DomUtils.getElementAttribute(mappingEle, "path")));
                continue;
            }
            if ("dir".equals(nodeName)) {
                config.addDirectory(new File(DomUtils.getElementAttribute(mappingEle, "path")));
                continue;
            }
            if (!"package".equals(nodeName)) continue;
            config.addPackage(DomUtils.getElementAttribute(mappingEle, "name"));
        }
    }

    private SettingsHolder processSettings(Element ele) {
        SettingsHolder settingsHolder = new SettingsHolder();
        List settings = DomUtils.getChildElementsByTagName(ele, "setting", true);
        Iterator it = settings.iterator();
        while (it.hasNext()) {
            Element settingEle = (Element)it.next();
            settingsHolder.names.add(DomUtils.getElementAttribute(settingEle, "name"));
            settingsHolder.values.add(DomUtils.getElementAttribute(settingEle, "value"));
        }
        return settingsHolder;
    }

    protected EntityResolver doGetEntityResolver() {
        return new EntityResolver(){
            private static final String URL = "http://www.opensymphony.com/compass/schema/";

            public InputSource resolveEntity(String publicId, String systemId) {
                if (systemId != null && systemId.startsWith(URL)) {
                    String location = "/org/compass/core/" + systemId.substring(URL.length());
                    InputStream is = this.getClass().getResourceAsStream(location);
                    if (is == null) {
                        throw new ConfigurationException("Schema system id [" + systemId + "] not found at [" + location + "], " + "please check it has the correct location. Have you included compass in your class path?");
                    }
                    InputSource source = new InputSource(is);
                    source.setPublicId(publicId);
                    source.setSystemId(systemId);
                    return source;
                }
                throw new ConfigurationException("Schema system id [" + systemId + "] not found, please check it has the " + "correct location");
            }
        };
    }

    protected DocumentBuilderFactory createDocumentBuilderFactory() throws ParserConfigurationException {
        DocumentBuilderFactory factory = super.createDocumentBuilderFactory();
        factory.setNamespaceAware(true);
        try {
            factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        }
        catch (IllegalArgumentException ex) {
            throw new ConfigurationException("Unable to validate using XSD: Your JAXP provider [" + factory + "] does not support XML Schema. " + "Are you running on Java 1.4 or below with Apache Crimson? " + "Upgrade to Apache Xerces (or Java 1.5) for full XSD support.");
        }
        return factory;
    }

    private class SettingsHolder {
        public ArrayList names = new ArrayList();
        public ArrayList values = new ArrayList();

        private SettingsHolder() {
        }

        public String[] names() {
            return this.names.toArray(new String[this.names.size()]);
        }

        public String[] values() {
            return this.values.toArray(new String[this.values.size()]);
        }
    }
}

