/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.config.process;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.ConfigurationException;
import org.compass.core.config.process.MappingProcessor;
import org.compass.core.config.process.MappingProcessorUtils;
import org.compass.core.converter.ConverterLookup;
import org.compass.core.converter.xsem.SimpleXmlValueConverter;
import org.compass.core.engine.naming.PropertyNamingStrategy;
import org.compass.core.engine.naming.StaticPropertyPath;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.MappingException;
import org.compass.core.mapping.osem.AbstractCollectionMapping;
import org.compass.core.mapping.osem.ClassIdPropertyMapping;
import org.compass.core.mapping.osem.ClassMapping;
import org.compass.core.mapping.osem.ClassPropertyMapping;
import org.compass.core.mapping.osem.ClassPropertyMetaDataMapping;
import org.compass.core.mapping.osem.ComponentMapping;
import org.compass.core.mapping.osem.ConstantMetaDataMapping;
import org.compass.core.mapping.osem.ParentMapping;
import org.compass.core.mapping.osem.ReferenceMapping;
import org.compass.core.mapping.rsem.RawResourceMapping;
import org.compass.core.mapping.xsem.XmlIdMapping;
import org.compass.core.mapping.xsem.XmlObjectMapping;
import org.compass.core.mapping.xsem.XmlPropertyMapping;

public class DefaultMappingProcessor
implements MappingProcessor {
    private CompassMapping compassMapping;
    private PropertyNamingStrategy namingStrategy;
    private ConverterLookup converterLookup;
    private CompassSettings settings;
    private List chainedComponents = new ArrayList();
    private ClassPropertyMapping.ManagedId managedId = null;

    public CompassMapping process(CompassMapping compassMapping, PropertyNamingStrategy namingStrategy, ConverterLookup converterLookup, CompassSettings settings) throws MappingException {
        this.compassMapping = compassMapping;
        this.namingStrategy = namingStrategy;
        this.converterLookup = converterLookup;
        this.settings = settings;
        compassMapping.setPath(namingStrategy.getRootPath());
        Iterator it = compassMapping.mappingsIt();
        while (it.hasNext()) {
            Mapping m = (Mapping)it.next();
            if (m instanceof ClassMapping) {
                this.clearRootClassMappingState();
                this.secondPass((ClassMapping)m, compassMapping);
                continue;
            }
            if (m instanceof RawResourceMapping) {
                this.secondPass((RawResourceMapping)m);
                continue;
            }
            if (!(m instanceof XmlObjectMapping)) continue;
            this.secondPass((XmlObjectMapping)m, compassMapping);
        }
        return compassMapping;
    }

    private void secondPass(XmlObjectMapping xmlObjectMapping, CompassMapping fatherMapping) {
        xmlObjectMapping.setPath(this.namingStrategy.buildPath(fatherMapping.getPath(), xmlObjectMapping.getAlias()));
        this.secondPassConverter(xmlObjectMapping, true);
        Iterator it = xmlObjectMapping.mappingsIt();
        while (it.hasNext()) {
            Mapping mapping = (Mapping)it.next();
            this.secondPassConverter(mapping, true);
            if (mapping instanceof XmlIdMapping) {
                XmlIdMapping xmlIdMapping = (XmlIdMapping)mapping;
                xmlIdMapping.setInternal(true);
                xmlIdMapping.setPath(this.namingStrategy.buildPath(xmlObjectMapping.getPath(), xmlIdMapping.getName()));
            }
            if (!(mapping instanceof XmlPropertyMapping)) continue;
            XmlPropertyMapping xmlPropertyMapping = (XmlPropertyMapping)mapping;
            if (xmlPropertyMapping.getValueConverterName() != null) {
                String converterName = xmlPropertyMapping.getValueConverterName();
                xmlPropertyMapping.setValueConverter(this.converterLookup.lookupConverter(converterName));
                if (xmlPropertyMapping.getValueConverter() != null) continue;
                throw new ConfigurationException("Failed to find converter [" + converterName + "] for mapping " + "[" + xmlPropertyMapping.getName() + "]");
            }
            xmlPropertyMapping.setValueConverter(new SimpleXmlValueConverter());
        }
    }

    private void secondPass(RawResourceMapping resourceMapping) {
        this.secondPassConverter(resourceMapping, true);
        Iterator it = resourceMapping.mappingsIt();
        while (it.hasNext()) {
            this.secondPassConverter((Mapping)it.next(), false);
        }
    }

    private void secondPass(ClassMapping classMapping, CompassMapping fatherMapping) {
        classMapping.setPath(this.namingStrategy.buildPath(fatherMapping.getPath(), classMapping.getAlias()));
        this.secondPass(classMapping, false);
    }

    private void secondPass(ClassMapping classMapping, boolean onlyProperties) {
        classMapping.setClassPath(this.namingStrategy.buildPath(classMapping.getPath(), "class").hintStatic());
        this.secondPassConverter(classMapping);
        ArrayList<Mapping> innerMappingsCopy = new ArrayList<Mapping>();
        Iterator it = classMapping.mappingsIt();
        while (it.hasNext()) {
            Mapping m = (Mapping)it.next();
            Mapping copyMapping = m.copy();
            boolean removeMapping = false;
            if (m instanceof ClassPropertyMapping) {
                removeMapping = this.secondPass((ClassPropertyMapping)copyMapping, (Mapping)classMapping);
            } else if (!onlyProperties) {
                if (copyMapping instanceof ComponentMapping) {
                    removeMapping = this.secondPass((ComponentMapping)copyMapping, (Mapping)classMapping);
                } else if (copyMapping instanceof ReferenceMapping) {
                    removeMapping = this.secondPass((ReferenceMapping)copyMapping, (Mapping)classMapping);
                } else if (copyMapping instanceof ConstantMetaDataMapping) {
                    removeMapping = this.secondPass((ConstantMetaDataMapping)copyMapping);
                } else if (copyMapping instanceof ParentMapping) {
                    removeMapping = this.secondPass((ParentMapping)copyMapping);
                } else if (copyMapping instanceof AbstractCollectionMapping) {
                    removeMapping = this.secondPass((AbstractCollectionMapping)copyMapping, (Mapping)classMapping);
                }
            }
            if (removeMapping) continue;
            innerMappingsCopy.add(copyMapping);
        }
        classMapping.clearMappings();
        it = innerMappingsCopy.iterator();
        while (it.hasNext()) {
            classMapping.addMapping((Mapping)it.next());
        }
    }

    private boolean secondPass(AbstractCollectionMapping collectionMapping, Mapping fatherMapping) {
        this.secondPassConverter(collectionMapping);
        Mapping elementMapping = collectionMapping.getElementMapping();
        Mapping elementMappingCopy = elementMapping.copy();
        boolean removeMapping = false;
        if (elementMappingCopy instanceof ClassPropertyMapping) {
            removeMapping = this.secondPass((ClassPropertyMapping)elementMappingCopy, fatherMapping);
        } else if (elementMappingCopy instanceof ComponentMapping) {
            removeMapping = this.secondPass((ComponentMapping)elementMappingCopy, fatherMapping);
        } else if (elementMappingCopy instanceof ReferenceMapping) {
            removeMapping = this.secondPass((ReferenceMapping)elementMappingCopy, fatherMapping);
        }
        collectionMapping.setElementMapping(elementMappingCopy);
        collectionMapping.setPath(this.namingStrategy.buildPath(fatherMapping.getPath(), collectionMapping.getName()));
        collectionMapping.setCollectionTypePath(this.namingStrategy.buildPath(collectionMapping.getPath(), "colType").hintStatic());
        collectionMapping.setColSizePath(this.namingStrategy.buildPath(collectionMapping.getPath(), "colSize").hintStatic());
        return removeMapping;
    }

    private boolean secondPass(ReferenceMapping referenceMapping, Mapping fatherMapping) {
        referenceMapping.setPath(this.namingStrategy.buildPath(fatherMapping.getPath(), referenceMapping.getName()));
        this.secondPassConverter(referenceMapping);
        ClassMapping pointerClass = referenceMapping.getRefClassMapping();
        if (pointerClass == null) {
            throw new MappingException("Failed to locate mapping for reference ref-alias [" + referenceMapping.getRefAlias() + "]");
        }
        ClassMapping refClass = (ClassMapping)pointerClass.copy();
        refClass.setPath(referenceMapping.getPath());
        this.secondPass(refClass, true);
        List ids = refClass.findClassPropertyIdMappings();
        refClass.clearMappings();
        Iterator it = ids.iterator();
        while (it.hasNext()) {
            ClassIdPropertyMapping idMapping = (ClassIdPropertyMapping)it.next();
            idMapping.clearMappings();
            MappingProcessorUtils.addInternalId(this.settings, this.converterLookup, idMapping);
            refClass.addMapping(idMapping);
        }
        refClass.postProcess();
        referenceMapping.setRefClassMapping(refClass);
        if (referenceMapping.getRefCompAlias() != null) {
            pointerClass = (ClassMapping)this.compassMapping.getResourceMappingByAlias(referenceMapping.getRefCompAlias());
            if (pointerClass == null) {
                throw new MappingException("Failed to locate mapping for reference ref-comp-alias [" + referenceMapping.getRefCompAlias() + "]");
            }
            refClass = (ClassMapping)pointerClass.copy();
            refClass.setPath(this.namingStrategy.buildPath(referenceMapping.getPath(), referenceMapping.getRefCompAlias()));
            this.managedId = ClassPropertyMapping.ManagedId.FALSE;
            this.secondPass(refClass, false);
            this.managedId = null;
            refClass.setRoot(false);
            referenceMapping.setRefCompMapping(refClass);
        }
        return false;
    }

    private boolean secondPass(ComponentMapping compMapping, Mapping fatherMapping) {
        int numberOfComponentsWithTheSameAlias = 0;
        Iterator it = this.chainedComponents.iterator();
        while (it.hasNext()) {
            ComponentMapping tempComponentMapping = (ComponentMapping)it.next();
            if (!compMapping.getRefAlias().equals(tempComponentMapping.getRefAlias())) continue;
            ++numberOfComponentsWithTheSameAlias;
        }
        if (numberOfComponentsWithTheSameAlias >= compMapping.getMaxDepth()) {
            return true;
        }
        this.chainedComponents.add(compMapping);
        compMapping.setPath(this.namingStrategy.buildPath(fatherMapping.getPath(), compMapping.getName()));
        this.secondPassConverter(compMapping);
        ClassMapping refClassMapping = compMapping.getRefClassMapping();
        refClassMapping = (ClassMapping)refClassMapping.copy();
        refClassMapping.setPath(compMapping.getPath());
        this.secondPass(refClassMapping, false);
        refClassMapping.setRoot(false);
        compMapping.setRefClassMapping(refClassMapping);
        this.chainedComponents.remove(compMapping);
        return false;
    }

    private boolean secondPass(ParentMapping parentMapping) {
        this.secondPassConverter(parentMapping);
        return false;
    }

    private boolean secondPass(ClassPropertyMapping classPropertyMapping, Mapping fatherMapping) {
        this.secondPassConverter(classPropertyMapping);
        classPropertyMapping.setPath(this.namingStrategy.buildPath(fatherMapping.getPath(), classPropertyMapping.getName()));
        if (this.managedId != null) {
            classPropertyMapping.setManagedId(this.managedId);
        }
        ArrayList<ClassPropertyMetaDataMapping> innerMappingsCopy = new ArrayList<ClassPropertyMetaDataMapping>();
        Iterator it = classPropertyMapping.mappingsIt();
        while (it.hasNext()) {
            Mapping m = (Mapping)it.next();
            ClassPropertyMetaDataMapping metaDataMappingCopy = (ClassPropertyMetaDataMapping)m.copy();
            MappingProcessorUtils.process(metaDataMappingCopy, classPropertyMapping, this.converterLookup);
            innerMappingsCopy.add(metaDataMappingCopy);
        }
        classPropertyMapping.clearMappings();
        it = innerMappingsCopy.iterator();
        while (it.hasNext()) {
            classPropertyMapping.addMapping((Mapping)it.next());
        }
        return false;
    }

    private boolean secondPass(ConstantMetaDataMapping constantMapping) {
        this.secondPassConverter(constantMapping);
        constantMapping.setPath(new StaticPropertyPath(constantMapping.getName()));
        return false;
    }

    private void secondPassConverter(Mapping mapping) {
        this.secondPassConverter(mapping, true);
    }

    private void secondPassConverter(Mapping mapping, boolean forceConverter) {
        if (mapping.getConverter() == null) {
            if (mapping.getConverterName() != null) {
                String converterName = mapping.getConverterName();
                mapping.setConverter(this.converterLookup.lookupConverter(converterName));
                if (mapping.getConverter() == null && forceConverter) {
                    throw new ConfigurationException("Failed to find converter [" + converterName + "] for mapping " + "[" + mapping.getName() + "]");
                }
            } else {
                mapping.setConverter(this.converterLookup.lookupConverter(mapping.getClass()));
                if (mapping.getConverter() == null && forceConverter) {
                    throw new ConfigurationException("Failed to find converter for class [" + mapping.getClass() + "]" + " for mapping [" + mapping.getName() + "]");
                }
            }
        }
    }

    private void clearRootClassMappingState() {
        this.chainedComponents.clear();
    }
}

