/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.config.process;

import org.compass.core.Property;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.ConfigurationException;
import org.compass.core.converter.Converter;
import org.compass.core.converter.ConverterLookup;
import org.compass.core.converter.DelegateConverter;
import org.compass.core.engine.naming.StaticPropertyPath;
import org.compass.core.mapping.MappingException;
import org.compass.core.mapping.osem.ClassPropertyMapping;
import org.compass.core.mapping.osem.ClassPropertyMetaDataMapping;
import org.compass.core.util.ClassUtils;

public abstract class MappingProcessorUtils {
    public static void addInternalId(CompassSettings settings, ConverterLookup converterLookup, ClassPropertyMapping classPropertyMapping) throws MappingException {
        String indexSetting;
        ClassPropertyMetaDataMapping internalIdMapping = new ClassPropertyMetaDataMapping();
        internalIdMapping.setInternal(true);
        internalIdMapping.setName(classPropertyMapping.getName());
        internalIdMapping.setStore(Property.Store.YES);
        Property.Index index = classPropertyMapping.getManagedIdIndex();
        if (index == null && (index = Property.Index.fromString(indexSetting = settings.getSetting("compass.managedId.index", "no"))) == Property.Index.TOKENIZED) {
            throw new ConfigurationException("Set the setting [compass.managedId.index] with value of [tokenized], must be either [no] or [un_tokenized]");
        }
        internalIdMapping.setIndex(index);
        internalIdMapping.setBoost(1.0f);
        internalIdMapping.setGetter(classPropertyMapping.getGetter());
        internalIdMapping.setSetter(classPropertyMapping.getSetter());
        internalIdMapping.setConverter(classPropertyMapping.getManagedIdConverter());
        internalIdMapping.setConverterName(classPropertyMapping.getManagedIdConverterName());
        MappingProcessorUtils.process(internalIdMapping, classPropertyMapping, converterLookup);
        int propertyIndex = classPropertyMapping.addMapping(internalIdMapping);
        classPropertyMapping.setIdPropertyIndex(propertyIndex);
    }

    public static void process(ClassPropertyMetaDataMapping mdMapping, ClassPropertyMapping classPropertyMapping, ConverterLookup converterLookup) throws MappingException {
        mdMapping.setPropertyName(classPropertyMapping.getPropertyName());
        if (mdMapping.getConverter() == null) {
            if (mdMapping.getConverterName() != null) {
                String converterName = mdMapping.getConverterName();
                mdMapping.setConverter(converterLookup.lookupConverter(converterName));
                if (mdMapping.getConverter() == null) {
                    throw new ConfigurationException("Failed to find converter [" + converterName + "] for property " + "[" + classPropertyMapping.getName() + "]");
                }
            } else {
                Converter converter = MappingProcessorUtils.resolveConverterByClass(classPropertyMapping, converterLookup);
                mdMapping.setConverter(converter);
            }
        } else if (mdMapping.getConverter() instanceof DelegateConverter) {
            Converter converter = MappingProcessorUtils.resolveConverterByClass(classPropertyMapping, converterLookup);
            ((DelegateConverter)mdMapping.getConverter()).setDelegatedConverter(converter);
        }
        if (mdMapping.isInternal()) {
            mdMapping.setPath(classPropertyMapping.getPath().hintStatic());
        } else {
            mdMapping.setPath(new StaticPropertyPath(mdMapping.getName()));
        }
    }

    private static Converter resolveConverterByClass(ClassPropertyMapping classPropertyMapping, ConverterLookup converterLookup) {
        Converter converter;
        String className = classPropertyMapping.getClassName();
        Class clazz = null;
        try {
            if (className != null) {
                clazz = ClassUtils.forName(className);
            }
        }
        catch (ClassNotFoundException e) {
            throw new MappingException("Failed to find class [" + className + "]", e);
        }
        if (clazz == null) {
            clazz = classPropertyMapping.getGetter().getReturnType();
            converter = converterLookup.lookupConverter(clazz);
            if (converter == null && clazz.isArray()) {
                clazz = clazz.getComponentType();
                converter = converterLookup.lookupConverter(clazz);
            }
        } else {
            converter = converterLookup.lookupConverter(clazz);
        }
        if (converter == null) {
            throw new MappingException("No converter defined for type [" + classPropertyMapping.getGetter().getReturnType().getName() + "]");
        }
        return converter;
    }
}

