/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.config.process;

import java.util.Iterator;
import org.compass.core.accessor.PropertyAccessor;
import org.compass.core.accessor.PropertyAccessorFactory;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.process.MappingProcessor;
import org.compass.core.converter.ConverterLookup;
import org.compass.core.engine.naming.PropertyNamingStrategy;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.MappingException;
import org.compass.core.mapping.MultipleMapping;
import org.compass.core.mapping.osem.ClassMapping;
import org.compass.core.mapping.osem.ObjectMapping;

public class PropertyAccessorMappingProcessor
implements MappingProcessor {
    public CompassMapping process(CompassMapping compassMapping, PropertyNamingStrategy namingStrategy, ConverterLookup converterLookup, CompassSettings settings) throws MappingException {
        PropertyAccessorFactory propertyAccessorFactory = new PropertyAccessorFactory();
        propertyAccessorFactory.configure(settings);
        Iterator rIt = compassMapping.mappingsIt();
        while (rIt.hasNext()) {
            Mapping mapping = (Mapping)rIt.next();
            if (!(mapping instanceof ClassMapping)) continue;
            ClassMapping classMapping = (ClassMapping)mapping;
            Iterator it = classMapping.mappingsIt();
            while (it.hasNext()) {
                this.processMapping((Mapping)it.next(), classMapping.getClazz(), propertyAccessorFactory);
            }
        }
        return compassMapping;
    }

    private void processMapping(Mapping mapping, Object fatherObject, PropertyAccessorFactory propertyAccessorFactory) throws MappingException {
        if (!(mapping instanceof ObjectMapping)) {
            return;
        }
        ObjectMapping objectMapping = (ObjectMapping)mapping;
        Class clazz = objectMapping.getObjClass();
        if (clazz == null) {
            clazz = fatherObject instanceof ObjectMapping ? ((ObjectMapping)fatherObject).getObjClass() : (Class)fatherObject;
            objectMapping.setObjClass(clazz);
        }
        PropertyAccessor pAccessor = propertyAccessorFactory.getPropertyAccessor(objectMapping.getAccessor());
        objectMapping.setGetter(pAccessor.getGetter(clazz, objectMapping.getPropertyName()));
        objectMapping.setSetter(pAccessor.getSetter(clazz, objectMapping.getPropertyName()));
        if (mapping instanceof MultipleMapping) {
            MultipleMapping multipleMapping = (MultipleMapping)mapping;
            Iterator it = multipleMapping.mappingsIt();
            while (it.hasNext()) {
                this.processMapping((Mapping)it.next(), objectMapping, propertyAccessorFactory);
            }
        }
    }
}

