/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.config.process;

import java.util.Collection;
import java.util.Iterator;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.process.MappingProcessor;
import org.compass.core.converter.ConverterLookup;
import org.compass.core.engine.naming.PropertyNamingStrategy;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.MappingException;
import org.compass.core.mapping.osem.ClassMapping;
import org.compass.core.mapping.osem.HasRefAliasMapping;

public class ResolveRefAliasProcessor
implements MappingProcessor {
    private CompassMapping compassMapping;

    public CompassMapping process(CompassMapping compassMapping, PropertyNamingStrategy namingStrategy, ConverterLookup converterLookup, CompassSettings settings) throws MappingException {
        this.compassMapping = compassMapping;
        Iterator rIt = compassMapping.mappingsIt();
        while (rIt.hasNext()) {
            Mapping mapping = (Mapping)rIt.next();
            if (!(mapping instanceof ClassMapping)) continue;
            ClassMapping classMapping = (ClassMapping)mapping;
            Iterator it = classMapping.mappingsIt();
            while (it.hasNext()) {
                Mapping innerMapping = (Mapping)it.next();
                if (!(innerMapping instanceof HasRefAliasMapping)) continue;
                this.processMapping(classMapping, (HasRefAliasMapping)innerMapping);
            }
        }
        return compassMapping;
    }

    void processMapping(ClassMapping classMapping, HasRefAliasMapping mapping) throws MappingException {
        if (mapping.getRefAlias() != null) {
            ClassMapping refClassMapping = (ClassMapping)this.compassMapping.getResourceMappingByAlias(mapping.getRefAlias());
            if (refClassMapping == null) {
                throw new MappingException("Failed to resolve ref-alias [" + mapping.getRefAlias() + "] for [" + mapping.getName() + "] in alias [" + classMapping.getAlias() + "]");
            }
            mapping.setRefClassMapping(refClassMapping);
            return;
        }
        Class clazz = mapping.getRefClass();
        if (clazz == null) {
            clazz = mapping.getGetter().getReturnType();
        }
        if (clazz == null) {
            throw new MappingException("This should not happen");
        }
        ClassMapping refClassMapping = this.compassMapping.getClassMappingByClass(clazz.getName());
        if (refClassMapping == null) {
            if (Collection.class.isAssignableFrom(mapping.getGetter().getReturnType())) {
                throw new MappingException("Failed to resolve ref-alias for collection property [" + mapping.getName() + "] in alias [" + classMapping.getAlias() + "]. You must set the ref-alias for it, or use Java 5 generics for the collection type." + " Have you added the class mapping to Compass?");
            }
            throw new MappingException("Tried to resolve ref-alias for property [" + mapping.getName() + "] in alias [" + classMapping.getAlias() + "], but no class mapping was found for [" + clazz.getName() + "]");
        }
        if (this.compassMapping.hasMultipleClassMapping(clazz.getName())) {
            throw new MappingException("Tried to resolve ref-alias for property [" + mapping.getName() + "] in alias [" + classMapping.getAlias() + "], but there are multiple class mappings for [" + clazz.getName() + "]. Please set the ref-alias explicitly.");
        }
        mapping.setRefAlias(refClassMapping.getAlias());
        mapping.setRefClassMapping(refClassMapping);
    }
}

