/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.config.process;

import org.compass.core.config.CompassSettings;
import org.compass.core.config.process.MappingProcessor;
import org.compass.core.converter.ConverterLookup;
import org.compass.core.engine.naming.PropertyNamingStrategy;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.mapping.InvalidMappingException;
import org.compass.core.mapping.MappingException;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.mapping.ResourcePropertyMapping;

public class ValidatorMappingProcessor
implements MappingProcessor {
    public CompassMapping process(CompassMapping compassMapping, PropertyNamingStrategy namingStrategy, ConverterLookup converterLookup, CompassSettings settings) throws MappingException {
        ResourceMapping[] rootMappings = compassMapping.getRootMappings();
        for (int i = 0; i < rootMappings.length; ++i) {
            ResourceMapping resourceMapping = rootMappings[i];
            this.validateRootMapping(resourceMapping);
        }
        return compassMapping;
    }

    private void validateRootMapping(ResourceMapping resourceMapping) throws MappingException {
        this.validatieHasAtLeastOneId(resourceMapping);
        String[] resourcePropertyNames = resourceMapping.getResourcePropertyNames();
        for (int i = 0; i < resourcePropertyNames.length; ++i) {
            String propertyName = resourcePropertyNames[i];
            ResourcePropertyMapping[] resourcePropertyMapping = resourceMapping.getResourcePropertyMappings(propertyName);
            this.validateDuplicateExcludeFromAll(resourceMapping, propertyName, resourcePropertyMapping);
            this.validateDuplicateAnalyzer(resourceMapping, propertyName, resourcePropertyMapping);
        }
    }

    private void validatieHasAtLeastOneId(ResourceMapping resourceMapping) {
        ResourcePropertyMapping[] idMappings = resourceMapping.getIdMappings();
        if (idMappings.length == 0) {
            throw new MappingException("Mapping for alias [" + resourceMapping.getAlias() + "] has no id mappings defined. " + "Either you forgot to add id mappings for it, or it is a component mapping that requires no ids and it " + "is not configured with root=false");
        }
    }

    private void validateDuplicateExcludeFromAll(ResourceMapping resourceMapping, String propertyName, ResourcePropertyMapping[] resourcePropertyMapping) throws MappingException {
        if (resourcePropertyMapping.length == 1) {
            return;
        }
        boolean excludeFromAll = resourcePropertyMapping[0].isExcludeFromAll();
        for (int i = 1; i < resourcePropertyMapping.length; ++i) {
            if (resourcePropertyMapping[i].isInternal() || excludeFromAll == resourcePropertyMapping[i].isExcludeFromAll()) continue;
            throw new InvalidMappingException("Resource property / meta-data [" + propertyName + "] of alias [" + resourceMapping.getAlias() + "] has different exclude from all settings");
        }
    }

    private void validateDuplicateAnalyzer(ResourceMapping resourceMapping, String propertyName, ResourcePropertyMapping[] resourcePropertyMapping) throws MappingException {
        if (resourcePropertyMapping.length == 1) {
            return;
        }
        boolean first = true;
        String lastAnalyzer = null;
        for (int i = 0; i < resourcePropertyMapping.length; ++i) {
            ResourcePropertyMapping propertyMapping = resourcePropertyMapping[i];
            if (propertyMapping.isInternal()) continue;
            if (propertyMapping.getAnalyzer() != null) {
                if (lastAnalyzer == null && !first) {
                    throw new InvalidMappingException("Resource property / meta-data [" + propertyName + "] of alias [" + resourceMapping.getAlias() + "] has an anlyzer set, and some do not. Please set for all of them the same analyzer.");
                }
                if (first) {
                    lastAnalyzer = propertyMapping.getAnalyzer();
                } else if (!propertyMapping.getAnalyzer().equals(lastAnalyzer)) {
                    throw new InvalidMappingException("Resource property / meta-data [" + propertyName + "] of alias [" + resourceMapping.getAlias() + "] has several anlyzers set. Please set for all of them the same analyzer.");
                }
            } else if (lastAnalyzer != null) {
                throw new InvalidMappingException("Resource property / meta-data [" + propertyName + "] of alias [" + resourceMapping.getAlias() + "] has several anlyzers set. Please set for all of them the same analyzer.");
            }
            if (!first) continue;
            first = false;
        }
    }
}

