/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.converter.basic;

import org.compass.core.Property;
import org.compass.core.Resource;
import org.compass.core.converter.ConversionException;
import org.compass.core.converter.ResourcePropertyConverter;
import org.compass.core.engine.SearchEngine;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.ResourcePropertyMapping;
import org.compass.core.marshall.MarshallingContext;

public abstract class AbstractBasicConverter
implements ResourcePropertyConverter {
    public boolean marshall(Resource resource, Object root, Mapping mapping, MarshallingContext context) throws ConversionException {
        ResourcePropertyMapping resourcePropertyMapping = (ResourcePropertyMapping)mapping;
        SearchEngine searchEngine = context.getSearchEngine();
        if (root == null && !this.handleNulls(context)) {
            return false;
        }
        String sValue = this.getNullValue(context);
        if (root != null) {
            sValue = this.toString(root, resourcePropertyMapping);
        }
        Property p = searchEngine.createProperty(sValue, resourcePropertyMapping);
        this.doSetBoost(p, root, resourcePropertyMapping, context);
        resource.addProperty(p);
        return resourcePropertyMapping.getStore() != Property.Store.NO;
    }

    public Object unmarshall(Resource resource, Mapping mapping, MarshallingContext context) throws ConversionException {
        ResourcePropertyMapping resourcePropertyMapping = (ResourcePropertyMapping)mapping;
        if (resourcePropertyMapping.getStore() == Property.Store.NO) {
            return null;
        }
        String propertyName = resourcePropertyMapping.getPath().getPath();
        Property p = resource.getProperty(propertyName);
        if (p == null || this.isNullValue(context, p.getStringValue())) {
            return null;
        }
        return this.fromString(p.getStringValue(), resourcePropertyMapping);
    }

    protected boolean handleNulls(MarshallingContext context) {
        return context.handleNulls();
    }

    protected String getNullValue(MarshallingContext context) {
        return context.getSearchEngine().getNullValue();
    }

    protected boolean isNullValue(MarshallingContext context, String value) {
        return context.getSearchEngine().isNullValue(value);
    }

    protected void doSetBoost(Property property, Object root, ResourcePropertyMapping resourcePropertyMapping, MarshallingContext context) throws ConversionException {
        property.setBoost(resourcePropertyMapping.getBoost());
    }

    public String toString(Object o, ResourcePropertyMapping resourcePropertyMapping) {
        return o.toString();
    }
}

