/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.converter.basic;

import java.text.DecimalFormat;
import java.text.Format;
import java.text.ParseException;
import java.util.Locale;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.converter.ConversionException;
import org.compass.core.converter.basic.AbstractFormatConverter;
import org.compass.core.converter.basic.ThreadSafeFormat;
import org.compass.core.mapping.ResourcePropertyMapping;

public abstract class AbstractNumberConverter
extends AbstractFormatConverter
implements CompassConfigurable {
    protected ThreadSafeFormat.FormatterFactory doCreateFormatterFactory() {
        return new NumberFormatter();
    }

    protected abstract Object defaultFromString(String var1, ResourcePropertyMapping var2);

    protected abstract Object fromNumber(Number var1);

    protected String defaultToString(Object o, ResourcePropertyMapping resourcePropertyMapping) {
        return super.toString(o, resourcePropertyMapping);
    }

    public Object fromString(String str, ResourcePropertyMapping resourcePropertyMapping) {
        try {
            if (this.hasFormatter) {
                return this.fromNumber((Number)this.formatter.parse(str));
            }
            return this.defaultFromString(str, resourcePropertyMapping);
        }
        catch (ParseException e) {
            throw new ConversionException("Failed to parse number [" + str + "]", e);
        }
    }

    public String toString(Object o, ResourcePropertyMapping resourcePropertyMapping) {
        if (this.hasFormatter) {
            return this.formatter.format(o);
        }
        return this.defaultToString(o, resourcePropertyMapping);
    }

    private static class NumberFormatter
    implements ThreadSafeFormat.FormatterFactory {
        private String format;
        private Locale locale;

        private NumberFormatter() {
        }

        public void configure(String format, Locale locale) {
            this.format = format;
            this.locale = locale;
        }

        public Format create() {
            if (this.locale != null) {
                return new DecimalFormat(this.format);
            }
            return new DecimalFormat(this.format);
        }
    }
}

