/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.converter.extended;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.compass.core.Property;
import org.compass.core.Resource;
import org.compass.core.converter.ConversionException;
import org.compass.core.converter.Converter;
import org.compass.core.engine.SearchEngine;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.ResourcePropertyMapping;
import org.compass.core.marshall.MarshallingContext;

public class InputStreamConverter
implements Converter {
    private static final int DEFAULT_BUFFER_SIZE = 1024;

    public boolean marshall(Resource resource, Object root, Mapping mapping, MarshallingContext context) throws ConversionException {
        ResourcePropertyMapping resourcePropertyMapping = (ResourcePropertyMapping)mapping;
        SearchEngine searchEngine = context.getSearchEngine();
        if (root == null) {
            return false;
        }
        String propertyName = resourcePropertyMapping.getPath().getPath();
        InputStream input = (InputStream)root;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int n = 0;
        try {
            while (-1 != (n = input.read(buffer))) {
                output.write(buffer, 0, n);
            }
        }
        catch (IOException e) {
            throw new ConversionException("Failed to read input stream for [" + propertyName + "]", e);
        }
        Property p = searchEngine.createProperty(propertyName, output.toByteArray(), resourcePropertyMapping.getStore());
        p.setBoost(resourcePropertyMapping.getBoost());
        resource.addProperty(p);
        return resourcePropertyMapping.getStore() != Property.Store.NO;
    }

    public Object unmarshall(Resource resource, Mapping mapping, MarshallingContext context) throws ConversionException {
        ResourcePropertyMapping resourcePropertyMapping = (ResourcePropertyMapping)mapping;
        if (resourcePropertyMapping.getStore() == Property.Store.NO) {
            return null;
        }
        String propertyName = resourcePropertyMapping.getPath().getPath();
        Property p = resource.getProperty(propertyName);
        if (p == null) {
            return null;
        }
        return new ByteArrayInputStream(p.getBinaryValue());
    }
}

