/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.converter.mapping.osem;

import java.lang.reflect.Array;
import java.util.Iterator;
import org.compass.core.Property;
import org.compass.core.Resource;
import org.compass.core.accessor.Getter;
import org.compass.core.accessor.Setter;
import org.compass.core.converter.ConversionException;
import org.compass.core.converter.mapping.ResourceMappingConverter;
import org.compass.core.engine.SearchEngine;
import org.compass.core.impl.ResourceIdKey;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.mapping.ResourcePropertyMapping;
import org.compass.core.mapping.osem.ClassMapping;
import org.compass.core.mapping.osem.ClassPropertyMetaDataMapping;
import org.compass.core.mapping.osem.ObjectMapping;
import org.compass.core.marshall.MarshallingContext;
import org.compass.core.util.ClassUtils;
import org.compass.core.util.ResourceHelper;

public class ClassMappingConverter
implements ResourceMappingConverter {
    public boolean marshall(Resource resource, Object root, Mapping mapping, MarshallingContext context) throws ConversionException {
        SearchEngine searchEngine = context.getSearchEngine();
        ClassMapping classMapping = (ClassMapping)mapping;
        if (classMapping.isRoot()) {
            resource.setAlias(classMapping.getAlias());
            this.doSetBoost(resource, root, classMapping, context);
        }
        if (classMapping.isPoly() && classMapping.getPolyClass() == null) {
            String className = root.getClass().getName();
            Property p = searchEngine.createProperty(classMapping.getClassPath().getPath(), className, Property.Store.YES, Property.Index.UN_TOKENIZED);
            resource.addProperty(p);
        }
        boolean store = false;
        Iterator mappingsIt = classMapping.mappingsIt();
        while (mappingsIt.hasNext()) {
            Object value;
            context.setAttribute("current", root);
            Mapping m = (Mapping)mappingsIt.next();
            if (m instanceof ObjectMapping) {
                Getter getter = ((ObjectMapping)m).getGetter();
                value = getter.get(root);
            } else {
                value = root;
            }
            store |= m.getConverter().marshall(resource, value, m, context);
        }
        return store;
    }

    public Object unmarshall(Resource resource, Mapping mapping, MarshallingContext context) throws ConversionException {
        ClassMapping classMapping = (ClassMapping)mapping;
        ResourceIdKey resourceIdKey = null;
        if (classMapping.isRoot()) {
            Property[] ids = ResourceHelper.toIds(classMapping.getAlias(), resource, context.getCompassMapping());
            resourceIdKey = new ResourceIdKey(classMapping.getAlias(), ids);
            Object cached = context.getUnmarshalled(resourceIdKey);
            if (cached != null) {
                return cached;
            }
        }
        String className = classMapping.getName();
        if (classMapping.isPoly()) {
            if (classMapping.getPolyClass() != null) {
                className = classMapping.getPolyClass().getName();
            } else {
                Property pClassName = resource.getProperty(classMapping.getClassPath().getPath());
                if (pClassName == null) {
                    throw new ConversionException("The class [" + className + "] is configured as poly, but no class information is stored in the resource");
                }
                className = pClassName.getStringValue();
                if (className == null) {
                    throw new ConversionException("The class [" + className + "] is configured as poly, but no class information is stored in the resource");
                }
            }
        }
        try {
            Class clazz = ClassUtils.forName(className);
            Object obj = ClassUtils.getDefaultConstructor(clazz).newInstance(null);
            context.setAttribute("current", obj);
            if (classMapping.isRoot()) {
                context.setUnmarshalled(resourceIdKey, obj);
            }
            boolean isNullClass = true;
            Iterator mappingsIt = classMapping.mappingsIt();
            while (mappingsIt.hasNext()) {
                context.setAttribute("current", obj);
                Mapping m = (Mapping)mappingsIt.next();
                if (m instanceof ObjectMapping) {
                    Object value;
                    Setter setter = ((ObjectMapping)m).getSetter();
                    if (setter == null || (value = m.getConverter().unmarshall(resource, m, context)) == null) continue;
                    setter.set(obj, value);
                    if (!m.controlsObjectNullability()) continue;
                    isNullClass = false;
                    continue;
                }
                m.getConverter().unmarshall(resource, m, context);
            }
            if (isNullClass) {
                return null;
            }
            return obj;
        }
        catch (Exception e) {
            throw new ConversionException("Failed to create class [" + className + "] for unmarshalling", e);
        }
    }

    public boolean marshallIds(Resource idResource, Object id, ResourceMapping resourceMapping, MarshallingContext context) throws ConversionException {
        ClassMapping classMapping = (ClassMapping)resourceMapping;
        boolean stored = false;
        ResourcePropertyMapping[] ids = classMapping.getIdMappings();
        if (classMapping.getClazz().isAssignableFrom(id.getClass())) {
            for (int i = 0; i < ids.length; ++i) {
                ClassPropertyMetaDataMapping classPropertyMetaDataMapping = (ClassPropertyMetaDataMapping)ids[i];
                stored |= this.convertId(idResource, classPropertyMetaDataMapping.getGetter().get(id), classPropertyMetaDataMapping, context);
            }
        } else if (id.getClass().isArray()) {
            if (Array.getLength(id) != ids.length) {
                throw new ConversionException("Trying to load class with [" + Array.getLength(id) + "] while has ids mappings of [" + ids.length + "]");
            }
            for (int i = 0; i < ids.length; ++i) {
                stored |= this.convertId(idResource, Array.get(id, i), (ClassPropertyMetaDataMapping)ids[i], context);
            }
        } else if (ids.length == 1) {
            stored = this.convertId(idResource, id, (ClassPropertyMetaDataMapping)ids[0], context);
        } else {
            String type = id.getClass().getName();
            throw new ConversionException("Cannot marshall ids, not supported id object type [" + type + "] and value [" + id + "], or you have not defined ids in the mapping files");
        }
        return stored;
    }

    private boolean convertId(Resource resource, Object root, ClassPropertyMetaDataMapping mdMapping, MarshallingContext context) {
        if (root == null) {
            throw new ConversionException("Trying to marshall a null id [" + mdMapping.getName() + "]");
        }
        return mdMapping.getConverter().marshall(resource, root, mdMapping, context);
    }

    public Object[] unmarshallIds(Object id, ResourceMapping resourceMapping, MarshallingContext context) throws ConversionException {
        ClassMapping classMapping = (ClassMapping)resourceMapping;
        ResourcePropertyMapping[] ids = classMapping.getIdMappings();
        Object[] idsValues = new Object[ids.length];
        if (id instanceof Resource) {
            Resource resource = (Resource)id;
            for (int i = 0; i < ids.length; ++i) {
                idsValues[i] = ids[i].getConverter().unmarshall(resource, ids[i], context);
                if (idsValues[i] != null) continue;
                return null;
            }
        } else if (classMapping.getClazz().isAssignableFrom(id.getClass())) {
            for (int i = 0; i < ids.length; ++i) {
                ClassPropertyMetaDataMapping classPropertyMetaDataMapping = (ClassPropertyMetaDataMapping)ids[i];
                idsValues[i] = classPropertyMetaDataMapping.getGetter().get(id);
            }
        } else if (id.getClass().isArray()) {
            if (Array.getLength(id) != ids.length) {
                throw new ConversionException("Trying to load class with [" + Array.getLength(id) + "] while has ids mappings of [" + ids.length + "]");
            }
            for (int i = 0; i < ids.length; ++i) {
                idsValues[i] = Array.get(id, i);
            }
        } else if (ids.length == 1) {
            idsValues[0] = id;
        } else {
            String type = id.getClass().getName();
            throw new ConversionException("Cannot marshall ids, not supported id object type [" + type + "] and value [" + id + "], or you have not defined ids in the mapping files");
        }
        return idsValues;
    }

    protected void doSetBoost(Resource resource, Object root, ClassMapping classMapping, MarshallingContext context) throws ConversionException {
        resource.setBoost(classMapping.getBoost());
    }
}

