/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.impl;

import java.io.IOException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.compass.core.Compass;
import org.compass.core.CompassCallback;
import org.compass.core.CompassCallbackWithoutResult;
import org.compass.core.CompassException;
import org.compass.core.CompassSession;
import org.compass.core.CompassTemplate;
import org.compass.core.cache.first.FirstLevelCache;
import org.compass.core.cache.first.FirstLevelCacheFactory;
import org.compass.core.config.CompassSettings;
import org.compass.core.converter.ConverterLookup;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.engine.SearchEngineFactory;
import org.compass.core.engine.SearchEngineIndexManager;
import org.compass.core.engine.SearchEngineOptimizer;
import org.compass.core.engine.naming.PropertyNamingStrategy;
import org.compass.core.id.IdentifierGenerator;
import org.compass.core.id.UUIDGenerator;
import org.compass.core.impl.DefaultCompassSession;
import org.compass.core.jndi.CompassObjectFactory;
import org.compass.core.lucene.engine.LuceneSearchEngineFactory;
import org.compass.core.lucene.engine.LuceneSettings;
import org.compass.core.lucene.engine.manager.LuceneSearchEngineIndexManager;
import org.compass.core.lucene.engine.manager.ScheduledLuceneSearchEngineIndexManager;
import org.compass.core.lucene.engine.optimizer.LuceneSearchEngineOptimizer;
import org.compass.core.lucene.engine.optimizer.ScheduledLuceneSearchEngineOptimizer;
import org.compass.core.lucene.engine.store.LuceneSearchEngineStore;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.metadata.CompassMetaData;
import org.compass.core.spi.InternalCompass;
import org.compass.core.transaction.TransactionFactory;
import org.compass.core.transaction.TransactionFactoryFactory;

public class DefaultCompass
implements InternalCompass {
    private static final Log log = LogFactory.getLog((Class)DefaultCompass.class);
    private static final long serialVersionUID = 3256446884762891059L;
    private static final IdentifierGenerator UUID_GENERATOR = new UUIDGenerator();
    private final String name;
    private String uuid;
    private CompassMapping mapping;
    private SearchEngineFactory searchEngineFactory;
    private TransactionFactory transactionFactory;
    private ConverterLookup converterLookup;
    private CompassMetaData compassMetaData;
    private PropertyNamingStrategy propertyNamingStrategy;
    protected CompassSettings settings;
    private FirstLevelCacheFactory firstLevelCacheFactory;

    public DefaultCompass(CompassMapping mapping, ConverterLookup converterLookup, CompassMetaData compassMetaData, PropertyNamingStrategy propertyNamingStrategy, CompassSettings settings) throws CompassException {
        this(mapping, converterLookup, compassMetaData, propertyNamingStrategy, settings, false);
    }

    public DefaultCompass(CompassMapping mapping, ConverterLookup converterLookup, CompassMetaData compassMetaData, PropertyNamingStrategy propertyNamingStrategy, CompassSettings settings, boolean duplicate) throws CompassException {
        this(mapping, converterLookup, compassMetaData, propertyNamingStrategy, settings, duplicate, new LuceneSearchEngineFactory(propertyNamingStrategy, settings, mapping));
    }

    public DefaultCompass(CompassMapping mapping, ConverterLookup converterLookup, CompassMetaData compassMetaData, PropertyNamingStrategy propertyNamingStrategy, CompassSettings settings, boolean duplicate, LuceneSearchEngineFactory searchEngineFactory) throws CompassException {
        boolean scheduledOptimizer;
        this.mapping = mapping;
        this.converterLookup = converterLookup;
        this.compassMetaData = compassMetaData;
        this.propertyNamingStrategy = propertyNamingStrategy;
        this.name = settings.getSetting("compass.name", "default");
        this.settings = settings;
        if (!duplicate) {
            this.registerJndi();
        }
        this.searchEngineFactory = searchEngineFactory;
        this.transactionFactory = TransactionFactoryFactory.createTransactionFactory(this, settings);
        LuceneSearchEngineOptimizer optimizer = (LuceneSearchEngineOptimizer)searchEngineFactory.getOptimizer();
        if ((optimizer = new TransactionalSearchEngineOptimizer(optimizer, this)).canBeScheduled() && (scheduledOptimizer = settings.getSettingAsBoolean("compass.engine.optimizer.schedule", true))) {
            optimizer = new ScheduledLuceneSearchEngineOptimizer(optimizer);
        }
        optimizer.setSearchEngineFactory(searchEngineFactory);
        searchEngineFactory.setOptimizer(optimizer);
        LuceneSearchEngineIndexManager indexManager = searchEngineFactory.getLuceneIndexManager();
        indexManager = new TransactionalSearchEngineIndexManager(indexManager, this);
        indexManager = new ScheduledLuceneSearchEngineIndexManager(indexManager);
        searchEngineFactory.setIndexManager(indexManager);
        this.firstLevelCacheFactory = new FirstLevelCacheFactory();
        this.firstLevelCacheFactory.configure(settings);
        indexManager.verifyIndex();
        if (!duplicate) {
            indexManager.start();
            searchEngineFactory.getOptimizer().start();
        }
    }

    public Compass clone(CompassSettings addedSettings) {
        CompassSettings copySettings = this.settings.copy();
        copySettings.addSettings(addedSettings);
        return new DefaultCompass(this.mapping, this.converterLookup, this.compassMetaData, this.propertyNamingStrategy, copySettings, true);
    }

    public CompassMapping getMapping() {
        return this.mapping;
    }

    public CompassSession openSession() {
        return this.openSession(true);
    }

    public CompassSession openSession(boolean allowCreate) {
        CompassSession session = this.transactionFactory.getTransactionBoundSession();
        if (session != null) {
            return session;
        }
        if (!allowCreate) {
            return null;
        }
        FirstLevelCache firstLevelCache = this.firstLevelCacheFactory.createFirstLevelCache();
        return new DefaultCompassSession(this, this.searchEngineFactory.openSearchEngine(), firstLevelCache);
    }

    public void close() {
        log.info((Object)("Closing Compass [" + this.name + "]"));
        if (this.settings.getSettingAsBoolean("compass.jndi.enable", false)) {
            CompassObjectFactory.removeInstance(this.uuid, this.name, this.settings);
        }
        try {
            this.searchEngineFactory.getOptimizer().stop();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.searchEngineFactory.close();
        log.info((Object)("Closed Compass [" + this.name + "]"));
    }

    public Reference getReference() throws NamingException {
        return new Reference(DefaultCompass.class.getName(), new StringRefAddr("uuid", this.uuid), CompassObjectFactory.class.getName(), null);
    }

    public CompassSettings getSettings() {
        return this.settings;
    }

    public SearchEngineOptimizer getSearchEngineOptimizer() {
        return this.searchEngineFactory.getOptimizer();
    }

    public SearchEngineIndexManager getSearchEngineIndexManager() {
        return this.searchEngineFactory.getIndexManager();
    }

    public SearchEngineFactory getSearchEngineFactory() {
        return this.searchEngineFactory;
    }

    public CompassMetaData getMetaData() {
        return this.compassMetaData;
    }

    public TransactionFactory getTransactionFactory() {
        return this.transactionFactory;
    }

    public ConverterLookup getConverterLookup() {
        return this.converterLookup;
    }

    private void registerJndi() throws CompassException {
        if (!this.settings.getSettingAsBoolean("compass.jndi.enable", false)) {
            return;
        }
        try {
            this.uuid = (String)((Object)UUID_GENERATOR.generate());
        }
        catch (Exception e) {
            throw new CompassException("Could not generate UUID for JNDI binding");
        }
        CompassObjectFactory.addInstance(this.uuid, this.name, this, this.settings);
    }

    public static class TransactionalSearchEngineOptimizer
    implements LuceneSearchEngineOptimizer {
        private LuceneSearchEngineOptimizer searchEngineOptimizer;
        private CompassTemplate template;

        public TransactionalSearchEngineOptimizer(LuceneSearchEngineOptimizer searchEngineOptimizer, Compass compass) {
            this.searchEngineOptimizer = searchEngineOptimizer;
            this.template = new CompassTemplate(compass);
        }

        public LuceneSearchEngineOptimizer getWrappedOptimizer() {
            return this.searchEngineOptimizer;
        }

        public void start() throws SearchEngineException {
            this.searchEngineOptimizer.start();
        }

        public void stop() throws SearchEngineException {
            this.searchEngineOptimizer.stop();
        }

        public boolean isRunning() {
            return this.searchEngineOptimizer.isRunning();
        }

        public boolean needOptimization() throws SearchEngineException {
            return this.searchEngineOptimizer.needOptimization();
        }

        public void optimize() throws SearchEngineException {
            this.searchEngineOptimizer.optimize();
        }

        public void setSearchEngineFactory(LuceneSearchEngineFactory searchEngineFactory) {
            this.searchEngineOptimizer.setSearchEngineFactory(searchEngineFactory);
        }

        public LuceneSearchEngineFactory getSearchEngineFactory() {
            return this.searchEngineOptimizer.getSearchEngineFactory();
        }

        public boolean canBeScheduled() {
            return this.searchEngineOptimizer.canBeScheduled();
        }

        public boolean needOptimization(final String subIndex) throws SearchEngineException {
            return (Boolean)this.template.execute(new CompassCallback(){

                public Object doInCompass(CompassSession session) throws CompassException {
                    return TransactionalSearchEngineOptimizer.this.searchEngineOptimizer.needOptimization(subIndex) ? Boolean.TRUE : Boolean.FALSE;
                }
            });
        }

        public void optimize(final String subIndex) throws SearchEngineException {
            this.template.execute(new CompassCallbackWithoutResult(){

                protected void doInCompassWithoutResult(CompassSession session) throws CompassException {
                    TransactionalSearchEngineOptimizer.this.searchEngineOptimizer.optimize(subIndex);
                }
            });
        }
    }

    private static class TransactionalSearchEngineIndexManager
    implements LuceneSearchEngineIndexManager {
        private LuceneSearchEngineIndexManager indexManager;
        private CompassTemplate template;

        private TransactionalSearchEngineIndexManager(LuceneSearchEngineIndexManager indexManager, Compass compass) {
            this.indexManager = indexManager;
            this.template = new CompassTemplate(compass);
        }

        public void start() {
            this.indexManager.start();
        }

        public void stop() {
            this.indexManager.stop();
        }

        public void close() {
            this.indexManager.close();
        }

        public boolean isRunning() {
            return this.indexManager.isRunning();
        }

        public void createIndex() throws SearchEngineException {
            this.template.execute(new CompassCallbackWithoutResult(){

                protected void doInCompassWithoutResult(CompassSession session) throws CompassException {
                    TransactionalSearchEngineIndexManager.this.indexManager.createIndex();
                }
            });
        }

        public boolean verifyIndex() throws SearchEngineException {
            return (Boolean)this.template.execute(new CompassCallback(){

                public Object doInCompass(CompassSession session) throws CompassException {
                    return TransactionalSearchEngineIndexManager.this.indexManager.verifyIndex() ? Boolean.TRUE : Boolean.FALSE;
                }
            });
        }

        public void deleteIndex() throws SearchEngineException {
            this.template.execute(new CompassCallbackWithoutResult(){

                protected void doInCompassWithoutResult(CompassSession session) throws CompassException {
                    TransactionalSearchEngineIndexManager.this.indexManager.deleteIndex();
                }
            });
        }

        public boolean indexExists() throws SearchEngineException {
            return (Boolean)this.template.execute(new CompassCallback(){

                public Object doInCompass(CompassSession session) throws CompassException {
                    return TransactionalSearchEngineIndexManager.this.indexManager.indexExists() ? Boolean.TRUE : Boolean.FALSE;
                }
            });
        }

        public void operate(final SearchEngineIndexManager.IndexOperationCallback callback) throws SearchEngineException {
            this.template.execute(new CompassCallbackWithoutResult(){

                protected void doInCompassWithoutResult(CompassSession session) throws CompassException {
                    TransactionalSearchEngineIndexManager.this.indexManager.operate(callback);
                }
            });
        }

        public void replaceIndex(final SearchEngineIndexManager innerIndexManager, final SearchEngineIndexManager.ReplaceIndexCallback callback) throws SearchEngineException {
            this.template.execute(new CompassCallbackWithoutResult(){

                protected void doInCompassWithoutResult(CompassSession session) throws CompassException {
                    TransactionalSearchEngineIndexManager.this.indexManager.replaceIndex(innerIndexManager, callback);
                }
            });
        }

        public boolean isCached(String subIndex) throws SearchEngineException {
            return this.indexManager.isCached(subIndex);
        }

        public boolean isCached() throws SearchEngineException {
            return this.indexManager.isCached();
        }

        public void clearCache(String subIndex) throws SearchEngineException {
            this.indexManager.clearCache(subIndex);
        }

        public void clearCache() throws SearchEngineException {
            this.indexManager.clearCache();
        }

        public void notifyAllToClearCache() throws SearchEngineException {
            this.template.execute(new CompassCallbackWithoutResult(){

                protected void doInCompassWithoutResult(CompassSession session) throws CompassException {
                    TransactionalSearchEngineIndexManager.this.indexManager.notifyAllToClearCache();
                }
            });
        }

        public void checkAndClearIfNotifiedAllToClearCache() throws SearchEngineException {
            this.template.execute(new CompassCallbackWithoutResult(){

                protected void doInCompassWithoutResult(CompassSession session) throws CompassException {
                    TransactionalSearchEngineIndexManager.this.indexManager.checkAndClearIfNotifiedAllToClearCache();
                }
            });
        }

        public boolean isIndexCompound() throws SearchEngineException {
            return (Boolean)this.template.execute(new CompassCallback(){

                public Object doInCompass(CompassSession session) throws CompassException {
                    return TransactionalSearchEngineIndexManager.this.indexManager.isIndexCompound() ? Boolean.TRUE : Boolean.FALSE;
                }
            });
        }

        public boolean isIndexUnCompound() throws SearchEngineException {
            return (Boolean)this.template.execute(new CompassCallback(){

                public Object doInCompass(CompassSession session) throws CompassException {
                    return TransactionalSearchEngineIndexManager.this.indexManager.isIndexUnCompound() ? Boolean.TRUE : Boolean.FALSE;
                }
            });
        }

        public void compoundIndex() throws SearchEngineException {
            this.template.execute(new CompassCallbackWithoutResult(){

                protected void doInCompassWithoutResult(CompassSession session) throws CompassException {
                    TransactionalSearchEngineIndexManager.this.indexManager.compoundIndex();
                }
            });
        }

        public void unCompoundIndex() throws SearchEngineException {
            this.template.execute(new CompassCallbackWithoutResult(){

                protected void doInCompassWithoutResult(CompassSession session) throws CompassException {
                    TransactionalSearchEngineIndexManager.this.indexManager.unCompoundIndex();
                }
            });
        }

        public LuceneSettings getSettings() {
            return this.indexManager.getSettings();
        }

        public LuceneSearchEngineStore getStore() {
            return this.indexManager.getStore();
        }

        public IndexWriter openIndexWriter(Directory dir, boolean create) throws IOException {
            return this.indexManager.openIndexWriter(dir, create);
        }

        public void closeIndexWriter(IndexWriter indexWriter, Directory dir) throws SearchEngineException {
            this.indexManager.closeIndexWriter(indexWriter, dir);
        }

        public LuceneSearchEngineIndexManager.LuceneIndexHolder openIndexHolderByAlias(String alias) throws SearchEngineException {
            return this.indexManager.openIndexHolderByAlias(alias);
        }

        public LuceneSearchEngineIndexManager.LuceneIndexHolder openIndexHolderBySubIndex(String subIndex) throws SearchEngineException {
            return this.indexManager.openIndexHolderBySubIndex(subIndex);
        }

        public void setWaitForCacheInvalidationBeforeSecondStep(long timeToWaitInMillis) {
            this.indexManager.setWaitForCacheInvalidationBeforeSecondStep(timeToWaitInMillis);
        }
    }
}

