/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.impl;

import java.io.Reader;
import org.compass.core.CompassAnalyzerHelper;
import org.compass.core.CompassException;
import org.compass.core.CompassToken;
import org.compass.core.Resource;
import org.compass.core.engine.SearchEngineAnalyzerHelper;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.spi.InternalCompassSession;

public class DefaultCompassAnalyzerHelper
implements CompassAnalyzerHelper {
    private InternalCompassSession session;
    private SearchEngineAnalyzerHelper analyzerHelper;

    public DefaultCompassAnalyzerHelper(SearchEngineAnalyzerHelper analyzerHelper, InternalCompassSession session) {
        this.session = session;
        this.analyzerHelper = analyzerHelper;
    }

    public CompassAnalyzerHelper setAnalyzer(String analyzerName) throws CompassException {
        this.analyzerHelper.setAnalyzer(analyzerName);
        return this;
    }

    public CompassAnalyzerHelper setAnalyzer(Resource resource) throws CompassException {
        this.analyzerHelper.setAnalyzer(resource);
        return this;
    }

    public CompassAnalyzerHelper setAnalyzerByAlias(String alias) throws CompassException {
        this.analyzerHelper.setAnalyzerByAlias(alias);
        return this;
    }

    public CompassToken analyzeSingle(String text) throws CompassException {
        return this.analyzerHelper.analyzeSingle(text);
    }

    public CompassToken[] analyze(String text) throws CompassException {
        return this.analyzerHelper.analyze(text);
    }

    public CompassToken[] analyze(String propertyName, String text) throws CompassException {
        CompassMapping.ResourcePropertyLookup lookup = this.session.getMapping().getResourcePropertyLookup(propertyName);
        return this.analyzerHelper.analyze(lookup.getPath(), text);
    }

    public CompassToken[] analyze(Reader textReader) throws CompassException {
        return this.analyzerHelper.analyze(textReader);
    }

    public CompassToken[] analyze(String propertyName, Reader textReader) throws CompassException {
        CompassMapping.ResourcePropertyLookup lookup = this.session.getMapping().getResourcePropertyLookup(propertyName);
        return this.analyzerHelper.analyze(lookup.getPath(), textReader);
    }
}

