/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.impl;

import org.compass.core.CompassDetachedHits;
import org.compass.core.CompassException;
import org.compass.core.CompassHighlightedText;
import org.compass.core.CompassHit;
import org.compass.core.CompassHitIterator;
import org.compass.core.Resource;
import org.compass.core.impl.AbstractCompassHits;
import org.compass.core.impl.DefaultCompassHit;
import org.compass.core.impl.DefaultCompassHitIterator;
import org.compass.core.spi.InternalCompassHits;
import org.compass.core.spi.InternalCompassSession;

public class DefaultCompassDetachedHits
extends AbstractCompassHits
implements CompassDetachedHits {
    private int length;
    private int totalLength;
    private Resource[] resources;
    private Object[] datas;
    private float[] scores;
    private CompassHit[] hits;
    private CompassHighlightedText[] highlightedText;

    public DefaultCompassDetachedHits(InternalCompassHits hits, InternalCompassSession session, int from, int size) throws CompassException, IllegalArgumentException {
        this.length = size;
        if (from < 0) {
            throw new IllegalArgumentException("Can't preload with negative from [" + from + "]");
        }
        if (from + size > hits.getLength()) {
            this.length = hits.getLength() - from;
        }
        this.totalLength = hits.getLength();
        this.resources = new Resource[this.length];
        this.scores = new float[this.length];
        this.datas = new Object[this.length];
        this.hits = new CompassHit[this.length];
        this.highlightedText = new CompassHighlightedText[this.length];
        for (int i = 0; i < this.length; ++i) {
            int location = from + i;
            this.resources[i] = hits.resource(location);
            this.scores[i] = hits.score(location);
            this.hits[i] = new DefaultCompassHit(this, i);
            this.highlightedText[i] = hits.highlightedText(location);
            if (!session.getMapping().hasClassMapping(this.resources[i].getAlias())) continue;
            this.datas[i] = session.getByResource(this.resources[i]);
        }
    }

    public float score(int n) throws CompassException, IllegalArgumentException {
        return this.scores[n];
    }

    public Resource resource(int n) throws CompassException, IllegalArgumentException {
        return this.resources[n];
    }

    public Object data(int n) throws CompassException, IllegalArgumentException {
        return this.datas[n];
    }

    public CompassHighlightedText highlightedText(int n) throws CompassException {
        return this.highlightedText[n];
    }

    public CompassHitIterator iterator() throws CompassException {
        return new DefaultCompassHitIterator(this);
    }

    public CompassHit hit(int n) throws CompassException {
        return this.hits[n];
    }

    public int getLength() {
        return this.length;
    }

    public int getTotalLength() {
        return this.totalLength;
    }

    public int totalLength() {
        return this.totalLength;
    }

    public Resource[] getResources() throws CompassException {
        return this.resources;
    }

    public Object[] getDatas() throws CompassException {
        return this.datas;
    }

    public CompassHit[] getHits() throws CompassException {
        return this.hits;
    }
}

