/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.impl;

import org.compass.core.CompassException;
import org.compass.core.CompassHighlightedText;
import org.compass.core.CompassHit;
import org.compass.core.CompassHitsOperations;
import org.compass.core.Resource;

public class DefaultCompassHit
implements CompassHit {
    private static final long serialVersionUID = 3617578210385408048L;
    private Resource resource;
    private Object data;
    private float score;
    private boolean resolvedResource;
    private boolean resolvedData;
    private CompassHitsOperations compassHits;
    private int hitNumber;

    DefaultCompassHit(CompassHitsOperations compassHits, int hitNumber) {
        this.compassHits = compassHits;
        this.hitNumber = hitNumber;
    }

    public Object getData() {
        this.fetchTheData();
        return this.data;
    }

    public Resource getResource() throws CompassException {
        this.fetchTheResource();
        return this.resource;
    }

    public float getScore() throws CompassException {
        this.fetchTheResource();
        return this.score;
    }

    public CompassHighlightedText getHighlightedText() throws CompassException {
        return this.compassHits.highlightedText(this.hitNumber);
    }

    public String getAlias() throws CompassException {
        this.fetchTheResource();
        return this.resource.getAlias();
    }

    private void fetchTheData() throws CompassException {
        this.fetchTheResource();
        if (!this.resolvedData) {
            this.data = this.compassHits.data(this.hitNumber);
            this.resolvedData = true;
        }
    }

    private void fetchTheResource() throws CompassException {
        if (!this.resolvedResource) {
            this.resource = this.compassHits.resource(this.hitNumber);
            this.score = this.compassHits.score(this.hitNumber);
            this.resolvedResource = true;
        }
    }
}

