/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.impl;

import java.util.HashMap;
import org.compass.core.CompassDetachedHits;
import org.compass.core.CompassException;
import org.compass.core.CompassHighlightedText;
import org.compass.core.CompassHighlighter;
import org.compass.core.CompassHit;
import org.compass.core.Resource;
import org.compass.core.engine.SearchEngineHits;
import org.compass.core.impl.AbstractCompassHits;
import org.compass.core.impl.DefaultCompassDetachedHits;
import org.compass.core.impl.DefaultCompassHighlightedText;
import org.compass.core.impl.DefaultCompassHighlighter;
import org.compass.core.impl.DefaultCompassHit;
import org.compass.core.impl.ResourceIdKey;
import org.compass.core.spi.InternalCompassHighlightedText;
import org.compass.core.spi.InternalCompassHits;
import org.compass.core.spi.InternalCompassSession;

public class DefaultCompassHits
extends AbstractCompassHits
implements InternalCompassHits {
    private SearchEngineHits hits;
    private InternalCompassSession session;
    private HashMap highlightedTextHolder;

    public DefaultCompassHits(SearchEngineHits hits, InternalCompassSession session) {
        this.hits = hits;
        this.session = session;
    }

    public SearchEngineHits getSearchEngineHits() {
        return this.hits;
    }

    public CompassHit hit(int n) throws CompassException {
        return new DefaultCompassHit(this, n);
    }

    public Object data(int n) throws CompassException {
        Resource resource = this.resource(n);
        return this.session.getByResource(resource);
    }

    public Resource resource(int n) throws CompassException {
        Resource resource = this.hits.getResource(n);
        ResourceIdKey key = new ResourceIdKey(this.session.getMapping(), resource);
        Resource cachedResource = this.session.getFirstLevelCache().getResource(key);
        if (cachedResource != null) {
            return cachedResource;
        }
        this.session.getFirstLevelCache().setResource(key, resource);
        return resource;
    }

    public int getLength() {
        return this.hits.getLength();
    }

    public float score(int n) throws CompassException {
        return this.hits.score(n);
    }

    public CompassHighlighter highlighter(int n) throws CompassException {
        return new DefaultCompassHighlighter(this.session, this, n);
    }

    public CompassDetachedHits detach() throws CompassException {
        return this.detach(0, this.hits.getLength());
    }

    public CompassDetachedHits detach(int from, int size) throws CompassException, IllegalArgumentException {
        return new DefaultCompassDetachedHits(this, this.session, from, size);
    }

    public CompassHighlightedText highlightedText(int n) throws CompassException {
        if (this.highlightedTextHolder == null) {
            return null;
        }
        return (CompassHighlightedText)this.highlightedTextHolder.get(new Integer(n));
    }

    public void setHighlightedText(int n, String propertyName, String highlihgtedText) {
        Integer hitNumber;
        InternalCompassHighlightedText hitHighlightedText;
        if (this.highlightedTextHolder == null) {
            this.highlightedTextHolder = new HashMap();
        }
        if ((hitHighlightedText = (InternalCompassHighlightedText)this.highlightedTextHolder.get(hitNumber = new Integer(n))) == null) {
            hitHighlightedText = new DefaultCompassHighlightedText();
            this.highlightedTextHolder.put(hitNumber, hitHighlightedText);
        }
        hitHighlightedText.setHighlightedText(propertyName, highlihgtedText);
    }

    public void close() throws CompassException {
        this.hits.close();
    }
}

