/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.impl;

import org.compass.core.CompassException;
import org.compass.core.CompassQuery;
import org.compass.core.CompassQueryBuilder;
import org.compass.core.engine.SearchEngineQuery;
import org.compass.core.engine.SearchEngineQueryBuilder;
import org.compass.core.impl.DefaultCompassQuery;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.spi.InternalCompassSession;

public class DefaultCompassQueryBuilder
implements CompassQueryBuilder {
    private SearchEngineQueryBuilder queryBuilder;
    private InternalCompassSession session;

    public DefaultCompassQueryBuilder(SearchEngineQueryBuilder queryBuilder, InternalCompassSession session) {
        this.queryBuilder = queryBuilder;
        this.session = session;
    }

    public CompassQueryBuilder.CompassBooleanQueryBuilder bool() {
        return new DefaultCompassBooleanQueryBuilder(this.queryBuilder.bool(), this.session);
    }

    public CompassQueryBuilder.CompassBooleanQueryBuilder bool(boolean disableCoord) {
        return new DefaultCompassBooleanQueryBuilder(this.queryBuilder.bool(disableCoord), this.session);
    }

    public CompassQueryBuilder.CompassMultiPhraseQueryBuilder multiPhrase(String name) {
        CompassMapping.ResourcePropertyLookup lookup = this.session.getMapping().getResourcePropertyLookup(name);
        return new DefaultCompassMultiPhraseQueryBuilder(this.queryBuilder.multiPhrase(lookup.getPath()), this.session, lookup);
    }

    public CompassQueryBuilder.CompassQueryStringBuilder queryString(String queryString) {
        return new DefaultCompassQueryStringBuilder(this.queryBuilder.queryString(queryString), this.session);
    }

    public CompassQueryBuilder.CompassMultiPropertyQueryStringBuilder multiPropertyQueryString(String queryString) {
        return new DefaultCompassMultiPropertyQueryStringBuilder(this.queryBuilder.multiPropertyQueryString(queryString), this.session);
    }

    public CompassQuery alias(String aliasValue) {
        String aliasProperty = this.session.getCompass().getSearchEngineFactory().getAliasProperty();
        SearchEngineQuery query = this.queryBuilder.term(aliasProperty, aliasValue);
        return new DefaultCompassQuery(query, this.session);
    }

    public CompassQuery term(String name, Object value) {
        CompassMapping.ResourcePropertyLookup lookup = this.session.getMapping().getResourcePropertyLookup(name);
        SearchEngineQuery query = this.queryBuilder.term(lookup.getPath(), lookup.getValue(value));
        return new DefaultCompassQuery(query, this.session);
    }

    public CompassQuery matchAll() {
        SearchEngineQuery query = this.queryBuilder.matchAll();
        return new DefaultCompassQuery(query, this.session);
    }

    public CompassQuery between(String name, Object low, Object high, boolean inclusive, boolean constantScore) {
        CompassMapping.ResourcePropertyLookup lookup = this.session.getMapping().getResourcePropertyLookup(name);
        SearchEngineQuery query = this.queryBuilder.between(lookup.getPath(), lookup.getValue(low), lookup.getValue(high), inclusive, constantScore);
        return new DefaultCompassQuery(query, this.session);
    }

    public CompassQuery between(String name, Object low, Object high, boolean inclusive) {
        CompassMapping.ResourcePropertyLookup lookup = this.session.getMapping().getResourcePropertyLookup(name);
        SearchEngineQuery query = this.queryBuilder.between(lookup.getPath(), lookup.getValue(low), lookup.getValue(high), inclusive);
        return new DefaultCompassQuery(query, this.session);
    }

    public CompassQuery lt(String name, Object value) {
        CompassMapping.ResourcePropertyLookup lookup = this.session.getMapping().getResourcePropertyLookup(name);
        SearchEngineQuery query = this.queryBuilder.lt(lookup.getPath(), lookup.getValue(value));
        return new DefaultCompassQuery(query, this.session);
    }

    public CompassQuery le(String name, Object value) {
        CompassMapping.ResourcePropertyLookup lookup = this.session.getMapping().getResourcePropertyLookup(name);
        SearchEngineQuery query = this.queryBuilder.le(lookup.getPath(), lookup.getValue(value));
        return new DefaultCompassQuery(query, this.session);
    }

    public CompassQuery gt(String name, Object value) {
        CompassMapping.ResourcePropertyLookup lookup = this.session.getMapping().getResourcePropertyLookup(name);
        SearchEngineQuery query = this.queryBuilder.gt(lookup.getPath(), lookup.getValue(value));
        return new DefaultCompassQuery(query, this.session);
    }

    public CompassQuery ge(String name, Object value) {
        CompassMapping.ResourcePropertyLookup lookup = this.session.getMapping().getResourcePropertyLookup(name);
        SearchEngineQuery query = this.queryBuilder.ge(lookup.getPath(), lookup.getValue(value));
        return new DefaultCompassQuery(query, this.session);
    }

    public CompassQuery prefix(String name, String prefix) {
        CompassMapping.ResourcePropertyLookup lookup = this.session.getMapping().getResourcePropertyLookup(name);
        SearchEngineQuery query = this.queryBuilder.prefix(lookup.getPath(), prefix);
        return new DefaultCompassQuery(query, this.session);
    }

    public CompassQuery wildcard(String name, String wildcard) {
        CompassMapping.ResourcePropertyLookup lookup = this.session.getMapping().getResourcePropertyLookup(name);
        SearchEngineQuery query = this.queryBuilder.wildcard(lookup.getPath(), wildcard);
        return new DefaultCompassQuery(query, this.session);
    }

    public CompassQuery fuzzy(String name, String value, float minimumSimilarity) {
        CompassMapping.ResourcePropertyLookup lookup = this.session.getMapping().getResourcePropertyLookup(name);
        SearchEngineQuery query = this.queryBuilder.fuzzy(lookup.getPath(), value, minimumSimilarity);
        return new DefaultCompassQuery(query, this.session);
    }

    public CompassQuery fuzzy(String name, String value, float minimumSimilarity, int prefixLength) {
        CompassMapping.ResourcePropertyLookup lookup = this.session.getMapping().getResourcePropertyLookup(name);
        SearchEngineQuery query = this.queryBuilder.fuzzy(lookup.getPath(), value, minimumSimilarity, prefixLength);
        return new DefaultCompassQuery(query, this.session);
    }

    public CompassQuery fuzzy(String name, String value) {
        CompassMapping.ResourcePropertyLookup lookup = this.session.getMapping().getResourcePropertyLookup(name);
        SearchEngineQuery query = this.queryBuilder.fuzzy(lookup.getPath(), value);
        return new DefaultCompassQuery(query, this.session);
    }

    public CompassQuery.CompassSpanQuery spanEq(String name, Object value) {
        CompassMapping.ResourcePropertyLookup lookup = this.session.getMapping().getResourcePropertyLookup(name);
        SearchEngineQuery.SearchEngineSpanQuery query = this.queryBuilder.spanEq(lookup.getPath(), lookup.getValue(value));
        return new DefaultCompassQuery.DefaultCompassSpanQuey(query, this.session);
    }

    public CompassQuery.CompassSpanQuery spanFirst(String name, Object value, int end) {
        CompassMapping.ResourcePropertyLookup lookup = this.session.getMapping().getResourcePropertyLookup(name);
        SearchEngineQuery.SearchEngineSpanQuery query = this.queryBuilder.spanFirst(lookup.getPath(), lookup.getValue(value), end);
        return new DefaultCompassQuery.DefaultCompassSpanQuey(query, this.session);
    }

    public CompassQueryBuilder.CompassQuerySpanNearBuilder spanNear(String name) {
        CompassMapping.ResourcePropertyLookup lookup = this.session.getMapping().getResourcePropertyLookup(name);
        return new DefaultCompassQuerySpanNearBuilder(this.queryBuilder.spanNear(lookup.getPath()), this.session, lookup);
    }

    public CompassQuery.CompassSpanQuery spanNot(CompassQuery.CompassSpanQuery include, CompassQuery.CompassSpanQuery exclude) {
        SearchEngineQuery.SearchEngineSpanQuery query = this.queryBuilder.spanNot(((DefaultCompassQuery.DefaultCompassSpanQuey)include).getSearchEngineSpanQuery(), ((DefaultCompassQuery.DefaultCompassSpanQuey)exclude).getSearchEngineSpanQuery());
        return new DefaultCompassQuery.DefaultCompassSpanQuey(query, this.session);
    }

    public CompassQueryBuilder.CompassQuerySpanOrBuilder spanOr() {
        return new DefaultCompassQuerySpanOrBuilder(this.queryBuilder.spanOr(), this.session);
    }

    public static class DefaultCompassQuerySpanOrBuilder
    implements CompassQueryBuilder.CompassQuerySpanOrBuilder {
        private SearchEngineQueryBuilder.SearchEngineQuerySpanOrBuilder queryBuilder;
        private InternalCompassSession session;

        public DefaultCompassQuerySpanOrBuilder(SearchEngineQueryBuilder.SearchEngineQuerySpanOrBuilder queryBuilder, InternalCompassSession session) {
            this.queryBuilder = queryBuilder;
            this.session = session;
        }

        public CompassQueryBuilder.CompassQuerySpanOrBuilder add(CompassQuery.CompassSpanQuery query) {
            this.queryBuilder.add(((DefaultCompassQuery.DefaultCompassSpanQuey)query).getSearchEngineSpanQuery());
            return this;
        }

        public CompassQuery.CompassSpanQuery toQuery() {
            SearchEngineQuery.SearchEngineSpanQuery query = this.queryBuilder.toQuery();
            return new DefaultCompassQuery.DefaultCompassSpanQuey(query, this.session);
        }
    }

    public static class DefaultCompassQuerySpanNearBuilder
    implements CompassQueryBuilder.CompassQuerySpanNearBuilder {
        private SearchEngineQueryBuilder.SearchEngineQuerySpanNearBuilder queryBuilder;
        private InternalCompassSession session;
        private CompassMapping.ResourcePropertyLookup lookup;

        public DefaultCompassQuerySpanNearBuilder(SearchEngineQueryBuilder.SearchEngineQuerySpanNearBuilder queryBuilder, InternalCompassSession session, CompassMapping.ResourcePropertyLookup lookup) {
            this.queryBuilder = queryBuilder;
            this.session = session;
            this.lookup = lookup;
        }

        public CompassQueryBuilder.CompassQuerySpanNearBuilder setSlop(int slop) {
            this.queryBuilder.setSlop(slop);
            return this;
        }

        public CompassQueryBuilder.CompassQuerySpanNearBuilder setInOrder(boolean inOrder) {
            this.queryBuilder.setInOrder(inOrder);
            return this;
        }

        public CompassQueryBuilder.CompassQuerySpanNearBuilder add(Object value) {
            this.queryBuilder.add(this.lookup.getValue(value));
            return this;
        }

        public CompassQueryBuilder.CompassQuerySpanNearBuilder add(CompassQuery.CompassSpanQuery query) {
            this.queryBuilder.add(((DefaultCompassQuery.DefaultCompassSpanQuey)query).getSearchEngineSpanQuery());
            return this;
        }

        public CompassQuery.CompassSpanQuery toQuery() {
            SearchEngineQuery.SearchEngineSpanQuery query = this.queryBuilder.toQuery();
            return new DefaultCompassQuery.DefaultCompassSpanQuey(query, this.session);
        }
    }

    public static class DefaultCompassMultiPropertyQueryStringBuilder
    implements CompassQueryBuilder.CompassMultiPropertyQueryStringBuilder {
        private SearchEngineQueryBuilder.SearchEngineMultiPropertyQueryStringBuilder queryBuilder;
        private InternalCompassSession session;

        public DefaultCompassMultiPropertyQueryStringBuilder(SearchEngineQueryBuilder.SearchEngineMultiPropertyQueryStringBuilder queryBuilder, InternalCompassSession session) {
            this.queryBuilder = queryBuilder;
            this.session = session;
        }

        public CompassQueryBuilder.CompassMultiPropertyQueryStringBuilder setAnalyzer(String analyzer) throws CompassException {
            this.queryBuilder.setAnalyzer(analyzer);
            return this;
        }

        public CompassQueryBuilder.CompassMultiPropertyQueryStringBuilder setAnalyzerByAlias(String alias) throws CompassException {
            this.queryBuilder.setAnalyzerByAlias(alias);
            return this;
        }

        public CompassQueryBuilder.CompassMultiPropertyQueryStringBuilder add(String name) {
            this.queryBuilder.add(this.session.getMapping().getResourcePropertyLookup(name).getPath());
            return this;
        }

        public CompassQueryBuilder.CompassMultiPropertyQueryStringBuilder useAndDefaultOperator() {
            this.queryBuilder.useAndDefaultOperator();
            return this;
        }

        public CompassQuery toQuery() {
            SearchEngineQuery query = this.queryBuilder.toQuery();
            return new DefaultCompassQuery(query, this.session);
        }
    }

    public static class DefaultCompassQueryStringBuilder
    implements CompassQueryBuilder.CompassQueryStringBuilder {
        private SearchEngineQueryBuilder.SearchEngineQueryStringBuilder queryBuilder;
        private InternalCompassSession session;

        public DefaultCompassQueryStringBuilder(SearchEngineQueryBuilder.SearchEngineQueryStringBuilder queryBuilder, InternalCompassSession session) {
            this.queryBuilder = queryBuilder;
            this.session = session;
        }

        public CompassQueryBuilder.CompassQueryStringBuilder setAnalyzer(String analyzer) throws CompassException {
            this.queryBuilder.setAnalyzer(analyzer);
            return this;
        }

        public CompassQueryBuilder.CompassQueryStringBuilder setAnalyzerByAlias(String alias) throws CompassException {
            this.queryBuilder.setAnalyzerByAlias(alias);
            return this;
        }

        public CompassQueryBuilder.CompassQueryStringBuilder setDefaultSearchProperty(String defaultSearchProperty) {
            this.queryBuilder.setDefaultSearchProperty(defaultSearchProperty);
            return this;
        }

        public CompassQueryBuilder.CompassQueryStringBuilder useAndDefaultOperator() {
            this.queryBuilder.useAndDefaultOperator();
            return this;
        }

        public CompassQuery toQuery() {
            SearchEngineQuery query = this.queryBuilder.toQuery();
            return new DefaultCompassQuery(query, this.session);
        }
    }

    public static class DefaultCompassMultiPhraseQueryBuilder
    implements CompassQueryBuilder.CompassMultiPhraseQueryBuilder {
        private SearchEngineQueryBuilder.SearchEngineMultiPhraseQueryBuilder queryBuilder;
        private InternalCompassSession session;
        private CompassMapping.ResourcePropertyLookup lookup;

        public DefaultCompassMultiPhraseQueryBuilder(SearchEngineQueryBuilder.SearchEngineMultiPhraseQueryBuilder queryBuilder, InternalCompassSession session, CompassMapping.ResourcePropertyLookup lookup) {
            this.queryBuilder = queryBuilder;
            this.session = session;
            this.lookup = lookup;
        }

        public CompassQueryBuilder.CompassMultiPhraseQueryBuilder setSlop(int slop) {
            this.queryBuilder.setSlop(slop);
            return this;
        }

        public CompassQueryBuilder.CompassMultiPhraseQueryBuilder add(Object value) {
            this.queryBuilder.add(this.lookup.getValue(value));
            return this;
        }

        public CompassQueryBuilder.CompassMultiPhraseQueryBuilder add(Object value, int position) {
            this.queryBuilder.add(this.lookup.getValue(value), position);
            return this;
        }

        public CompassQueryBuilder.CompassMultiPhraseQueryBuilder add(Object[] values) {
            String[] strValues = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                strValues[i] = this.lookup.getValue(values[i]);
            }
            this.queryBuilder.add(strValues);
            return this;
        }

        public CompassQueryBuilder.CompassMultiPhraseQueryBuilder add(Object[] values, int position) {
            String[] strValues = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                strValues[i] = this.lookup.getValue(values[i]);
            }
            this.queryBuilder.add(strValues, position);
            return this;
        }

        public CompassQuery toQuery() {
            SearchEngineQuery query = this.queryBuilder.toQuery();
            return new DefaultCompassQuery(query, this.session);
        }
    }

    public static class DefaultCompassBooleanQueryBuilder
    implements CompassQueryBuilder.CompassBooleanQueryBuilder {
        private SearchEngineQueryBuilder.SearchEngineBooleanQueryBuilder queryBuilder;
        private InternalCompassSession session;

        public DefaultCompassBooleanQueryBuilder(SearchEngineQueryBuilder.SearchEngineBooleanQueryBuilder queryBuilder, InternalCompassSession session) {
            this.queryBuilder = queryBuilder;
            this.session = session;
        }

        public CompassQueryBuilder.CompassBooleanQueryBuilder addMust(CompassQuery query) {
            this.queryBuilder.addMust(((DefaultCompassQuery)query).getSearchEngineQuery());
            return this;
        }

        public CompassQueryBuilder.CompassBooleanQueryBuilder addMustNot(CompassQuery query) {
            this.queryBuilder.addMustNot(((DefaultCompassQuery)query).getSearchEngineQuery());
            return this;
        }

        public CompassQueryBuilder.CompassBooleanQueryBuilder addShould(CompassQuery query) {
            this.queryBuilder.addShould(((DefaultCompassQuery)query).getSearchEngineQuery());
            return this;
        }

        public CompassQuery toQuery() {
            SearchEngineQuery query = this.queryBuilder.toQuery();
            return new DefaultCompassQuery(query, this.session);
        }
    }
}

