/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.impl;

import org.compass.core.CompassQuery;
import org.compass.core.CompassQueryFilter;
import org.compass.core.CompassQueryFilterBuilder;
import org.compass.core.engine.SearchEngineQueryFilterBuilder;
import org.compass.core.impl.DefaultCompassQuery;
import org.compass.core.impl.DefaultCompassQueryFilter;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.spi.InternalCompassSession;

public class DefaultCompassQueryFilterBuilder
implements CompassQueryFilterBuilder {
    private InternalCompassSession session;
    private SearchEngineQueryFilterBuilder filterBuilder;

    public DefaultCompassQueryFilterBuilder(SearchEngineQueryFilterBuilder filterBuilder, InternalCompassSession session) {
        this.filterBuilder = filterBuilder;
        this.session = session;
    }

    public CompassQueryFilter between(String name, Object low, Object high, boolean includeLow, boolean includeHigh) {
        CompassMapping.ResourcePropertyLookup lookup = this.session.getMapping().getResourcePropertyLookup(name);
        return new DefaultCompassQueryFilter(this.filterBuilder.between(lookup.getPath(), lookup.getValue(low), lookup.getValue(high), includeLow, includeHigh));
    }

    public CompassQueryFilter lt(String name, Object value) {
        CompassMapping.ResourcePropertyLookup lookup = this.session.getMapping().getResourcePropertyLookup(name);
        return new DefaultCompassQueryFilter(this.filterBuilder.lt(lookup.getPath(), lookup.getValue(value)));
    }

    public CompassQueryFilter le(String name, Object value) {
        CompassMapping.ResourcePropertyLookup lookup = this.session.getMapping().getResourcePropertyLookup(name);
        return new DefaultCompassQueryFilter(this.filterBuilder.le(lookup.getPath(), lookup.getValue(value)));
    }

    public CompassQueryFilter gt(String name, Object value) {
        CompassMapping.ResourcePropertyLookup lookup = this.session.getMapping().getResourcePropertyLookup(name);
        return new DefaultCompassQueryFilter(this.filterBuilder.gt(lookup.getPath(), lookup.getValue(value)));
    }

    public CompassQueryFilter ge(String name, Object value) {
        CompassMapping.ResourcePropertyLookup lookup = this.session.getMapping().getResourcePropertyLookup(name);
        return new DefaultCompassQueryFilter(this.filterBuilder.ge(lookup.getPath(), lookup.getValue(value)));
    }

    public CompassQueryFilter query(CompassQuery query) {
        return new DefaultCompassQueryFilter(this.filterBuilder.query(((DefaultCompassQuery)query).getSearchEngineQuery()));
    }

    public CompassQueryFilterBuilder.CompassBooleanQueryFilterBuilder bool() {
        return new DefaultCompassBooleanQueryFilterBuilder(this.filterBuilder.bool());
    }

    public static class DefaultCompassBooleanQueryFilterBuilder
    implements CompassQueryFilterBuilder.CompassBooleanQueryFilterBuilder {
        private SearchEngineQueryFilterBuilder.SearchEngineBooleanQueryFilterBuilder filterBuilder;

        public DefaultCompassBooleanQueryFilterBuilder(SearchEngineQueryFilterBuilder.SearchEngineBooleanQueryFilterBuilder filterBuilder) {
            this.filterBuilder = filterBuilder;
        }

        public CompassQueryFilterBuilder.CompassBooleanQueryFilterBuilder and(CompassQueryFilter filter) {
            this.filterBuilder.and(((DefaultCompassQueryFilter)filter).getFilter());
            return this;
        }

        public CompassQueryFilterBuilder.CompassBooleanQueryFilterBuilder or(CompassQueryFilter filter) {
            this.filterBuilder.or(((DefaultCompassQueryFilter)filter).getFilter());
            return this;
        }

        public CompassQueryFilterBuilder.CompassBooleanQueryFilterBuilder andNot(CompassQueryFilter filter) {
            this.filterBuilder.andNot(((DefaultCompassQueryFilter)filter).getFilter());
            return this;
        }

        public CompassQueryFilterBuilder.CompassBooleanQueryFilterBuilder xor(CompassQueryFilter filter) {
            this.filterBuilder.xor(((DefaultCompassQueryFilter)filter).getFilter());
            return this;
        }

        public CompassQueryFilter toFilter() {
            return new DefaultCompassQueryFilter(this.filterBuilder.toFilter());
        }
    }
}

