/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.impl;

import org.compass.core.Property;
import org.compass.core.Resource;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.util.ResourceHelper;

public final class ResourceIdKey {
    private String alias;
    private Object[] values;
    private int hashCode = Integer.MIN_VALUE;

    public ResourceIdKey(CompassMapping compassMapping, Resource idResource) {
        this(idResource.getAlias(), ResourceHelper.toIds(idResource.getAlias(), idResource, compassMapping));
    }

    public ResourceIdKey(ResourceMapping resourceMapping, Object[] values) {
        this(resourceMapping.getAlias(), values);
    }

    public ResourceIdKey(String alias, Property[] ids) {
        this.values = new Object[ids.length];
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = ids[i].getStringValue();
        }
        this.alias = alias;
    }

    public ResourceIdKey(String alias, Object[] values) {
        this.alias = alias;
        this.values = values;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        ResourceIdKey idKey = (ResourceIdKey)other;
        if (!idKey.getAlias().equals(this.alias)) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (idKey.getValues()[i].equals(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hashCode == Integer.MIN_VALUE) {
            this.hashCode = this.getHashCode();
        }
        return this.hashCode;
    }

    public String getAlias() {
        return this.alias;
    }

    public Object[] getValues() {
        return this.values;
    }

    private int getHashCode() {
        int result = this.alias.hashCode();
        for (int i = 0; i < this.values.length; ++i) {
            result = 29 * result + this.values[i].hashCode();
        }
        return result;
    }
}

