/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene;

import java.io.Reader;
import java.util.ArrayList;
import org.compass.core.Property;
import org.compass.core.Resource;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.lucene.LuceneResource;
import org.compass.core.lucene.engine.LuceneSearchEngine;
import org.compass.core.spi.MultiResource;

public class LuceneMultiResource
implements MultiResource {
    private Resource currentResource;
    private int currentResourceIndex = -1;
    private ArrayList resources = new ArrayList();
    private String alias;
    private transient LuceneSearchEngine searchEngine;

    public LuceneMultiResource(String alias, LuceneSearchEngine searchEngine) {
        this.alias = alias;
        this.searchEngine = searchEngine;
        this.currentResource = new LuceneResource(alias, searchEngine);
        this.currentResourceIndex = 0;
        this.resources.add(this.currentResource);
    }

    public int size() {
        return this.resources.size();
    }

    public Resource currentResource() {
        return this.currentResource;
    }

    public void addResource() {
        this.currentResource = new LuceneResource(this.alias, this.searchEngine);
        this.resources.add(this.currentResource);
        ++this.currentResourceIndex;
    }

    public Resource resource(int i) {
        return (Resource)this.resources.get(i);
    }

    public void clear() {
        this.resources.clear();
        this.currentResource = null;
        this.currentResourceIndex = -1;
    }

    public String getAlias() {
        return this.currentResource.getAlias();
    }

    public Resource setAlias(String alias) {
        this.currentResource.setAlias(alias);
        return this;
    }

    public String get(String name) {
        return this.currentResource.get(name);
    }

    public String[] getValues(String name) {
        return this.currentResource.getValues(name);
    }

    public Resource addProperty(String name, Object value) throws SearchEngineException {
        this.currentResource.addProperty(name, value);
        return this;
    }

    public Resource addProperty(String name, Reader value) throws SearchEngineException {
        this.currentResource.addProperty(name, value);
        return this;
    }

    public Resource addProperty(Property property) {
        this.currentResource.addProperty(property);
        return this;
    }

    public Resource removeProperty(String name) {
        this.currentResource.removeProperty(name);
        return this;
    }

    public Resource removeProperties(String name) {
        this.currentResource.removeProperties(name);
        return this;
    }

    public Property getProperty(String name) {
        return this.currentResource.getProperty(name);
    }

    public Property[] getProperties(String name) {
        return this.currentResource.getProperties(name);
    }

    public Property[] getProperties() {
        return this.currentResource.getProperties();
    }

    public float getBoost() {
        return this.currentResource.getBoost();
    }

    public Resource setBoost(float boost) {
        this.currentResource.setBoost(boost);
        return this;
    }

    public void copy(Resource resource) {
        this.clear();
        if (resource instanceof MultiResource) {
            MultiResource multiResource = (MultiResource)resource;
            for (int i = 0; i < multiResource.size(); ++i) {
                this.addResource();
                this.currentResource.copy(multiResource.resource(i));
            }
        } else {
            this.currentResource = resource;
            this.currentResourceIndex = 0;
            this.resources.add(resource);
        }
    }
}

