/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene;

import org.apache.lucene.document.Field;
import org.compass.core.Property;
import org.compass.core.engine.RepeatableReader;

public class LuceneProperty
implements Property {
    private static final long serialVersionUID = 3690475809949104182L;
    private Field field;
    private RepeatableReader reader;

    public LuceneProperty(Field field) {
        this.field = field;
    }

    public LuceneProperty(Field field, RepeatableReader reader) {
        this.field = field;
        this.reader = reader;
    }

    public RepeatableReader getRepeatableReader() {
        return this.reader;
    }

    public Field getField() {
        return this.field;
    }

    public String getName() {
        return this.field.name();
    }

    public String getStringValue() {
        return this.field.stringValue();
    }

    public byte[] getBinaryValue() {
        return this.field.binaryValue();
    }

    public float getBoost() {
        return this.field.getBoost();
    }

    public void setBoost(float boost) {
        this.field.setBoost(boost);
    }

    public boolean isIndexed() {
        return this.field.isIndexed();
    }

    public boolean isStored() {
        return this.field.isStored();
    }

    public boolean isCompressed() {
        return this.field.isCompressed();
    }

    public boolean isBinary() {
        return this.field.isBinary();
    }

    public boolean isTokenized() {
        return this.field.isTokenized();
    }

    public boolean isTermVectorStored() {
        return this.field.isTermVectorStored();
    }

    public boolean isStoreOffsetWithTermVector() {
        return this.field.isStoreOffsetWithTermVector();
    }

    public boolean isStorePositionWithTermVector() {
        return this.field.isStorePositionWithTermVector();
    }

    public String toString() {
        return "[" + this.getName() + "," + this.getStringValue() + "]";
    }
}

