/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene;

import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.compass.core.Property;
import org.compass.core.Resource;
import org.compass.core.converter.ResourcePropertyConverter;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.lucene.LuceneProperty;
import org.compass.core.lucene.engine.LuceneSearchEngine;
import org.compass.core.lucene.util.LuceneUtils;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.mapping.ResourcePropertyMapping;
import org.compass.core.spi.AliasedObject;
import org.compass.core.util.StringUtils;

public class LuceneResource
implements AliasedObject,
Resource,
Map {
    private static final long serialVersionUID = 3904681565727306034L;
    private Document document;
    private ArrayList properties = new ArrayList();
    private String aliasProperty;
    private int docNum;
    private transient LuceneSearchEngine searchEngine;
    private transient ResourceMapping resourceMapping;

    public LuceneResource(String alias, LuceneSearchEngine searchEngine) {
        this(new Document(), -1, searchEngine);
        this.setAlias(alias);
    }

    public LuceneResource(Document document, int docNum, LuceneSearchEngine searchEngine) {
        this.document = document;
        this.searchEngine = searchEngine;
        this.aliasProperty = searchEngine.getSearchEngineFactory().getLuceneSettings().getAliasProperty();
        Enumeration fields = document.fields();
        while (fields.hasMoreElements()) {
            Field field = (Field)fields.nextElement();
            LuceneProperty lProperty = new LuceneProperty(field);
            this.properties.add(lProperty);
        }
        this.docNum = docNum;
    }

    public void copy(Resource resource) {
        LuceneResource luceneResource = (LuceneResource)resource;
        this.document = luceneResource.document;
        this.docNum = luceneResource.docNum;
        this.properties = luceneResource.properties;
        this.aliasProperty = luceneResource.aliasProperty;
        this.searchEngine = luceneResource.searchEngine;
        this.resourceMapping = luceneResource.resourceMapping;
    }

    public Document getDocument() {
        return this.document;
    }

    public String get(String name) {
        return this.document.get(name);
    }

    public String[] getValues(String name) {
        return this.document.getValues(name);
    }

    public String getAlias() {
        Property alias = this.getProperty(this.aliasProperty);
        if (alias == null) {
            return null;
        }
        return alias.getStringValue();
    }

    public Resource setAlias(String alias) {
        this.removeProperties(this.aliasProperty);
        LuceneProperty aliasProp = new LuceneProperty(new Field(this.aliasProperty, alias, Field.Store.YES, Field.Index.UN_TOKENIZED));
        this.addProperty(aliasProp);
        return this;
    }

    public Resource addProperty(String name, Object value) throws SearchEngineException {
        String alias = this.getAlias();
        this.verifyRawResourceMapping();
        ResourcePropertyMapping propertyMapping = this.resourceMapping.getResourcePropertyMapping(name);
        if (propertyMapping == null) {
            throw new SearchEngineException("No resource property mapping is defined for alias [" + alias + "] and resource property [" + name + "]");
        }
        ResourcePropertyConverter converter = (ResourcePropertyConverter)propertyMapping.getConverter();
        if (converter == null) {
            converter = (ResourcePropertyConverter)this.searchEngine.getSearchEngineFactory().getMapping().getConverterLookup().lookupConverter(value.getClass());
        }
        String strValue = converter.toString(value, propertyMapping);
        Property property = this.searchEngine.createProperty(strValue, propertyMapping);
        property.setBoost(propertyMapping.getBoost());
        return this.addProperty(property);
    }

    public Resource addProperty(String name, Reader value) throws SearchEngineException {
        String alias = this.getAlias();
        this.verifyRawResourceMapping();
        ResourcePropertyMapping propertyMapping = this.resourceMapping.getResourcePropertyMapping(name);
        if (propertyMapping == null) {
            throw new SearchEngineException("No resource property mapping is defined for alias [" + alias + "] and resource property [" + name + "]");
        }
        Field.TermVector fieldTermVector = LuceneUtils.getFieldTermVector(propertyMapping.getTermVector());
        Field field = new Field(name, value, fieldTermVector);
        LuceneProperty property = new LuceneProperty(field);
        property.setBoost(propertyMapping.getBoost());
        return this.addProperty(property);
    }

    public Resource addProperty(Property property) {
        LuceneProperty lProperty = (LuceneProperty)property;
        this.properties.add(property);
        this.document.add(lProperty.getField());
        return this;
    }

    public Resource removeProperty(String name) {
        this.document.removeField(name);
        Iterator it = this.properties.iterator();
        while (it.hasNext()) {
            Property property = (Property)it.next();
            if (!property.getName().equals(name)) continue;
            it.remove();
            return this;
        }
        return this;
    }

    public Resource removeProperties(String name) {
        this.document.removeFields(name);
        Iterator it = this.properties.iterator();
        while (it.hasNext()) {
            Property property = (Property)it.next();
            if (!property.getName().equals(name)) continue;
            it.remove();
        }
        return this;
    }

    public Property getProperty(String name) {
        for (int i = 0; i < this.properties.size(); ++i) {
            Property property = (Property)this.properties.get(i);
            if (!property.getName().equals(name)) continue;
            return property;
        }
        return null;
    }

    public Property[] getProperties(String name) {
        ArrayList<Property> result = new ArrayList<Property>();
        for (int i = 0; i < this.properties.size(); ++i) {
            Property property = (Property)this.properties.get(i);
            if (!property.getName().equals(name)) continue;
            result.add(property);
        }
        if (result.size() == 0) {
            return new Property[0];
        }
        return result.toArray(new Property[result.size()]);
    }

    public Property[] getProperties() {
        return this.properties.toArray(new LuceneProperty[this.properties.size()]);
    }

    public float getBoost() {
        return this.document.getBoost();
    }

    public Resource setBoost(float boost) {
        this.document.setBoost(boost);
        return this;
    }

    public void setDocNum(int docNum) {
        this.docNum = docNum;
    }

    public int getDocNum() {
        return this.docNum;
    }

    private void verifyRawResourceMapping() throws SearchEngineException {
        String alias = this.getAlias();
        if (this.resourceMapping == null) {
            if (alias == null) {
                throw new SearchEngineException("Can't add a resource property based on resource mapping without an alias associated with the resource first");
            }
            if (!this.searchEngine.getSearchEngineFactory().getMapping().hasRootMappingByAlias(alias)) {
                throw new SearchEngineException("No mapping is defined for alias [" + alias + "]");
            }
            this.resourceMapping = this.searchEngine.getSearchEngineFactory().getMapping().getRootMappingByAlias(alias);
        }
    }

    public String toString() {
        return "{" + this.getAlias() + "} " + StringUtils.arrayToCommaDelimitedString(this.getProperties());
    }

    public void clear() {
        throw new UnsupportedOperationException("Map operations are supported for read operations only");
    }

    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException("Map operations are supported for read operations only");
    }

    public Set entrySet() {
        throw new UnsupportedOperationException("Map operations are supported for read operations only");
    }

    public void putAll(Map t) {
        throw new UnsupportedOperationException("Map operations are supported for read operations only");
    }

    public Set keySet() {
        throw new UnsupportedOperationException("Map operations are supported for read operations only");
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException("Map operations are supported for read operations only");
    }

    public Object put(Object key, Object value) {
        throw new UnsupportedOperationException("Map operations are supported for read operations only");
    }

    public boolean containsKey(Object key) {
        return this.getProperty(key.toString()) != null;
    }

    public int size() {
        return this.properties.size();
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public Collection values() {
        return this.properties;
    }

    public Object get(Object key) {
        return this.getProperties(key.toString());
    }
}

