/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene;

import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermPositionVector;
import org.apache.lucene.index.TermVectorOffsetInfo;
import org.compass.core.CompassTermInfoVector;

public class LuceneTermInfoVector
implements CompassTermInfoVector {
    private TermFreqVector termFreqVector;

    public LuceneTermInfoVector(TermFreqVector termFreqVector) {
        this.termFreqVector = termFreqVector;
    }

    public String getProperty() {
        return this.termFreqVector.getField();
    }

    public int size() {
        return this.termFreqVector.size();
    }

    public String[] getTerms() {
        return this.termFreqVector.getTerms();
    }

    public int[] getTermFrequencies() {
        return this.termFreqVector.getTermFrequencies();
    }

    public int indexOf(String term) {
        return this.termFreqVector.indexOf(term);
    }

    public int[] indexesOf(String[] terms, int start, int len) {
        return this.termFreqVector.indexesOf(terms, start, len);
    }

    public int[] getTermPositions(int index) {
        return ((TermPositionVector)this.termFreqVector).getTermPositions(index);
    }

    public CompassTermInfoVector.OffsetInfo[] getOffsets(int index) {
        TermVectorOffsetInfo[] infos = ((TermPositionVector)this.termFreqVector).getOffsets(index);
        if (infos == null) {
            return null;
        }
        CompassTermInfoVector.OffsetInfo[] luceneInfos = new LuceneOffsetInfo[infos.length];
        for (int i = 0; i < infos.length; ++i) {
            luceneInfos[i] = new LuceneOffsetInfo(infos[i]);
        }
        return luceneInfos;
    }

    public TermFreqVector getTermFreqVector() {
        return this.termFreqVector;
    }

    public class LuceneOffsetInfo
    implements CompassTermInfoVector.OffsetInfo {
        private TermVectorOffsetInfo offsetInfo;

        public LuceneOffsetInfo(TermVectorOffsetInfo offsetInfo) {
            this.offsetInfo = offsetInfo;
        }

        public int getEndOffset() {
            return this.offsetInfo.getEndOffset();
        }

        public int getStartOffset() {
            return this.offsetInfo.getStartOffset();
        }

        public boolean equals(Object o) {
            return this.offsetInfo.equals(o);
        }

        public int hashCode() {
            return this.offsetInfo.hashCode();
        }
    }
}

