/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine;

import java.io.Reader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.document.Field;
import org.compass.core.CompassTermInfoVector;
import org.compass.core.CompassTransaction;
import org.compass.core.Property;
import org.compass.core.Resource;
import org.compass.core.engine.RepeatableReader;
import org.compass.core.engine.SearchEngine;
import org.compass.core.engine.SearchEngineAnalyzerHelper;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.engine.SearchEngineHighlighter;
import org.compass.core.engine.SearchEngineHits;
import org.compass.core.engine.SearchEngineQuery;
import org.compass.core.engine.SearchEngineQueryBuilder;
import org.compass.core.engine.SearchEngineQueryFilterBuilder;
import org.compass.core.engine.event.SearchEngineEventManager;
import org.compass.core.lucene.LuceneMultiResource;
import org.compass.core.lucene.LuceneProperty;
import org.compass.core.lucene.LuceneResource;
import org.compass.core.lucene.engine.LuceneSearchEngineAnalyzerHelper;
import org.compass.core.lucene.engine.LuceneSearchEngineFactory;
import org.compass.core.lucene.engine.query.LuceneSearchEngineQueryBuilder;
import org.compass.core.lucene.engine.query.LuceneSearchEngineQueryFilterBuilder;
import org.compass.core.lucene.engine.transaction.BatchInsertTransaction;
import org.compass.core.lucene.engine.transaction.LuceneSearchEngineTransaction;
import org.compass.core.lucene.engine.transaction.ReadCommittedTransaction;
import org.compass.core.lucene.engine.transaction.SerialableTransaction;
import org.compass.core.lucene.util.LuceneUtils;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.mapping.ResourcePropertyMapping;
import org.compass.core.spi.MultiResource;
import org.compass.core.util.ResourceHelper;
import org.compass.core.util.StringUtils;
import org.compass.core.util.reader.ReverseStringReader;

public class LuceneSearchEngine
implements SearchEngine {
    protected static final Log log = LogFactory.getLog((Class)LuceneSearchEngine.class);
    private static final int UNKNOWN = -1;
    private static final int STARTED = 0;
    private static final int COMMIT = 1;
    private static final int ROLLBACK = 2;
    private int transactionState;
    private LuceneSearchEngineTransaction transaction;
    private LuceneSearchEngineFactory searchEngineFactory;
    private SearchEngineEventManager eventManager = new SearchEngineEventManager();

    public LuceneSearchEngine(LuceneSearchEngineFactory searchEngineFactory) {
        this.searchEngineFactory = searchEngineFactory;
        this.transactionState = -1;
        this.eventManager.registerLifecycleListener(searchEngineFactory.getEventManager());
        searchEngineFactory.getLuceneIndexManager().getStore().registerEventListeners(this, this.eventManager);
    }

    public String getNullValue() {
        return "";
    }

    public boolean isNullValue(String value) {
        if (value == null) {
            return true;
        }
        return value.length() == 0;
    }

    public Resource createResource(String alias) throws SearchEngineException {
        return new LuceneMultiResource(alias, this);
    }

    public Property createProperty(String value, ResourcePropertyMapping mapping) throws SearchEngineException {
        return this.createProperty(mapping.getPath().getPath(), value, mapping);
    }

    public Property createProperty(String name, String value, ResourcePropertyMapping mapping) throws SearchEngineException {
        Property property = null;
        if (mapping.getReverse() == ResourcePropertyMapping.ReverseType.NO) {
            property = this.createProperty(name, value, mapping.getStore(), mapping.getIndex(), mapping.getTermVector());
        } else if (mapping.getReverse() == ResourcePropertyMapping.ReverseType.READER) {
            property = this.createProperty(name, new ReverseStringReader(value), mapping.getTermVector());
        } else if (mapping.getReverse() == ResourcePropertyMapping.ReverseType.STRING) {
            property = this.createProperty(name, StringUtils.reverse(value), mapping.getStore(), mapping.getIndex(), mapping.getTermVector());
        }
        property.setBoost(mapping.getBoost());
        return property;
    }

    public Property createProperty(String name, String value, Property.Store store, Property.Index index) throws SearchEngineException {
        return this.createProperty(name, value, store, index, Property.TermVector.NO);
    }

    public Property createProperty(String name, String value, Property.Store store, Property.Index index, Property.TermVector termVector) throws SearchEngineException {
        Field.Store fieldStore = LuceneUtils.getFieldStore(store);
        Field.Index fieldIndex = LuceneUtils.getFieldIndex(index);
        Field.TermVector fieldTermVector = LuceneUtils.getFieldTermVector(termVector);
        Field field = new Field(name, value, fieldStore, fieldIndex, fieldTermVector);
        return new LuceneProperty(field);
    }

    public Property createProperty(String name, Reader value) {
        return this.createProperty(name, value, Property.TermVector.NO);
    }

    public Property createProperty(String name, byte[] value, Property.Store store) throws SearchEngineException {
        Field.Store fieldStore = LuceneUtils.getFieldStore(store);
        Field field = new Field(name, value, fieldStore);
        return new LuceneProperty(field);
    }

    public Property createProperty(String name, Reader value, Property.TermVector termVector) {
        Field.TermVector fieldTermVector = LuceneUtils.getFieldTermVector(termVector);
        Field field = new Field(name, value, fieldTermVector);
        if (value instanceof RepeatableReader) {
            return new LuceneProperty(field, (RepeatableReader)((Object)value));
        }
        return new LuceneProperty(field);
    }

    public SearchEngineQueryBuilder queryBuilder() throws SearchEngineException {
        return new LuceneSearchEngineQueryBuilder(this);
    }

    public SearchEngineQueryFilterBuilder queryFilterBuilder() throws SearchEngineException {
        return new LuceneSearchEngineQueryFilterBuilder();
    }

    public SearchEngineAnalyzerHelper analyzerHelper() {
        return new LuceneSearchEngineAnalyzerHelper(this);
    }

    public void begin() throws SearchEngineException {
        if (this.transactionState == 0) {
            throw new SearchEngineException("Transaction already started, why start it again?");
        }
        Class transactionIsolationClass = this.searchEngineFactory.getLuceneSettings().getTransactionIsolationClass();
        if (transactionIsolationClass != null) {
            try {
                this.transaction = (LuceneSearchEngineTransaction)transactionIsolationClass.newInstance();
            }
            catch (Exception e) {
                throw new SearchEngineException("Failed to create an instance for transaction [" + transactionIsolationClass.getName() + "]", e);
            }
            this.transaction.configure(this);
            this.eventManager.beforeBeginTransaction();
            this.transaction.begin();
            this.eventManager.afterBeginTransaction();
            this.transactionState = 0;
            return;
        }
        CompassTransaction.TransactionIsolation transactionIsolation = this.searchEngineFactory.getLuceneSettings().getTransactionIsolation();
        this.begin(transactionIsolation);
    }

    public void begin(CompassTransaction.TransactionIsolation transactionIsolation) throws SearchEngineException {
        if (transactionIsolation == null) {
            transactionIsolation = this.searchEngineFactory.getLuceneSettings().getTransactionIsolation();
        }
        if (transactionIsolation == CompassTransaction.TransactionIsolation.READ_COMMITTED) {
            this.transaction = new ReadCommittedTransaction();
        } else if (transactionIsolation == CompassTransaction.TransactionIsolation.READ_ONLY_READ_COMMITTED) {
            this.transaction = new ReadCommittedTransaction();
        } else if (transactionIsolation == CompassTransaction.TransactionIsolation.BATCH_INSERT) {
            this.transaction = new BatchInsertTransaction();
        } else if (transactionIsolation == CompassTransaction.TransactionIsolation.SERIALIZABLE) {
            this.transaction = new SerialableTransaction();
        }
        this.transaction.configure(this);
        this.eventManager.beforeBeginTransaction();
        this.transaction.begin();
        this.eventManager.afterBeginTransaction();
        this.transactionState = 0;
    }

    private void checkTransactionStarted() throws SearchEngineException {
        if (this.transactionState == -1) {
            throw new SearchEngineException("Search engine transaction not successfully started");
        }
    }

    public void prepare() throws SearchEngineException {
        this.checkTransactionStarted();
        if (this.transaction != null) {
            this.transaction.prepare();
        }
        this.eventManager.afterPrepare();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(boolean onePhase) throws SearchEngineException {
        this.checkTransactionStarted();
        try {
            if (this.transaction != null) {
                this.transaction.commit(onePhase);
                this.eventManager.afterCommit(onePhase);
            }
        }
        finally {
            this.transaction = null;
            this.transactionState = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws SearchEngineException {
        this.checkTransactionStarted();
        try {
            if (this.transaction != null) {
                this.transaction.rollback();
                this.eventManager.afterRollback();
            }
        }
        finally {
            this.transaction = null;
            this.transactionState = 2;
        }
    }

    public void flush() throws SearchEngineException {
        this.checkTransactionStarted();
        if (this.transaction != null) {
            this.transaction.flush();
        }
    }

    public boolean wasRolledBack() throws SearchEngineException {
        return this.transactionState == 2;
    }

    public boolean wasCommitted() throws SearchEngineException {
        return this.transactionState == 1;
    }

    public void close() throws SearchEngineException {
        this.eventManager.close();
        if (this.transactionState == 0) {
            log.warn((Object)"Transaction not committed/rolled backed, rolling back");
            try {
                this.rollback();
            }
            catch (Exception e) {
                log.warn((Object)"Failed to rollback transcation, ignoring", (Throwable)e);
            }
        }
        this.eventManager = null;
    }

    public void delete(String[] ids, String alias) throws SearchEngineException {
        ResourceMapping resourceMapping = this.searchEngineFactory.getMapping().getRootMappingByAlias(alias);
        this.delete(ResourceHelper.toIds(this, ids, resourceMapping), alias);
    }

    public void delete(Resource resource) throws SearchEngineException {
        if (resource instanceof MultiResource) {
            MultiResource multiResource = (MultiResource)resource;
            for (int i = 0; i < multiResource.size(); ++i) {
                this.delete(ResourceHelper.toIds(resource.getAlias(), multiResource.resource(i), this.searchEngineFactory.getMapping()), resource.getAlias());
            }
        } else {
            this.delete(ResourceHelper.toIds(resource.getAlias(), resource, this.searchEngineFactory.getMapping()), resource.getAlias());
        }
    }

    public void delete(Property[] ids, String alias) throws SearchEngineException {
        this.checkTransactionStarted();
        if (ids.length == 0) {
            throw new SearchEngineException("Cannot delete a resource with no ids");
        }
        this.transaction.delete(ids, alias);
        if (log.isDebugEnabled()) {
            log.debug((Object)("RESOURCE DELETE {" + alias + "} " + StringUtils.arrayToCommaDelimitedString(ids)));
        }
    }

    public void create(Resource resource) throws SearchEngineException {
        this.checkTransactionStarted();
        String alias = resource.getAlias();
        ResourceMapping resourceMapping = this.searchEngineFactory.getMapping().getRootMappingByAlias(alias);
        if (resourceMapping == null) {
            throw new SearchEngineException("Failed to find mapping for alias [" + alias + "]");
        }
        if (resource instanceof MultiResource) {
            MultiResource multiResource = (MultiResource)resource;
            for (int i = 0; i < multiResource.size(); ++i) {
                Resource resource1 = multiResource.resource(i);
                LuceneUtils.addAllPropertyIfNeeded(resource1, resourceMapping, this);
                this.transaction.create(resource1);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("RESOURCE CREATE " + resource1));
            }
        } else {
            LuceneUtils.addAllPropertyIfNeeded(resource, resourceMapping, this);
            this.transaction.create(resource);
            if (log.isDebugEnabled()) {
                log.debug((Object)("RESOURCE CREATE " + resource));
            }
        }
    }

    public void save(Resource resource) throws SearchEngineException {
        this.delete(resource);
        this.create(resource);
    }

    public Resource get(Resource idResource) throws SearchEngineException {
        String alias = idResource.getAlias();
        return this.get(ResourceHelper.toIds(alias, idResource, this.searchEngineFactory.getMapping()), alias);
    }

    public Resource get(String[] ids, String alias) throws SearchEngineException {
        ResourceMapping resourceMapping = this.searchEngineFactory.getMapping().getRootMappingByAlias(alias);
        return this.get(ResourceHelper.toIds(this, ids, resourceMapping), alias);
    }

    public Resource get(Property[] ids, String alias) throws SearchEngineException {
        this.checkTransactionStarted();
        if (ids.length == 0) {
            throw new SearchEngineException("Cannot load a resource with no ids");
        }
        Resource[] result = this.transaction.find(ids, alias);
        if (result.length == 0) {
            return null;
        }
        if (result.length > 1) {
            log.warn((Object)("Found several matches in get/load operation for resource alias [" + alias + "] and ids [" + StringUtils.arrayToCommaDelimitedString(ids) + "]"));
            return result[result.length - 1];
        }
        return result[0];
    }

    public Resource load(Resource idResource) throws SearchEngineException {
        String alias = idResource.getAlias();
        Resource resource = this.get(idResource);
        if (resource == null) {
            throw new SearchEngineException("Failed to find resource with alias [" + alias + "] and ids " + idResource);
        }
        return resource;
    }

    public Resource load(String[] ids, String alias) throws SearchEngineException {
        Resource resource = this.get(ids, alias);
        if (resource == null) {
            throw new SearchEngineException("Failed to find resource with alias [" + alias + "] and ids [" + StringUtils.arrayToCommaDelimitedString(ids) + "]");
        }
        return resource;
    }

    public Resource load(Property[] ids, String alias) throws SearchEngineException {
        Resource resource = this.get(ids, alias);
        if (resource == null) {
            throw new SearchEngineException("Failed to find resource with alias [" + alias + "] and ids [" + StringUtils.arrayToCommaDelimitedString(ids) + "]");
        }
        return resource;
    }

    public SearchEngineHits find(SearchEngineQuery query) throws SearchEngineException {
        this.checkTransactionStarted();
        SearchEngineHits hits = this.transaction.find(query);
        if (log.isDebugEnabled()) {
            log.debug((Object)("RESOURCE QUERY [" + query + "] HITS [" + hits.getLength() + "]"));
        }
        return hits;
    }

    public SearchEngineHighlighter highlighter(SearchEngineQuery query) throws SearchEngineException {
        this.checkTransactionStarted();
        return this.transaction.highlighter(query);
    }

    public CompassTermInfoVector[] getTermInfos(Resource resource) throws SearchEngineException {
        this.checkTransactionStarted();
        return this.transaction.getTermInfos((LuceneResource)resource);
    }

    public CompassTermInfoVector getTermInfo(Resource resource, String propertyName) throws SearchEngineException {
        this.checkTransactionStarted();
        return this.transaction.getTermInfo((LuceneResource)resource, propertyName);
    }

    public LuceneSearchEngineFactory getSearchEngineFactory() {
        return this.searchEngineFactory;
    }
}

