/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Hits;
import org.compass.core.Resource;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.lucene.LuceneResource;
import org.compass.core.lucene.engine.AbstractLuceneSearchEngineHits;
import org.compass.core.lucene.engine.LuceneSearchEngine;
import org.compass.core.lucene.engine.LuceneSearchEngineQuery;

public class LuceneSearchEngineHits
extends AbstractLuceneSearchEngineHits {
    private Hits hits;

    public LuceneSearchEngineHits(Hits hits, List indexHolders, LuceneSearchEngine searchEngine, LuceneSearchEngineQuery query) {
        this.hits = hits;
        this.indexHolders = indexHolders;
        this.searchEngine = searchEngine;
        this.query = query;
    }

    public Resource getResource(int i) throws SearchEngineException {
        try {
            Document doc = this.hits.doc(i);
            return new LuceneResource(doc, this.hits.id(i), this.searchEngine);
        }
        catch (IOException ioe) {
            throw new SearchEngineException("Failed to find resource[" + i + "].", ioe);
        }
    }

    public int getLength() {
        return this.hits.length();
    }

    public float score(int i) throws SearchEngineException {
        try {
            return this.hits.score(i);
        }
        catch (IOException ioe) {
            throw new SearchEngineException("Failed to fetch score for resource[" + i + "].", ioe);
        }
    }
}

