/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine;

import java.util.ArrayList;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.spans.SpanQuery;
import org.compass.core.CompassQuery;
import org.compass.core.engine.SearchEngineHits;
import org.compass.core.engine.SearchEngineQuery;
import org.compass.core.engine.SearchEngineQueryFilter;
import org.compass.core.lucene.engine.LuceneSearchEngine;
import org.compass.core.lucene.engine.LuceneSearchEngineQueryFilter;

public class LuceneSearchEngineQuery
implements SearchEngineQuery {
    private LuceneSearchEngine searchEngine;
    private ArrayList sortFields = new ArrayList();
    private String[] subIndexes;
    private String[] aliases;
    private LuceneSearchEngineQueryFilter filter;
    private Query query;

    public LuceneSearchEngineQuery(LuceneSearchEngine searchEngine, Query query) {
        this.searchEngine = searchEngine;
        this.query = query;
    }

    public SearchEngineQuery addSort(String propertyName) {
        this.sortFields.add(new SortField(propertyName));
        return this;
    }

    public SearchEngineQuery addSort(String propertyName, CompassQuery.SortDirection direction) {
        this.sortFields.add(new SortField(propertyName, this.getSortReverse(direction)));
        return this;
    }

    public SearchEngineQuery addSort(String propertyName, CompassQuery.SortPropertyType type) {
        this.sortFields.add(new SortField(propertyName, this.getSortType(type)));
        return this;
    }

    public SearchEngineQuery addSort(String propertyName, CompassQuery.SortPropertyType type, CompassQuery.SortDirection direction) {
        this.sortFields.add(new SortField(propertyName, this.getSortType(type), this.getSortReverse(direction)));
        return this;
    }

    public SearchEngineQuery addSort(CompassQuery.SortImplicitType implicitType) {
        this.sortFields.add(new SortField(null, this.getImplicitSortField(implicitType)));
        return this;
    }

    public SearchEngineQuery addSort(CompassQuery.SortImplicitType implicitType, CompassQuery.SortDirection direction) {
        this.sortFields.add(new SortField(null, this.getImplicitSortField(implicitType), this.getSortReverse(direction)));
        return this;
    }

    public SearchEngineQuery addSort(SortField sortField) {
        this.sortFields.add(sortField);
        return this;
    }

    public Sort getSort() {
        if (this.sortFields.size() == 0) {
            return null;
        }
        SortField[] sortFieldsArr = this.sortFields.toArray(new SortField[this.sortFields.size()]);
        return new Sort(sortFieldsArr);
    }

    private int getImplicitSortField(CompassQuery.SortImplicitType implicitType) {
        if (implicitType == CompassQuery.SortImplicitType.DOC) {
            return 1;
        }
        if (implicitType == CompassQuery.SortImplicitType.SCORE) {
            return 0;
        }
        throw new IllegalArgumentException("Faile to create lucene implicit type for [" + implicitType + "]");
    }

    private boolean getSortReverse(CompassQuery.SortDirection direction) {
        return direction == CompassQuery.SortDirection.REVERSE;
    }

    private int getSortType(CompassQuery.SortPropertyType type) {
        if (type == CompassQuery.SortPropertyType.AUTO) {
            return 2;
        }
        if (type == CompassQuery.SortPropertyType.FLOAT) {
            return 5;
        }
        if (type == CompassQuery.SortPropertyType.INT) {
            return 4;
        }
        if (type == CompassQuery.SortPropertyType.STRING) {
            return 3;
        }
        throw new IllegalArgumentException("Faile to create lucene sort property type for [" + type + "]");
    }

    public SearchEngineHits hits() {
        return this.searchEngine.find(this);
    }

    public SearchEngineQuery setBoost(float boost) {
        this.query.setBoost(boost);
        return this;
    }

    public SearchEngineQuery setSubIndexes(String[] subindexes) {
        this.subIndexes = subindexes;
        return this;
    }

    public String[] getSubIndexes() {
        return this.subIndexes;
    }

    public SearchEngineQuery setAliases(String[] aliases) {
        this.aliases = aliases;
        return this;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public SearchEngineQuery setFilter(SearchEngineQueryFilter filter) {
        this.filter = (LuceneSearchEngineQueryFilter)filter;
        return this;
    }

    public LuceneSearchEngineQueryFilter getFilter() {
        return this.filter;
    }

    public Query getQuery() {
        return this.query;
    }

    public String toString() {
        if (this.query == null) {
            return "<null>";
        }
        return this.query.toString();
    }

    public static class LuceneSearchEngineSpanQuery
    extends LuceneSearchEngineQuery
    implements SearchEngineQuery.SearchEngineSpanQuery {
        private SpanQuery spanQuery;

        public LuceneSearchEngineSpanQuery(LuceneSearchEngine searchEngine, SpanQuery query) {
            super(searchEngine, (Query)query);
            this.spanQuery = query;
        }

        public SpanQuery toSpanQuery() {
            return this.spanQuery;
        }
    }
}

