/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.store.Lock;
import org.compass.core.CompassTransaction;
import org.compass.core.Property;
import org.compass.core.config.CompassSettings;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.util.ClassUtils;

public class LuceneSettings {
    private static final Log log = LogFactory.getLog((Class)LuceneSettings.class);
    private String connection;
    private String subContext;
    private String defaultSearchPropery;
    private String allProperty;
    private Property.TermVector allPropertyTermVector;
    private String aliasProperty;
    private CompassTransaction.TransactionIsolation transactionIsolation;
    private Class transactionIsolationClass;
    private int maxMergeDocs;
    private int mergeFactor;
    private boolean useCompoundFile;
    private int maxFieldLength;
    private int maxBufferedDocs;
    private long transactionLockTimout;
    private long transactionCommitTimeout;
    private long cacheInvalidationInterval;
    private long indexManagerScheduleInterval;
    private boolean waitForCacheInvalidationOnIndexOperation;
    private String lockDir;
    private boolean clearCacheOnCommit;

    public void configure(CompassSettings settings) throws SearchEngineException {
        String transIsolationSetting;
        this.connection = settings.getSetting("compass.engine.connection");
        if (this.connection == null) {
            throw new SearchEngineException("Lucene connection must be set in the settings. Please set [compass.engine.connection]");
        }
        this.subContext = settings.getSetting("compass.engine.connection.subContext");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using connection [" + this.connection + "][" + this.subContext + "]"));
        }
        this.aliasProperty = settings.getSetting("compass.property.alias", "alias");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using alias property [" + this.aliasProperty + "]"));
        }
        this.allProperty = settings.getSetting("compass.property.all", "all");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using default all property [" + this.allProperty + "]"));
        }
        String allPropertyTermVectorSettings = settings.getSetting("compass.property.all.termVector", "no");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using all property term vector [" + allPropertyTermVectorSettings + "]"));
        }
        if ("no".equals(allPropertyTermVectorSettings)) {
            this.allPropertyTermVector = Property.TermVector.NO;
        } else if ("yes".equals(allPropertyTermVectorSettings)) {
            this.allPropertyTermVector = Property.TermVector.YES;
        } else if ("positions".equals(allPropertyTermVectorSettings)) {
            this.allPropertyTermVector = Property.TermVector.WITH_POSITIONS;
        } else if ("offsets".equals(allPropertyTermVectorSettings)) {
            this.allPropertyTermVector = Property.TermVector.WITH_OFFSETS;
        } else if ("positions_offsets".equals(allPropertyTermVectorSettings)) {
            this.allPropertyTermVector = Property.TermVector.WITH_POSITIONS_OFFSETS;
        } else {
            throw new SearchEngineException("Unrecognized term vector setting for the all property [" + allPropertyTermVectorSettings + "]");
        }
        this.defaultSearchPropery = settings.getSetting("compass.engine.defaultsearch", this.allProperty);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using default search property [" + this.defaultSearchPropery + "]"));
        }
        if ((transIsolationSetting = settings.getSetting("compass.transaction.isolation", "read_committed")).equalsIgnoreCase("none")) {
            this.transactionIsolation = CompassTransaction.TransactionIsolation.READ_COMMITTED;
        } else if (transIsolationSetting.equalsIgnoreCase("read_uncommitted")) {
            this.transactionIsolation = CompassTransaction.TransactionIsolation.READ_COMMITTED;
        } else if (transIsolationSetting.equalsIgnoreCase("read_committed")) {
            this.transactionIsolation = CompassTransaction.TransactionIsolation.READ_COMMITTED;
        } else if (transIsolationSetting.equalsIgnoreCase("repeatable_read")) {
            this.transactionIsolation = CompassTransaction.TransactionIsolation.READ_COMMITTED;
        } else if (transIsolationSetting.equalsIgnoreCase("serializable")) {
            this.transactionIsolation = CompassTransaction.TransactionIsolation.SERIALIZABLE;
        } else if (transIsolationSetting.equalsIgnoreCase("batch_insert")) {
            this.transactionIsolation = CompassTransaction.TransactionIsolation.BATCH_INSERT;
        }
        String transIsolationClassSetting = settings.getSetting("compass.transaction.isolation.class", null);
        if (transIsolationClassSetting != null) {
            try {
                this.transactionIsolationClass = ClassUtils.forName(transIsolationClassSetting);
            }
            catch (ClassNotFoundException e) {
                throw new SearchEngineException("Can't find transaction class [" + transIsolationClassSetting + "]", e);
            }
        }
        this.transactionLockTimout = settings.getSettingAsLong("compass.transaction.lockTimeout", 10L) * 1000L;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using transaction lock timeout [" + this.transactionLockTimout + "ms]"));
        }
        this.transactionCommitTimeout = settings.getSettingAsLong("compass.transaction.commitTimeout", 10L) * 1000L;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using transaction commit timeout [" + this.transactionCommitTimeout + "ms]"));
        }
        Lock.LOCK_POLL_INTERVAL = settings.getSettingAsLong("compass.transaction.lockPollInterval", 100L);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using lock poll interval [" + Lock.LOCK_POLL_INTERVAL + "ms]"));
        }
        this.lockDir = settings.getSetting("compass.transaction.lockDir", System.getProperty("java.io.tmpdir"));
        File lockDirFile = new File(this.lockDir);
        if (!lockDirFile.exists() && !lockDirFile.mkdirs()) {
            throw new SearchEngineException("Cannot create lock directory [" + this.lockDir + "]");
        }
        System.setProperty("org.apache.lucene.lockDir", this.lockDir);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using lock directory [" + this.lockDir + "]"));
        }
        this.clearCacheOnCommit = settings.getSettingAsBoolean("compass.transaction.clearCacheOnCommit", true);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using clear cache on commit [" + this.clearCacheOnCommit + "]"));
        }
        this.maxMergeDocs = settings.getSettingAsInt("compass.engine.maxMergeDocs", Integer.MAX_VALUE);
        this.useCompoundFile = settings.getSettingAsBoolean("compass.engine.useCompoundFile", true);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using compound format [" + this.useCompoundFile + "]"));
        }
        this.mergeFactor = settings.getSettingAsInt("compass.engine.mergeFactor", 10);
        this.maxBufferedDocs = settings.getSettingAsInt("compass.engine.maxBufferedDocs", 10);
        this.maxFieldLength = settings.getSettingAsInt("compass.engine.maxFieldLength", 10000);
        this.cacheInvalidationInterval = settings.getSettingAsLong("compass.engine.cacheIntervalInvalidation", 5000L);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using cach invalidation interval [" + this.cacheInvalidationInterval + "ms]"));
        }
        this.indexManagerScheduleInterval = (long)(settings.getSettingAsFloat("compass.engine.indexManagerScheduleInterval", 60.0f) * 1000.0f);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using index manager schedule interval [" + this.indexManagerScheduleInterval + "ms]"));
        }
        this.waitForCacheInvalidationOnIndexOperation = settings.getSettingAsBoolean("compass.engine.waitForCacheInvalidationOnIndexOperation", false);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Wait for cahce invalidation on index operatrion is set to [" + this.waitForCacheInvalidationOnIndexOperation + "]"));
        }
    }

    public String getAllProperty() {
        return this.allProperty;
    }

    public void setAllProperty(String allProperty) {
        this.allProperty = allProperty;
    }

    public String getAliasProperty() {
        return this.aliasProperty;
    }

    public void setAliasProperty(String aliasProperty) {
        this.aliasProperty = aliasProperty;
    }

    public CompassTransaction.TransactionIsolation getTransactionIsolation() {
        return this.transactionIsolation;
    }

    public void setTransactionIsolation(CompassTransaction.TransactionIsolation transactionIsolation) {
        this.transactionIsolation = transactionIsolation;
    }

    public Class getTransactionIsolationClass() {
        return this.transactionIsolationClass;
    }

    public void setTransactionIsolationClass(Class transactionIsolationClass) {
        this.transactionIsolationClass = transactionIsolationClass;
    }

    public int getMaxMergeDocs() {
        return this.maxMergeDocs;
    }

    public void setMaxMergeDocs(int maxMergeDocs) {
        this.maxMergeDocs = maxMergeDocs;
    }

    public int getMergeFactor() {
        return this.mergeFactor;
    }

    public void setMergeFactor(int mergeFactor) {
        this.mergeFactor = mergeFactor;
    }

    public boolean isUseCompoundFile() {
        return this.useCompoundFile;
    }

    public void setUseCompoundFile(boolean useCompoundFile) {
        this.useCompoundFile = useCompoundFile;
    }

    public int getMaxFieldLength() {
        return this.maxFieldLength;
    }

    public void setMaxFieldLength(int maxFieldLength) {
        this.maxFieldLength = maxFieldLength;
    }

    public int getMaxBufferedDocs() {
        return this.maxBufferedDocs;
    }

    public void setMaxBufferedDocs(int maxBufferedDocs) {
        this.maxBufferedDocs = maxBufferedDocs;
    }

    public String getDefaultSearchPropery() {
        return this.defaultSearchPropery;
    }

    public void setDefaultSearchPropery(String defaultSearchPropery) {
        this.defaultSearchPropery = defaultSearchPropery;
    }

    public String getConnection() {
        return this.connection;
    }

    public void setConnection(String connection) {
        this.connection = connection;
    }

    public Property.TermVector getAllPropertyTermVector() {
        return this.allPropertyTermVector;
    }

    public void setAllPropertyTermVector(Property.TermVector allPropertyTermVector) {
        this.allPropertyTermVector = allPropertyTermVector;
    }

    public long getTransactionLockTimout() {
        return this.transactionLockTimout;
    }

    public void setTransactionLockTimout(long transactionLockTimout) {
        this.transactionLockTimout = transactionLockTimout;
    }

    public long getTransactionCommitTimeout() {
        return this.transactionCommitTimeout;
    }

    public void setTransactionCommitTimeout(long transactionCommitTimeout) {
        this.transactionCommitTimeout = transactionCommitTimeout;
    }

    public long getCacheInvalidationInterval() {
        return this.cacheInvalidationInterval;
    }

    public void setCacheInvalidationInterval(long cacheInvalidationInterval) {
        this.cacheInvalidationInterval = cacheInvalidationInterval;
    }

    public String getLockDir() {
        return this.lockDir;
    }

    public long getIndexManagerScheduleInterval() {
        return this.indexManagerScheduleInterval;
    }

    public boolean isWaitForCacheInvalidationOnIndexOperation() {
        return this.waitForCacheInvalidationOnIndexOperation;
    }

    public boolean isClearCacheOnCommit() {
        return this.clearCacheOnCommit;
    }

    public String getSubContext() {
        return this.subContext;
    }
}

