/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.analyzer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.snowball.SnowballAnalyzer;
import org.compass.core.config.CompassSettings;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.lucene.engine.analyzer.AnalyzerBuilderDelegate;
import org.compass.core.lucene.engine.analyzer.DefaultLuceneAnalyzerFactory;

public class SnowballAnalyzerBuilderDelegate
implements AnalyzerBuilderDelegate {
    private static final Log log = LogFactory.getLog((Class)SnowballAnalyzerBuilderDelegate.class);

    public Analyzer buildAnalyzer(String analyzerName, CompassSettings settings, DefaultLuceneAnalyzerFactory analyzerFactory) throws SearchEngineException {
        String snowballName = settings.getSetting("name");
        if (snowballName == null) {
            throw new SearchEngineException("When using a snowball analyzer, must set the + [name] setting for it");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Snowball Anayzer uses Name [" + snowballName + "]"));
        }
        return new SnowballAnalyzer(snowballName, analyzerFactory.parseStopWords(analyzerName, settings, new String[0]));
    }
}

