/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.highlighter;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.search.highlight.DefaultEncoder;
import org.apache.lucene.search.highlight.Encoder;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.SimpleHTMLEncoder;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.apache.lucene.search.highlight.SpanGradientFormatter;
import org.compass.core.CompassHighlighter;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.lucene.engine.highlighter.DefaultLuceneHighlighterSettings;
import org.compass.core.lucene.engine.highlighter.LuceneHighlighterFactory;
import org.compass.core.lucene.engine.highlighter.LuceneHighlighterSettings;
import org.compass.core.util.ClassUtils;

public class DefaultLuceneHighlighterFactory
implements LuceneHighlighterFactory {
    private static final Log log = LogFactory.getLog((Class)DefaultLuceneHighlighterFactory.class);

    public LuceneHighlighterSettings createHighlighterSettings(String highlighterName, CompassSettings settings) throws SearchEngineException {
        Formatter formatter = this.createFormatter(highlighterName, settings);
        Encoder encoder = this.createEncoder(highlighterName, settings);
        String fragmenterSetting = settings.getSetting("fragmenter.type", null);
        boolean shouldRewriteQuery = settings.getSettingAsBoolean("rewriteQuery", true);
        String computeIdfSetting = settings.getSetting("computeIdf");
        boolean computeIdf = computeIdfSetting == null ? this.formatterRequiresToComputeIdf(formatter) : Boolean.valueOf(computeIdfSetting).booleanValue();
        int maxNumFragments = settings.getSettingAsInt("maxNumFragments", 3);
        String separator = settings.getSetting("separator", "...");
        int maxBytesToAnalyze = settings.getSettingAsInt("maxBytesToAnalyze", 51200);
        String textTokenizerSetting = settings.getSetting("textTokenizer", CompassHighlighter.TextTokenizer.toString(CompassHighlighter.TextTokenizer.AUTO));
        CompassHighlighter.TextTokenizer textTokenizer = CompassHighlighter.TextTokenizer.fromString(textTokenizerSetting);
        DefaultLuceneHighlighterSettings highlighterSettings = new DefaultLuceneHighlighterSettings(formatter, fragmenterSetting, encoder);
        highlighterSettings.setComputeIdf(computeIdf);
        highlighterSettings.setRewriteQuery(shouldRewriteQuery);
        highlighterSettings.configure(settings);
        highlighterSettings.setMaxNumFragments(maxNumFragments);
        highlighterSettings.setSeparator(separator);
        highlighterSettings.setMaxBytesToAnalyze(maxBytesToAnalyze);
        highlighterSettings.setTextTokenizer(textTokenizer);
        return highlighterSettings;
    }

    protected boolean formatterRequiresToComputeIdf(Formatter formatter) {
        return formatter instanceof SpanGradientFormatter;
    }

    protected Encoder createEncoder(String highlighterName, CompassSettings settings) throws SearchEngineException {
        DefaultEncoder encoder;
        String encoderSetting = settings.getSetting("encoder.type", "default");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Highlighter [" + highlighterName + "] uses encoder [" + encoderSetting + "]"));
        }
        if ("default".equals(encoderSetting)) {
            encoder = new DefaultEncoder();
        } else if ("html".equals(encoderSetting)) {
            encoder = new SimpleHTMLEncoder();
        } else {
            try {
                encoder = (Encoder)ClassUtils.forName(encoderSetting).newInstance();
            }
            catch (Exception e) {
                throw new SearchEngineException("Cannot instantiate Lucene encoder [" + encoderSetting + "] for highlighter [" + highlighterName + "]. Please verify the highlighter encoder setting at [" + "encoder.type" + "]", e);
            }
            if (encoder instanceof CompassConfigurable) {
                ((CompassConfigurable)encoder).configure(settings);
            }
        }
        return encoder;
    }

    protected Formatter createFormatter(String highlighterName, CompassSettings settings) throws SearchEngineException {
        Formatter formatter;
        String formatterSettings = settings.getSetting("formatter.type", "simple");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Highlighter [" + highlighterName + "] uses formatter [" + formatterSettings + "]"));
        }
        if ("simple".equals(formatterSettings)) {
            String preTag = settings.getSetting("formatter.simple.pre", "<b>");
            String postTag = settings.getSetting("formatter.simple.post", "</b>");
            formatter = new SimpleHTMLFormatter(preTag, postTag);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Highlighter [" + highlighterName + "] uses pre [" + preTag + "] and post [" + postTag + "]"));
            }
        } else {
            if ("htmlSpanGradient".equals(formatterSettings)) {
                float maxScore = settings.getSettingAsFloat("formatter.htmlSpanGradient.maxScore", Float.MIN_VALUE);
                if (maxScore == Float.MIN_VALUE) {
                    throw new SearchEngineException("Highlighter [" + highlighterName + "] uses span formatter and must set the [" + "formatter.htmlSpanGradient.maxScore" + "] setting");
                }
                String minForegroundColor = settings.getSetting("formatter.htmlSpanGradient.minForegroundColor");
                String maxForegroundColor = settings.getSetting("formatter.htmlSpanGradient.maxForegroundColor");
                String minBackgroundColor = settings.getSetting("formatter.htmlSpanGradient.minBackgroundColor");
                String maxBackgroundColor = settings.getSetting("formatter.htmlSpanGradient.maxBackgroundColor");
                try {
                    formatter = new SpanGradientFormatter(maxScore, minForegroundColor, maxForegroundColor, minBackgroundColor, maxBackgroundColor);
                }
                catch (IllegalArgumentException e) {
                    throw new SearchEngineException("Highlighter [" + highlighterName + "] using span gradient formatter failed [" + e.getMessage() + "]");
                }
            }
            try {
                formatter = (Formatter)ClassUtils.forName(formatterSettings).newInstance();
            }
            catch (Exception e) {
                throw new SearchEngineException("Cannot instantiate Lucene formatter [" + formatterSettings + "] for highlighter [" + highlighterName + "]. Please verify the highlighter formatter setting at [" + "formatter.type" + "]", e);
            }
            if (formatter instanceof CompassConfigurable) {
                ((CompassConfigurable)formatter).configure(settings);
            }
        }
        return formatter;
    }
}

