/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.highlighter;

import org.apache.lucene.search.highlight.Encoder;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Fragmenter;
import org.apache.lucene.search.highlight.NullFragmenter;
import org.apache.lucene.search.highlight.SimpleFragmenter;
import org.compass.core.CompassHighlighter;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.lucene.engine.highlighter.LuceneHighlighterSettings;
import org.compass.core.util.ClassUtils;

public class DefaultLuceneHighlighterSettings
implements LuceneHighlighterSettings {
    private CompassSettings settings;
    private Formatter formatter;
    private String fragmenterSetting;
    private Encoder encoder;
    private boolean rewriteQuery = true;
    private boolean computeIdf = true;
    private int maxNumFragments;
    private String separator;
    private int maxBytesToAnalyze;
    private CompassHighlighter.TextTokenizer textTokenizer;

    public DefaultLuceneHighlighterSettings(Formatter formatter, String fragmenterSetting, Encoder encoder) {
        this.formatter = formatter;
        this.fragmenterSetting = fragmenterSetting;
        this.encoder = encoder;
    }

    public void configure(CompassSettings settings) throws SearchEngineException {
        this.settings = settings;
    }

    public Encoder getEncoder() throws SearchEngineException {
        return this.encoder;
    }

    public Formatter getFormatter() throws SearchEngineException {
        return this.formatter;
    }

    public Fragmenter getFragmenter() throws SearchEngineException {
        Fragmenter oFragmenter;
        if (this.fragmenterSetting == null || this.fragmenterSetting.equals("simple")) {
            int size = this.settings.getSettingAsInt("fragmenter.simple.size", 100);
            return new SimpleFragmenter(size);
        }
        if (this.fragmenterSetting.equals("null")) {
            return new NullFragmenter();
        }
        try {
            Class fragmenterClass = ClassUtils.forName(this.fragmenterSetting);
            oFragmenter = (Fragmenter)fragmenterClass.newInstance();
        }
        catch (Exception e) {
            throw new SearchEngineException("Failed to create highlighter fragmenter class [" + this.fragmenterSetting + "]", e);
        }
        if (oFragmenter instanceof CompassConfigurable) {
            ((CompassConfigurable)oFragmenter).configure(this.settings);
        }
        return oFragmenter;
    }

    public boolean isRewriteQuery() {
        return this.rewriteQuery;
    }

    public void setRewriteQuery(boolean rewriteQuery) {
        this.rewriteQuery = rewriteQuery;
    }

    public boolean isComputeIdf() {
        return this.computeIdf;
    }

    public void setComputeIdf(boolean computeIdf) {
        this.computeIdf = computeIdf;
    }

    public int getMaxNumFragments() {
        return this.maxNumFragments;
    }

    public void setMaxNumFragments(int maxNumFragments) {
        this.maxNumFragments = maxNumFragments;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public int getMaxBytesToAnalyze() {
        return this.maxBytesToAnalyze;
    }

    public void setMaxBytesToAnalyze(int maxBytesToAnalyze) {
        this.maxBytesToAnalyze = maxBytesToAnalyze;
    }

    public CompassHighlighter.TextTokenizer getTextTokenizer() {
        return this.textTokenizer;
    }

    public void setTextTokenizer(CompassHighlighter.TextTokenizer textTokenizer) {
        this.textTokenizer = textTokenizer;
    }
}

