/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.manager;

import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.LuceneUtils;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.Lock;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.engine.SearchEngineIndexManager;
import org.compass.core.lucene.engine.LuceneSearchEngineFactory;
import org.compass.core.lucene.engine.LuceneSettings;
import org.compass.core.lucene.engine.manager.LuceneSearchEngineIndexManager;
import org.compass.core.lucene.engine.store.LuceneSearchEngineStore;

public class DefaultLuceneSearchEngineIndexManager
implements LuceneSearchEngineIndexManager {
    private static Log log = LogFactory.getLog((Class)DefaultLuceneSearchEngineIndexManager.class);
    public static final String CLEAR_CACHE_NAME = "clearcache";
    private LuceneSearchEngineFactory searchEngineFactory;
    private LuceneSearchEngineStore searchEngineStore;
    private LuceneSettings luceneSettings;
    private HashMap indexHolders = new HashMap();
    private HashMap dirs = new HashMap();
    private long[] lastModifiled;
    private long waitForCacheInvalidationBeforeSecondStep = 0L;
    private boolean isRunning = false;

    public DefaultLuceneSearchEngineIndexManager(LuceneSearchEngineFactory searchEngineFactory, LuceneSearchEngineStore searchEngineStore) {
        this.searchEngineFactory = searchEngineFactory;
        this.searchEngineStore = searchEngineStore;
        this.luceneSettings = searchEngineFactory.getLuceneSettings();
    }

    public void createIndex() throws SearchEngineException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating index " + this.searchEngineStore));
        }
        this.clearCache();
        this.searchEngineStore.createIndex();
    }

    public void deleteIndex() throws SearchEngineException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deleting index " + this.searchEngineStore));
        }
        this.clearCache();
        this.searchEngineStore.deleteIndex();
    }

    public boolean verifyIndex() throws SearchEngineException {
        this.clearCache();
        boolean result = this.searchEngineStore.verifyIndex();
        if (this.luceneSettings.isUseCompoundFile() && !this.isIndexCompound()) {
            log.info((Object)"Setting using compound file, but the index is not in compound form, compounding the index...");
            this.compoundIndex();
        } else if (!this.luceneSettings.isUseCompoundFile() && !this.isIndexUnCompound()) {
            log.info((Object)"Setting not using compound file, but the index is in compound form, un-compounding the index...");
            this.unCompoundIndex();
        }
        return result;
    }

    public boolean indexExists() throws SearchEngineException {
        return this.searchEngineStore.indexExists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void operate(SearchEngineIndexManager.IndexOperationCallback callback) throws SearchEngineException {
        String[] subIndexes = this.searchEngineStore.getSubIndexes();
        Lock[] writerLocks = new Lock[subIndexes.length];
        Lock[] commitLocks = new Lock[subIndexes.length];
        try {
            boolean continueToSecondStep;
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Trying to obtain write locks");
                }
                for (int i = 0; i < subIndexes.length; ++i) {
                    Directory dir = this.getDirectory(subIndexes[i]);
                    writerLocks[i] = dir.makeLock("write.lock");
                    writerLocks[i].obtain(this.luceneSettings.getTransactionLockTimout());
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Obtained write locks");
                }
            }
            catch (Exception e) {
                throw new SearchEngineException("Failed to retirieve dirty transaction locks", e);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Calling callback first step");
            }
            if (!(continueToSecondStep = callback.firstStep())) {
                return;
            }
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Trying to obtain commit/read locks");
                }
                for (int i = 0; i < subIndexes.length; ++i) {
                    Directory dir = this.getDirectory(subIndexes[i]);
                    commitLocks[i] = dir.makeLock("commit.lock");
                    commitLocks[i].obtain(this.luceneSettings.getTransactionCommitTimeout());
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Obtained commit/read locks");
                }
            }
            catch (Exception e) {
                throw new SearchEngineException("Failed to retrieve commit transaction locks", e);
            }
            this.clearCache();
            this.notifyAllToClearCache();
            if (this.waitForCacheInvalidationBeforeSecondStep != 0L && this.luceneSettings.isWaitForCacheInvalidationOnIndexOperation()) {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Waiting [" + this.waitForCacheInvalidationBeforeSecondStep + "ms] for global cache invalidation"));
                    }
                    Thread.sleep(this.waitForCacheInvalidationBeforeSecondStep);
                }
                catch (InterruptedException e) {
                    log.debug((Object)"Interrupted while waiting for cache invalidation", (Throwable)e);
                    throw new SearchEngineException("Interrupted while waiting for cache invalidation", e);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Calling callback second step");
            }
            callback.secondStep();
        }
        finally {
            org.compass.core.lucene.util.LuceneUtils.clearLocks(commitLocks);
            org.compass.core.lucene.util.LuceneUtils.clearLocks(writerLocks);
        }
    }

    public void replaceIndex(SearchEngineIndexManager indexManager, final SearchEngineIndexManager.ReplaceIndexCallback callback) throws SearchEngineException {
        final LuceneSearchEngineIndexManager luceneIndexManager = (LuceneSearchEngineIndexManager)indexManager;
        this.operate(new SearchEngineIndexManager.IndexOperationCallback(){

            public boolean firstStep() throws SearchEngineException {
                callback.buildIndexIfNeeded();
                return true;
            }

            public void secondStep() throws SearchEngineException {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("[Replace Index] Replacing index [" + DefaultLuceneSearchEngineIndexManager.this.searchEngineStore + "] with [" + luceneIndexManager.getStore() + "]"));
                }
                DefaultLuceneSearchEngineIndexManager.this.searchEngineStore.copyFrom(luceneIndexManager.getStore());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("[Replace Index] Index [" + DefaultLuceneSearchEngineIndexManager.this.searchEngineStore + "] replaced from [" + luceneIndexManager.getStore() + "]"));
                }
            }
        });
    }

    public void notifyAllToClearCache() throws SearchEngineException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Global notification to clear cache");
        }
        String[] subIndexes = this.searchEngineStore.getSubIndexes();
        for (int i = 0; i < subIndexes.length; ++i) {
            Directory dir = this.getDirectory(subIndexes[i]);
            try {
                if (!dir.fileExists(CLEAR_CACHE_NAME)) {
                    dir.createOutput(CLEAR_CACHE_NAME).close();
                    continue;
                }
                dir.touchFile(CLEAR_CACHE_NAME);
                continue;
            }
            catch (IOException e) {
                throw new SearchEngineException("Failed to update/generate global invalidation cahce", e);
            }
        }
    }

    public synchronized boolean isCached(String subIndex) throws SearchEngineException {
        return this.indexHolders.get(subIndex) != null;
    }

    public boolean isCached() throws SearchEngineException {
        String[] subIndexes = this.searchEngineStore.getSubIndexes();
        for (int i = 0; i < subIndexes.length; ++i) {
            if (!this.isCached(subIndexes[i])) continue;
            return true;
        }
        return false;
    }

    public synchronized void clearCache() throws SearchEngineException {
        String[] subIndexes = this.searchEngineStore.getSubIndexes();
        for (int i = 0; i < subIndexes.length; ++i) {
            this.clearCache(subIndexes[i]);
        }
    }

    public synchronized void clearCache(String subIndex) throws SearchEngineException {
        Directory dir;
        LuceneSearchEngineIndexManager.LuceneIndexHolder indexHolder = (LuceneSearchEngineIndexManager.LuceneIndexHolder)this.indexHolders.remove(subIndex);
        if (indexHolder != null) {
            indexHolder.markForClose();
        }
        if ((dir = (Directory)this.dirs.remove(subIndex)) != null) {
            try {
                this.searchEngineStore.closeDirectory(dir);
            }
            catch (Exception e) {
                log.error((Object)("Failed to clear cached index directory for sub-index [" + subIndex + "]"), (Throwable)e);
            }
        }
    }

    public synchronized LuceneSearchEngineIndexManager.LuceneIndexHolder openIndexHolderByAlias(String alias) throws SearchEngineException {
        String subIndex = this.searchEngineStore.getSubIndexForAlias(alias);
        return this.openIndexHolderBySubIndex(subIndex);
    }

    public synchronized LuceneSearchEngineIndexManager.LuceneIndexHolder openIndexHolderBySubIndex(String subIndex) throws SearchEngineException {
        try {
            Directory dir = this.getDirectory(subIndex);
            LuceneSearchEngineIndexManager.LuceneIndexHolder indexHolder = (LuceneSearchEngineIndexManager.LuceneIndexHolder)this.indexHolders.get(subIndex);
            if (this.shouldInvalidateCache(dir, indexHolder)) {
                this.clearCache(subIndex);
                dir = this.getDirectory(subIndex);
                indexHolder = new LuceneSearchEngineIndexManager.LuceneIndexHolder(new IndexSearcher(dir));
                this.indexHolders.put(subIndex, indexHolder);
            }
            indexHolder.acquire();
            return indexHolder;
        }
        catch (Exception e) {
            throw new SearchEngineException("Failed to open index searcher for sub-index [" + subIndex + "]", e);
        }
    }

    protected boolean shouldInvalidateCache(Directory dir, LuceneSearchEngineIndexManager.LuceneIndexHolder indexHolder) throws IOException, IllegalAccessException {
        long currentTime = System.currentTimeMillis();
        if (indexHolder == null) {
            return true;
        }
        if (this.luceneSettings.getCacheInvalidationInterval() == -1L) {
            return false;
        }
        if (currentTime - indexHolder.getLastCacheInvalidation() > this.luceneSettings.getCacheInvalidationInterval()) {
            indexHolder.setLastCacheInvalidation(currentTime);
            if (!indexHolder.getIndexReader().isCurrent()) {
                return true;
            }
        }
        return false;
    }

    public synchronized void close() {
        this.clearCache();
        this.searchEngineStore.close();
    }

    public IndexWriter openIndexWriter(Directory dir, boolean create) throws IOException {
        IndexWriter indexWriter = new IndexWriter(dir, this.searchEngineFactory.getAnalyzerManager().getDefaultAnalyzer(), create);
        indexWriter.setMaxMergeDocs(this.luceneSettings.getMaxMergeDocs());
        indexWriter.setMergeFactor(this.luceneSettings.getMergeFactor());
        indexWriter.setUseCompoundFile(this.luceneSettings.isUseCompoundFile());
        indexWriter.setMaxFieldLength(this.luceneSettings.getMaxFieldLength());
        indexWriter.setMaxBufferedDocs(this.luceneSettings.getMaxBufferedDocs());
        return indexWriter;
    }

    public void closeIndexWriter(IndexWriter indexWriter, Directory dir) throws SearchEngineException {
        Exception ex = null;
        try {
            this.closeIndexWriter(indexWriter);
        }
        catch (Exception e) {
            ex = e;
        }
        try {
            this.searchEngineStore.closeDirectory(dir);
        }
        catch (Exception e) {
            if (ex == null) {
                ex = e;
            }
            log.warn((Object)"Caught an exception trying to close the lucene directory with other exception pending, logging and ignoring", (Throwable)e);
        }
        if (ex != null) {
            if (ex instanceof SearchEngineException) {
                throw (SearchEngineException)ex;
            }
            throw new SearchEngineException("Failed while executing a lucene directory based operation", ex);
        }
    }

    protected void closeIndexWriter(IndexWriter indexWriter) throws SearchEngineException {
        try {
            if (indexWriter != null) {
                indexWriter.close();
            }
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to close index reader", e);
        }
    }

    public LuceneSearchEngineStore getStore() {
        return this.searchEngineStore;
    }

    public Directory getDirectory(String subIndex) {
        Directory dir = (Directory)this.dirs.get(subIndex);
        if (dir == null) {
            dir = this.getStore().getDirectoryBySubIndex(subIndex, false);
            this.dirs.put(subIndex, dir);
        }
        return dir;
    }

    public void start() {
        this.isRunning = true;
    }

    public void stop() {
        this.isRunning = false;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public synchronized void checkAndClearIfNotifiedAllToClearCache() throws SearchEngineException {
        Directory dir;
        int i;
        String[] subIndexes;
        if (this.lastModifiled == null) {
            subIndexes = this.searchEngineStore.getSubIndexes();
            for (i = 0; i < subIndexes.length; ++i) {
                dir = this.getDirectory(subIndexes[i]);
                try {
                    if (dir.fileExists(CLEAR_CACHE_NAME)) {
                        continue;
                    }
                }
                catch (IOException e) {
                    throw new SearchEngineException("Failed to check if global clear cache exists", e);
                }
                try {
                    dir.createOutput(CLEAR_CACHE_NAME).close();
                    continue;
                }
                catch (IOException e) {
                    throw new SearchEngineException("Failed to update/generate global invalidation cahce", e);
                }
            }
            this.lastModifiled = new long[subIndexes.length];
            for (i = 0; i < subIndexes.length; ++i) {
                dir = this.getDirectory(subIndexes[i]);
                try {
                    this.lastModifiled[i] = dir.fileModified(CLEAR_CACHE_NAME);
                    continue;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        subIndexes = this.searchEngineStore.getSubIndexes();
        for (i = 0; i < subIndexes.length; ++i) {
            long lastMod;
            dir = this.getDirectory(subIndexes[i]);
            try {
                lastMod = dir.fileModified(CLEAR_CACHE_NAME);
            }
            catch (IOException e) {
                throw new SearchEngineException("Failed to check last modified on global index chache on sub index [" + subIndexes[i] + "]", e);
            }
            if (this.lastModifiled[i] >= lastMod) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Global notification to clear cache detected on sub index [" + subIndexes[i] + "]"));
            }
            this.lastModifiled[i] = lastMod;
            this.clearCache(subIndexes[i]);
        }
    }

    public boolean isIndexCompound() throws SearchEngineException {
        String[] subIndexes = this.searchEngineStore.getSubIndexes();
        for (int i = 0; i < subIndexes.length; ++i) {
            Directory dir = this.getDirectory(subIndexes[i]);
            try {
                if (LuceneUtils.isCompound(dir, this.luceneSettings.getTransactionCommitTimeout())) continue;
                return false;
            }
            catch (IOException e) {
                throw new SearchEngineException("Failed to check if index is compound", e);
            }
        }
        return true;
    }

    public boolean isIndexUnCompound() throws SearchEngineException {
        String[] subIndexes = this.searchEngineStore.getSubIndexes();
        for (int i = 0; i < subIndexes.length; ++i) {
            Directory dir = this.getDirectory(subIndexes[i]);
            try {
                if (LuceneUtils.isUnCompound(dir, this.luceneSettings.getTransactionCommitTimeout())) continue;
                return false;
            }
            catch (IOException e) {
                throw new SearchEngineException("Failed to check if index is unCompound", e);
            }
        }
        return true;
    }

    public void compoundIndex() throws SearchEngineException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Compounding index " + this.searchEngineStore));
        }
        String[] subIndexes = this.searchEngineStore.getSubIndexes();
        for (int i = 0; i < subIndexes.length; ++i) {
            Directory dir = this.getDirectory(subIndexes[i]);
            try {
                LuceneUtils.compoundDirectory(dir, this.luceneSettings.getTransactionLockTimout(), this.luceneSettings.getTransactionCommitTimeout());
                continue;
            }
            catch (IOException e) {
                throw new SearchEngineException("Failed to compound index", e);
            }
        }
    }

    public void unCompoundIndex() throws SearchEngineException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("UnCompounding index " + this.searchEngineStore));
        }
        String[] subIndexes = this.searchEngineStore.getSubIndexes();
        for (int i = 0; i < subIndexes.length; ++i) {
            Directory dir = this.getDirectory(subIndexes[i]);
            try {
                LuceneUtils.unCompoundDirectory(dir, this.luceneSettings.getTransactionLockTimout(), this.luceneSettings.getTransactionCommitTimeout());
                continue;
            }
            catch (IOException e) {
                throw new SearchEngineException("Failed to unCompuond index", e);
            }
        }
    }

    public void setWaitForCacheInvalidationBeforeSecondStep(long timeToWaitInMillis) {
        this.waitForCacheInvalidationBeforeSecondStep = timeToWaitInMillis;
    }

    public LuceneSettings getSettings() {
        return this.luceneSettings;
    }
}

