/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.manager;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.engine.SearchEngineIndexManager;
import org.compass.core.lucene.engine.LuceneSettings;
import org.compass.core.lucene.engine.store.LuceneSearchEngineStore;

public interface LuceneSearchEngineIndexManager
extends SearchEngineIndexManager {
    public LuceneSettings getSettings();

    public LuceneSearchEngineStore getStore();

    public IndexWriter openIndexWriter(Directory var1, boolean var2) throws IOException;

    public void closeIndexWriter(IndexWriter var1, Directory var2) throws SearchEngineException;

    public LuceneIndexHolder openIndexHolderByAlias(String var1) throws SearchEngineException;

    public LuceneIndexHolder openIndexHolderBySubIndex(String var1) throws SearchEngineException;

    public void setWaitForCacheInvalidationBeforeSecondStep(long var1);

    public boolean isIndexCompound() throws SearchEngineException;

    public boolean isIndexUnCompound() throws SearchEngineException;

    public void compoundIndex() throws SearchEngineException;

    public void unCompoundIndex() throws SearchEngineException;

    public static class LuceneIndexHolder {
        private long lastCacheInvalidation = System.currentTimeMillis();
        private Directory dir;
        private IndexSearcher indexSearcher;
        private int count = 0;
        private boolean markForClose = false;

        public LuceneIndexHolder(Directory dir) throws IOException {
            this.dir = dir;
            this.indexSearcher = new IndexSearcher(dir);
        }

        public LuceneIndexHolder(IndexSearcher indexSearcher) throws IOException {
            this.indexSearcher = indexSearcher;
        }

        public IndexSearcher getIndexSearcher() {
            return this.indexSearcher;
        }

        public IndexReader getIndexReader() {
            return this.indexSearcher.getIndexReader();
        }

        public synchronized void acquire() {
            ++this.count;
        }

        public synchronized void release() {
            --this.count;
            this.checkIfCanClose();
        }

        public synchronized void markForClose() {
            this.markForClose = true;
            this.checkIfCanClose();
        }

        private void checkIfCanClose() {
            if (this.markForClose && this.count <= 0) {
                try {
                    this.indexSearcher.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (this.dir != null) {
                    try {
                        this.dir.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        public long getLastCacheInvalidation() {
            return this.lastCacheInvalidation;
        }

        public void setLastCacheInvalidation(long lastCacheInvalidation) {
            this.lastCacheInvalidation = lastCacheInvalidation;
        }
    }
}

