/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.manager;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.engine.SearchEngineIndexManager;
import org.compass.core.lucene.engine.LuceneSettings;
import org.compass.core.lucene.engine.manager.LuceneSearchEngineIndexManager;
import org.compass.core.lucene.engine.store.LuceneSearchEngineStore;
import org.compass.core.util.backport.java.util.concurrent.Executors;
import org.compass.core.util.backport.java.util.concurrent.ScheduledExecutorService;
import org.compass.core.util.backport.java.util.concurrent.TimeUnit;
import org.compass.core.util.concurrent.SingleThreadThreadFactory;

public class ScheduledLuceneSearchEngineIndexManager
implements LuceneSearchEngineIndexManager {
    private static Log log = LogFactory.getLog((Class)ScheduledLuceneSearchEngineIndexManager.class);
    private LuceneSearchEngineIndexManager indexManager;
    private ScheduledExecutorService scheduledExecutorService;
    private LuceneSettings settings;

    public ScheduledLuceneSearchEngineIndexManager(LuceneSearchEngineIndexManager indexManager) {
        this.indexManager = indexManager;
        this.settings = indexManager.getSettings();
    }

    public void start() {
        this.indexManager.start();
        if (this.settings.getIndexManagerScheduleInterval() < 0L) {
            log.info((Object)"Not starting scheduled index manager");
            return;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Starting scheduled index manager with period [" + this.settings.getIndexManagerScheduleInterval() + "ms] daemon [true]"));
        }
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new SingleThreadThreadFactory("Compass Scheduled IndexManager", true));
        ScheduledIndexManagerRunnable scheduledIndexManagerRunnable = new ScheduledIndexManagerRunnable(this.indexManager);
        long period = this.settings.getIndexManagerScheduleInterval();
        this.scheduledExecutorService.scheduleWithFixedDelay(scheduledIndexManagerRunnable, period, period, TimeUnit.MILLISECONDS);
        this.setWaitForCacheInvalidationBeforeSecondStep((long)((double)this.settings.getIndexManagerScheduleInterval() * 1.1));
    }

    public void stop() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Stopping scheduled index manager");
        }
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdown();
            this.scheduledExecutorService = null;
        }
        this.indexManager.stop();
    }

    public boolean isRunning() {
        return this.indexManager.isRunning();
    }

    public void close() {
        this.stop();
        this.indexManager.close();
    }

    public void createIndex() throws SearchEngineException {
        this.indexManager.createIndex();
    }

    public boolean verifyIndex() throws SearchEngineException {
        return this.indexManager.verifyIndex();
    }

    public void deleteIndex() throws SearchEngineException {
        this.indexManager.deleteIndex();
    }

    public boolean indexExists() throws SearchEngineException {
        return this.indexManager.indexExists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void operate(SearchEngineIndexManager.IndexOperationCallback callback) throws SearchEngineException {
        this.stop();
        try {
            this.indexManager.operate(callback);
        }
        finally {
            this.start();
        }
    }

    public void replaceIndex(SearchEngineIndexManager innerIndexManager, SearchEngineIndexManager.ReplaceIndexCallback callback) throws SearchEngineException {
        this.indexManager.replaceIndex(innerIndexManager, callback);
    }

    public boolean isCached(String subIndex) throws SearchEngineException {
        return this.indexManager.isCached(subIndex);
    }

    public boolean isCached() throws SearchEngineException {
        return this.indexManager.isCached();
    }

    public void clearCache(String subIndex) throws SearchEngineException {
        this.indexManager.clearCache(subIndex);
    }

    public void clearCache() throws SearchEngineException {
        this.indexManager.clearCache();
    }

    public void notifyAllToClearCache() throws SearchEngineException {
        this.indexManager.notifyAllToClearCache();
    }

    public void checkAndClearIfNotifiedAllToClearCache() throws SearchEngineException {
        this.indexManager.checkAndClearIfNotifiedAllToClearCache();
    }

    public boolean isIndexCompound() throws SearchEngineException {
        return this.indexManager.isIndexCompound();
    }

    public boolean isIndexUnCompound() throws SearchEngineException {
        return this.indexManager.isIndexUnCompound();
    }

    public void compoundIndex() throws SearchEngineException {
        this.indexManager.compoundIndex();
    }

    public void unCompoundIndex() throws SearchEngineException {
        this.indexManager.unCompoundIndex();
    }

    public LuceneSettings getSettings() {
        return this.indexManager.getSettings();
    }

    public LuceneSearchEngineStore getStore() {
        return this.indexManager.getStore();
    }

    public IndexWriter openIndexWriter(Directory dir, boolean create) throws IOException {
        return this.indexManager.openIndexWriter(dir, create);
    }

    public void closeIndexWriter(IndexWriter indexWriter, Directory dir) throws SearchEngineException {
        this.indexManager.closeIndexWriter(indexWriter, dir);
    }

    public LuceneSearchEngineIndexManager.LuceneIndexHolder openIndexHolderByAlias(String alias) throws SearchEngineException {
        return this.indexManager.openIndexHolderByAlias(alias);
    }

    public LuceneSearchEngineIndexManager.LuceneIndexHolder openIndexHolderBySubIndex(String subIndex) throws SearchEngineException {
        return this.indexManager.openIndexHolderBySubIndex(subIndex);
    }

    public void setWaitForCacheInvalidationBeforeSecondStep(long timeToWaitInMillis) {
        this.indexManager.setWaitForCacheInvalidationBeforeSecondStep(timeToWaitInMillis);
    }

    private static class ScheduledIndexManagerRunnable
    implements Runnable {
        private LuceneSearchEngineIndexManager indexManager;

        public ScheduledIndexManagerRunnable(LuceneSearchEngineIndexManager indexManager) {
            this.indexManager = indexManager;
        }

        public void run() {
            block6: {
                block5: {
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Checking for global cache invalidation");
                        }
                        this.indexManager.checkAndClearIfNotifiedAllToClearCache();
                    }
                    catch (Exception e) {
                        if (!log.isDebugEnabled()) break block5;
                        log.debug((Object)"Failed to check clear cache", (Throwable)e);
                    }
                }
                try {
                    this.indexManager.getStore().performScheduledTasks();
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block6;
                    log.debug((Object)"Failed to perform schedule task", (Throwable)e);
                }
            }
        }
    }
}

