/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.optimizer;

import java.io.IOException;
import org.apache.lucene.index.LuceneSegmentsMerger;
import org.apache.lucene.index.LuceneSubIndexInfo;
import org.apache.lucene.store.Directory;
import org.compass.core.CompassException;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.lucene.engine.manager.LuceneSearchEngineIndexManager;
import org.compass.core.lucene.engine.optimizer.AbstractLuceneSearchEngineOptimizer;

public class AdaptiveOptimizer
extends AbstractLuceneSearchEngineOptimizer
implements CompassConfigurable {
    private int mergeFactor;

    public void configure(CompassSettings settings) throws CompassException {
        this.mergeFactor = settings.getSettingAsInt("compass.engine.optimizer.adaptive.mergeFactor", 10);
    }

    public boolean canBeScheduled() {
        return true;
    }

    protected boolean isOptimizeOnlyIfIndexChanged() {
        return false;
    }

    public boolean doNeedOptimizing(String subIndex, LuceneSubIndexInfo indexInfo) {
        if (indexInfo.size() >= this.mergeFactor) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Need to optimize sub-index [" + subIndex + "]. Number of segments " + indexInfo.size() + " is larger than [" + this.mergeFactor + "]"));
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doOptimize(String subIndex, LuceneSubIndexInfo indexInfo) throws SearchEngineException {
        block18: {
            LuceneSubIndexInfo.LuceneSegmentInfo segmentInfo;
            if (indexInfo.size() < this.mergeFactor) {
                return;
            }
            int threshold = this.mergeFactor - 1;
            long count = 0L;
            for (int i = indexInfo.size() - 1; i >= threshold; --i) {
                count += (long)indexInfo.info(i).docCount();
            }
            int mergeFromSegment = 0;
            for (mergeFromSegment = threshold; mergeFromSegment > 0 && count >= (long)(segmentInfo = indexInfo.info(mergeFromSegment - 1)).docCount(); count += (long)segmentInfo.docCount(), --mergeFromSegment) {
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Optimizing sub-index [" + subIndex + "] from [" + mergeFromSegment + "]"));
            }
            LuceneSearchEngineIndexManager indexManager = this.getSearchEngineFactory().getLuceneIndexManager();
            LuceneSegmentsMerger segmentsMerger = null;
            try {
                long time = System.currentTimeMillis();
                Directory dir = indexManager.getStore().getDirectoryBySubIndex(subIndex, false);
                segmentsMerger = new LuceneSegmentsMerger(dir, true, this.getSearchEngineFactory().getLuceneSettings());
                long lockTime = System.currentTimeMillis() - time;
                time = System.currentTimeMillis();
                segmentsMerger.mergeFromSegment(mergeFromSegment);
                long mergeTime = System.currentTimeMillis() - time;
                time = System.currentTimeMillis();
                segmentsMerger.commit();
                long commitTime = System.currentTimeMillis() - time;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Optimization of sub-index [" + subIndex + "] took [" + (commitTime + mergeTime + lockTime) + "ms], Locking took [" + lockTime + "ms], merge took [" + mergeTime + "ms], and commit took [" + commitTime + "ms]."));
                }
                indexManager.clearCache(subIndex);
            }
            catch (IOException e) {
                if (e.getMessage().startsWith("Lock obtain")) {
                    this.log.warn((Object)("Failed to obtain lock on sub-index [" + subIndex + "], will do it next time."));
                    break block18;
                }
                throw new SearchEngineException("Failed to optimize sub-index [" + subIndex + "]", e);
            }
            finally {
                if (segmentsMerger != null) {
                    try {
                        segmentsMerger.close();
                    }
                    catch (IOException e) {
                        this.log.warn((Object)"Failed to close optimizer segment merger, ignoring", (Throwable)e);
                    }
                }
            }
        }
    }
}

