/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.query;

import java.util.ArrayList;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.compass.core.engine.SearchEngineQuery;
import org.compass.core.engine.SearchEngineQueryBuilder;
import org.compass.core.engine.SearchEngineQueryParseException;
import org.compass.core.lucene.engine.LuceneSearchEngine;
import org.compass.core.lucene.engine.LuceneSearchEngineQuery;
import org.compass.core.lucene.util.LuceneMultiFieldQueryParser;

public class LuceneSearchEngineMultiPropertyQueryStringBuilder
implements SearchEngineQueryBuilder.SearchEngineMultiPropertyQueryStringBuilder {
    private LuceneSearchEngine searchEngine;
    private Analyzer analyzer;
    private String queryString;
    private QueryParser.Operator operator = QueryParser.Operator.OR;
    private ArrayList propertyNames = new ArrayList();

    public LuceneSearchEngineMultiPropertyQueryStringBuilder(LuceneSearchEngine searchEngine, String queryString) {
        this.searchEngine = searchEngine;
        this.queryString = queryString;
        this.analyzer = searchEngine.getSearchEngineFactory().getAnalyzerManager().getSearchAnalyzer();
    }

    public SearchEngineQueryBuilder.SearchEngineMultiPropertyQueryStringBuilder setAnalyzer(String analyzer) {
        this.analyzer = this.searchEngine.getSearchEngineFactory().getAnalyzerManager().getAnalyzerMustExist(analyzer);
        return this;
    }

    public SearchEngineQueryBuilder.SearchEngineMultiPropertyQueryStringBuilder setAnalyzerByAlias(String alias) {
        this.analyzer = this.searchEngine.getSearchEngineFactory().getAnalyzerManager().getAnalyzerByAliasMustExists(alias);
        return this;
    }

    public SearchEngineQueryBuilder.SearchEngineMultiPropertyQueryStringBuilder add(String resourcePropertyName) {
        this.propertyNames.add(resourcePropertyName);
        return this;
    }

    public SearchEngineQueryBuilder.SearchEngineMultiPropertyQueryStringBuilder useAndDefaultOperator() {
        this.operator = QueryParser.Operator.AND;
        return this;
    }

    public SearchEngineQuery toQuery() {
        Query qQuery;
        try {
            LuceneMultiFieldQueryParser queryParser = new LuceneMultiFieldQueryParser(this.propertyNames.toArray(new String[this.propertyNames.size()]), this.analyzer);
            queryParser.setDefaultOperator(this.operator);
            qQuery = queryParser.parse(this.queryString);
        }
        catch (ParseException e) {
            throw new SearchEngineQueryParseException(this.queryString, e);
        }
        return new LuceneSearchEngineQuery(this.searchEngine, qQuery);
    }
}

